/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.actor;

import com.caucho.env.actor.ActorProcessor;
import com.caucho.util.L10N;

abstract class AbstractActorQueueBuilder<T> {
    private static final L10N L = new L10N(AbstractActorQueueBuilder.class);
    private ActorProcessor<? super T>[] _processors;
    private int _initial;
    private int _capacity;
    private boolean _isMultiworker;
    private int _multiworkerOffset = 4;

    AbstractActorQueueBuilder() {
    }

    public AbstractActorQueueBuilder<T> processors(ActorProcessor<? super T> ... processors) {
        if (processors == null) {
            throw new NullPointerException();
        }
        if (processors.length == 0) {
            throw new IllegalArgumentException();
        }
        this._processors = processors;
        return this;
    }

    public ActorProcessor<? super T>[] getProcessors() {
        return this._processors;
    }

    public AbstractActorQueueBuilder<T> capacity(int capacity) {
        this._capacity = capacity;
        return this;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public AbstractActorQueueBuilder<T> initial(int initial) {
        this._initial = initial;
        return this;
    }

    public int getInitial() {
        return this._initial;
    }

    public AbstractActorQueueBuilder<T> multiworker(boolean isMultiworker) {
        this._isMultiworker = isMultiworker;
        return this;
    }

    public boolean isMultiworker() {
        return this._isMultiworker;
    }

    public AbstractActorQueueBuilder<T> multiworkerOffset(int offset) {
        this._multiworkerOffset = offset;
        return this;
    }

    public int getMultiworkerOffset() {
        return this._multiworkerOffset;
    }

    protected void validateFullBuilder() {
        if (this._processors == null) {
            throw new IllegalStateException(L.l("processors is required"));
        }
        this.validateBuilder();
    }

    protected void validateBuilder() {
        if (this._capacity <= 0) {
            throw new IllegalStateException(L.l("capacity is required"));
        }
    }
}

