/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.PathPatternType;
import com.caucho.env.deploy.DeployContainerApi;
import com.caucho.env.deploy.DeployController;
import com.caucho.env.deploy.DeployControllerApi;
import com.caucho.env.deploy.DeployControllerService;
import com.caucho.env.deploy.DeployInstance;
import com.caucho.env.deploy.DeployNotificationListener;
import com.caucho.env.deploy.DeployTagItem;
import com.caucho.env.deploy.RepositoryDependency;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.env.repository.Repository;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.repository.RepositorySystem;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.env.repository.RepositoryTagListener;
import com.caucho.env.service.ResinSystem;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.make.DependencyContainer;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ExpandDeployController<I extends DeployInstance>
extends DeployController<I>
implements RepositoryTagListener {
    private static final L10N L = new L10N(ExpandDeployController.class);
    private static final Logger log = Logger.getLogger(ExpandDeployController.class.getName());
    public static final String APPLICATION_HASH_PATH = "META-INF/resin.application-hash";
    private final String _autoDeployStage;
    private Path _rootDirectory;
    private Path _archivePath;
    private DeployContainerApi<?> _container;
    private String _rootHash;
    private boolean _isAllowRepository = true;
    private Repository _repository;
    private RepositorySpi _repositorySpi;
    private FileSetType _expandCleanupFileSet;
    private DeployTagItem _deployItem;
    private DeployListener _deployListener;
    private DependencyContainer _depend = new DependencyContainer();
    private long _dependencyCheckInterval = this._depend.getCheckInterval();
    private Dependency _versionDependency;
    private Object _applicationExtractLock = new Object();
    private DynamicClassLoader _manifestLoader;
    private Manifest _manifest;

    protected ExpandDeployController(String id) {
        this(id, null, null, null);
    }

    protected ExpandDeployController(String id, ClassLoader loader, Path rootDirectory, DeployContainerApi<?> container) {
        super(id, loader);
        if (rootDirectory == null) {
            rootDirectory = Vfs.getPwd(this.getParentClassLoader());
        }
        this._rootDirectory = rootDirectory;
        this._container = container;
        this._autoDeployStage = "server-" + ResinSystem.getCurrentId();
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    protected void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public Path getArchivePath() {
        return this._archivePath;
    }

    public void setArchivePath(Path path) {
        this._archivePath = path;
    }

    public void setAllowRepository(boolean isAllowRepository) {
        this._isAllowRepository = isAllowRepository;
    }

    public boolean isAllowRepository() {
        return this._isAllowRepository;
    }

    public Repository getRepository() {
        return this._repository;
    }

    public Manifest getManifest() {
        return this._manifest;
    }

    public Map<String, String> getManifestAttributes() {
        if (this._manifest == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        Attributes attr = this._manifest.getMainAttributes();
        if (attr != null) {
            for (Map.Entry<Object, Object> entry : attr.entrySet()) {
                map.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        return map;
    }

    public void addParentExpandCleanupFileSet(FileSetType fileSet) {
        if (this._expandCleanupFileSet == null) {
            this._expandCleanupFileSet = fileSet;
        } else {
            this._expandCleanupFileSet.add(fileSet);
        }
    }

    @Configurable
    public void addExpandCleanupFileSet(PathPatternType include) {
        if (this._expandCleanupFileSet == null) {
            this._expandCleanupFileSet = new FileSetType();
        }
        this._expandCleanupFileSet.addInclude(include);
    }

    @Configurable
    public void addExpandPreserveFileset(PathPatternType exclude) {
        if (this._expandCleanupFileSet == null) {
            this._expandCleanupFileSet = new FileSetType();
        }
        this._expandCleanupFileSet.addExclude(exclude);
    }

    public String getAutoDeployStage() {
        return this._autoDeployStage;
    }

    public void setDependencyCheckInterval(long period) {
        this._dependencyCheckInterval = period;
        this._depend.setCheckInterval(period);
    }

    @Override
    protected void initEnd() {
        RepositorySystem repositoryService;
        super.initEnd();
        if (this.isAllowRepository() && (repositoryService = RepositorySystem.getCurrent()) != null) {
            this._repository = repositoryService.getRepository();
            this._repository.addListener(this.getId(), this);
            this._repositorySpi = repositoryService.getRepositorySpi();
        }
        DeployControllerService deployService = DeployControllerService.getCurrent();
        deployService.addTag(this.getId());
        this._deployItem = deployService.getTagItem(this.getId());
        if (this._container != null) {
            this._deployListener = new DeployListener(this._container, this.getId());
            this._deployItem.addNotificationListener(this._deployListener);
        }
        this._rootHash = this.readRootHash();
    }

    @Override
    public void merge(DeployControllerApi<I> newControllerV) {
        super.merge(newControllerV);
        ExpandDeployController newController = (ExpandDeployController)newControllerV;
        if (newController._expandCleanupFileSet != null) {
            this._expandCleanupFileSet = newController._expandCleanupFileSet;
        }
        if (newController.getArchivePath() != null) {
            this.setArchivePath(newController.getArchivePath());
        }
    }

    public void deploy() {
        this.deployImpl();
    }

    protected void deployImpl() {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " deploying");
        }
        try {
            this.extractApplication();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void undeploy() {
        this.undeployImpl();
    }

    protected void undeployImpl() {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " undeploying");
        }
        try {
            this.removeExpandDirectory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void preConfigureInstance(I deployInstance) throws Exception {
        this.extractApplication();
        this.addManifestClassPath();
        super.preConfigureInstance(deployInstance);
    }

    @Override
    protected void configureInstance(I deployInstance) throws Exception {
        super.configureInstance(deployInstance);
    }

    @Override
    protected void postConfigureInstance(I deployInstance) throws Exception {
        super.postConfigureInstance(deployInstance);
        this.addDependencies();
    }

    @Override
    public void onTagChange(String tag) {
        this.alarm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractApplication() throws IOException {
        for (int i = 0; !this.commitArchiveIgnoreException() && i < 3; ++i) {
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.commitArchive();
        Object object = this._applicationExtractLock;
        synchronized (object) {
            boolean isExtract = this.extractFromRepository();
            this.postExtract(isExtract);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postExtract(boolean isExtract) throws IOException {
        Path path = this.getRootDirectory().lookup("META-INF/MANIFEST.MF");
        if (path.canRead()) {
            ReadStream is = path.openRead();
            try {
                this._manifest = new Manifest(is);
            }
            catch (IOException e) {
                log.warning(L.l("{0} Manifest file cannot be read for '{1}'.\n  {2}", (Object)this, (Object)this.getRootDirectory(), (Object)e));
                log.log(Level.FINE, e.toString(), e);
            }
            finally {
                is.close();
            }
        }
    }

    protected void addManifestClassPath() throws IOException {
        DynamicClassLoader loader = Environment.getDynamicClassLoader();
        if (loader == null) {
            return;
        }
        Manifest manifest = this.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes main = manifest.getMainAttributes();
        if (main == null) {
            return;
        }
        String classPath = main.getValue("Class-Path");
        Path pwd = null;
        pwd = this.getArchivePath() != null ? this.getArchivePath().getParent() : this.getRootDirectory();
        if (classPath != null) {
            if (this._manifestLoader != null) {
                this._manifestLoader.addManifestClassPath(classPath, pwd);
            } else {
                loader.addManifestClassPath(classPath, pwd);
            }
        }
    }

    public String getAutoDeployTag() {
        return this.getAutoDeployStage() + "/" + this.getIdType() + "/" + this.getIdKey();
    }

    private boolean commitArchiveIgnoreException() {
        try {
            return this.commitArchive();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    private boolean commitArchive() throws IOException {
        Path archivePath = this.getArchivePath();
        if (archivePath == null) {
            return true;
        }
        if (!archivePath.canRead()) {
            return true;
        }
        String hash = Long.toHexString(archivePath.getCrc64());
        CommitBuilder commit = new CommitBuilder();
        commit.stage(this.getAutoDeployStage());
        commit.type(this.getIdType());
        commit.tagKey(this.getIdKey());
        String commitId = commit.getId();
        RepositoryTagEntry tagEntry = this._repositorySpi.getTagMap().get(commitId);
        if (tagEntry != null && hash.equals(tagEntry.getAttributeMap().get("archive-digest"))) {
            return true;
        }
        commit.attribute("archive-digest", hash);
        commit.message(".war added to repository from " + archivePath.getNativePath());
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " adding archive to repository from " + archivePath);
        }
        this._repository.commitArchive(commit, archivePath);
        return true;
    }

    private boolean extractFromRepository() throws IOException {
        try {
            if (this._repositorySpi == null) {
                return false;
            }
            String tag = this.getId();
            String treeHash = this._repositorySpi.getTagContentHash(tag);
            Path archivePath = this.getArchivePath();
            if (treeHash != null && archivePath != null && archivePath.canRead()) {
                throw new ConfigException(L.l("{0} cannot be deployed from both an archive {1} and cluster deployment.", (Object)this, (Object)archivePath.getNativePath()));
            }
            if (treeHash == null) {
                tag = this.getAutoDeployTag();
                treeHash = this._repositorySpi.getTagContentHash(tag);
            }
            if (treeHash == null) {
                return false;
            }
            if (treeHash.equals(this._rootHash)) {
                return false;
            }
            Path pwd = this.getRootDirectory();
            pwd.mkdirs();
            this.removeExpandDirectory(pwd);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " extract from repository tag=" + tag + "\n  root=" + this.getRootDirectory() + "\n  contentHash=" + treeHash);
            }
            this._repositorySpi.expandToPath(treeHash, pwd);
            this.writeRootHash(treeHash);
            this._rootHash = treeHash;
            return true;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readRootHash() {
        Path path = this._rootDirectory.lookup(APPLICATION_HASH_PATH);
        ReadStream is = null;
        try {
            String rootHash;
            is = path.openRead();
            String string = rootHash = is.readLine();
            return string;
        }
        catch (FileNotFoundException e) {
            log.log(Level.ALL, e.toString(), e);
            String string = null;
            return string;
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            String string = null;
            return string;
        }
        finally {
            IoUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRootHash(String hash) throws IOException {
        Path path = this._rootDirectory.lookup(APPLICATION_HASH_PATH);
        WriteStream os = null;
        try {
            path.getParent().mkdirs();
            os = path.openWrite();
            os.println(hash);
        }
        catch (Throwable throwable) {
            IoUtil.close(os);
            throw throwable;
        }
        IoUtil.close(os);
    }

    @Override
    protected boolean isControllerModified() {
        return this._depend.isModified();
    }

    @Override
    protected boolean isControllerModifiedNow() {
        return this._depend.isModified();
    }

    @Override
    protected final boolean controllerLogModified(Logger log) {
        return this._depend.logModified(log);
    }

    protected void addDependencies() {
        this._depend = new DependencyContainer();
        this._depend.setCheckInterval(this._dependencyCheckInterval);
        if (this.getArchivePath() != null) {
            this._depend.add(new Depend(this.getArchivePath()));
        }
        if (this._repositorySpi != null) {
            String value = this._repositorySpi.getTagContentHash(this.getId());
            this._depend.add(new RepositoryDependency(this.getId(), value));
            value = this._repositorySpi.getTagContentHash(this.getAutoDeployTag());
            this._depend.add(new RepositoryDependency(this.getAutoDeployTag(), value));
        }
    }

    public Dependency getVersionDependency() {
        return this._versionDependency;
    }

    public void setVersionDependency(Dependency versionDependency) {
        this._versionDependency = versionDependency;
    }

    protected void removeExpandDirectory() {
        Path pwd = this.getRootDirectory();
        if (pwd.isDirectory()) {
            this.removeExpandDirectory(pwd);
        }
    }

    protected void removeExpandDirectory(Path path) {
        String prefix = path.getPath();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        this.removeExpandDirectory(path, prefix);
    }

    public Throwable getConfigException() {
        return null;
    }

    protected void removeExpandDirectory(Path path, String prefix) {
        try {
            if (path.isDirectory() && !path.isLink()) {
                String[] list = path.list();
                for (int i = 0; list != null && i < list.length; ++i) {
                    this.removeExpandDirectory(path.lookup(list[i]), prefix);
                }
            }
            this.removeExpandFile(path, prefix);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected void removeExpandFile(Path path, String prefix) throws IOException {
        if (this._expandCleanupFileSet == null || this._expandCleanupFileSet.isMatch(path, prefix)) {
            path.remove();
        }
    }

    @Override
    protected void onActive() {
        super.onActive();
        if (this._deployItem != null && !"error".equals(this._deployItem.getStateName())) {
            this._deployItem.onStart();
        }
    }

    @Override
    protected void onError(Throwable e) {
        super.onError(e);
        if (this._deployItem != null) {
            this._deployItem.toError(e);
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this._deployItem != null) {
            this._deployItem.toStop();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this._deployItem != null) {
            this._deployItem.removeNotificationListener(this._deployListener);
        }
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        String tag = this.getId();
        String treeHash = null;
        if (this._repositorySpi != null) {
            treeHash = this._repositorySpi.getTagContentHash(tag);
        }
        String rootHash = this._rootHash;
        if (treeHash == null && rootHash != null) {
            this.undeploy();
        }
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DeployController controller = (DeployController)o;
        return this.getId().equals(controller.getId());
    }

    static class DeployListener
    implements DeployNotificationListener {
        private WeakReference<DeployContainerApi<?>> _container;
        private String _tag;

        DeployListener(DeployContainerApi<?> container, String tag) {
            this._container = new WeakReference(container);
            this._tag = tag;
        }

        @Override
        public void onStart() {
            Object controller;
            DeployContainerApi container = (DeployContainerApi)this._container.get();
            if (container != null && (controller = container.findControllerById(this._tag)) != null) {
                controller.start();
            }
        }

        @Override
        public void onStop() {
            Object controller;
            DeployContainerApi container = (DeployContainerApi)this._container.get();
            if (container != null && (controller = container.findControllerById(this._tag)) != null) {
                controller.stop();
            }
        }
    }
}

