/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.git;

import com.caucho.env.git.GitCommit;
import com.caucho.env.git.GitObjectStream;
import com.caucho.env.git.GitTree;
import com.caucho.env.git.GitType;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectorySystem;
import com.caucho.util.CurrentTime;
import com.caucho.util.Hex;
import com.caucho.util.L10N;
import com.caucho.util.NullOutputStream;
import com.caucho.util.ResinDeflaterOutputStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class GitSystem
extends AbstractResinSubSystem {
    public static final int START_PRIORITY = 21;
    private static final L10N L = new L10N(GitSystem.class);
    private static final Logger log = Logger.getLogger(GitSystem.class.getName());
    private Path _root;

    public GitSystem(Path root) {
        this._root = root;
    }

    public static GitSystem createAndAddService() {
        return GitSystem.createAndAddService(null);
    }

    public static GitSystem createAndAddService(Path root) {
        ResinSystem system = GitSystem.preCreate(GitSystem.class);
        GitSystem service = new GitSystem(root);
        system.addService(GitSystem.class, service);
        return service;
    }

    public static GitSystem getCurrent() {
        return ResinSystem.getCurrentService(GitSystem.class);
    }

    @Override
    public int getStartPriority() {
        return 21;
    }

    @Override
    public void start() throws IOException {
        if (this._root == null) {
            this._root = RootDirectorySystem.getCurrentDataDirectory().lookup(".git");
        }
        if (this._root.lookup("HEAD").canRead()) {
            return;
        }
        this._root.mkdirs();
        this._root.lookup("refs").mkdir();
        this._root.lookup("refs/heads").mkdir();
        this._root.lookup("objects").mkdir();
        this._root.lookup("objects/info").mkdir();
        this._root.lookup("objects/pack").mkdir();
        this._root.lookup("branches").mkdir();
        this._root.lookup("tmp").mkdir();
        WriteStream out = this._root.lookup("HEAD").openWrite();
        try {
            out.println("ref: refs/heads/master");
        }
        finally {
            out.close();
        }
    }

    public String getMaster() {
        return this.getTag("heads/master");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitType objectType(String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        try {
            GitType gitType = is.getType();
            return gitType;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTag(String tag) {
        Path path = this.getRefPath(tag);
        GitSystem gitSystem = this;
        synchronized (gitSystem) {
            if (!path.canRead()) {
                return null;
            }
            ReadStream is = null;
            try {
                is = path.openRead();
                String hex = is.readLine();
                if (hex != null) {
                    String string2 = hex.trim();
                    return string2;
                }
                String string = null;
                return string;
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
                String string3 = null;
                return string3;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTag(String tag, String hex) {
        Path path = this.getRefPath(tag);
        try {
            path.getParent().mkdirs();
        }
        catch (IOException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        GitSystem gitSystem = this;
        synchronized (gitSystem) {
            WriteStream out = null;
            try {
                out = path.openWrite();
                out.println(hex);
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
            }
        }
    }

    public String[] listRefs(String dir) {
        try {
            Path path = this.getRefPath(dir);
            if (path.isDirectory()) {
                return path.list();
            }
            return new String[0];
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return new String[0];
        }
    }

    private ArrayList<String> allRefs() {
        ArrayList<String> refs = new ArrayList<String>();
        try {
            this.allRefs(refs, this._root.lookup("refs"));
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return refs;
    }

    private void allRefs(ArrayList<String> refs, Path path) throws IOException {
        if (path.isFile()) {
            String prefix;
            String name = path.getFullPath();
            String suffix = name.substring((prefix = this._root.lookup("refs").getFullPath()).length() + 1);
            if (!refs.contains(suffix)) {
                refs.add(suffix);
            }
        } else if (path.isDirectory()) {
            for (String file : path.list()) {
                this.allRefs(refs, path.lookup(file));
            }
        }
    }

    private Path getRefPath(String path) {
        return this._root.lookup("refs").lookup(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitCommit parseCommit(String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        try {
            if (is.getType() != GitType.COMMIT) {
                throw new IOException(L.l("'{0}' is an unexpected type, expected 'commit'", (Object)is.getType()));
            }
            GitCommit gitCommit = is.parseCommit();
            return gitCommit;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitTree parseTree(String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        try {
            if (GitType.TREE != is.getType()) {
                throw new IOException(L.l("'{0}' is an unexpected type, expected 'tree'", (Object)is.getType()));
            }
            GitTree gitTree = is.parseTree();
            return gitTree;
        }
        finally {
            is.close();
        }
    }

    public InputStream openBlob(String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        if (is.getType() != GitType.BLOB) {
            is.close();
            throw new IOException(L.l("'{0}' is an unexpected type, expected 'blob'", (Object)is.getType()));
        }
        return is;
    }

    public void expandToPath(Path path, String sha1) throws IOException {
        long now = CurrentTime.getCurrentTime();
        this.expandToPath(path, sha1, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandToPath(Path path, String sha1, long now) throws IOException {
        block15: {
            GitObjectStream is = this.open(sha1);
            try {
                if (GitType.TREE == is.getType()) {
                    GitTree tree = is.parseTree();
                    is.close();
                    this.expandTreeToPath(path, tree, now);
                    break block15;
                }
                if (GitType.BLOB == is.getType()) {
                    String pathSha1;
                    if (path.canRead() && path.getLength() == is.getLength() && sha1.equals(pathSha1 = this.getBlobSha1(path))) {
                        return;
                    }
                    if (path.getTail().endsWith(".war") || path.getTail().endsWith(".jar") || path.getTail().endsWith(".ear")) {
                        ZipInputStream zis = new ZipInputStream(is);
                        try {
                            this.expandZipToPath(zis, path.getParent());
                        }
                        finally {
                            zis.close();
                        }
                        return;
                    }
                    WriteStream os = path.openWrite();
                    try {
                        os.writeStream(is.getInputStream());
                    }
                    finally {
                        os.close();
                    }
                    path.setLastModified(now);
                    break block15;
                }
                throw new IOException(L.l("'{0}' is an unexpected type, expected 'blob' or 'tree'", (Object)is.getType()));
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandZipToPath(ZipInputStream is, Path path) throws IOException {
        ZipEntry entry;
        while ((entry = is.getNextEntry()) != null) {
            String name = entry.getName();
            while (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (entry.isDirectory()) {
                path.lookup(name).mkdirs();
                continue;
            }
            Path subPath = path.lookup(name);
            subPath.getParent().mkdirs();
            WriteStream os = subPath.openWrite();
            try {
                os.writeStream(is);
            }
            finally {
                os.close();
            }
        }
    }

    private void expandTreeToPath(Path path, GitTree tree, long now) throws IOException {
        path.mkdirs();
        for (GitTree.Entry entry : tree.entries()) {
            String name = entry.getName();
            this.expandToPath(path.lookup(name), entry.getSha1(), now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToFile(Path path, String sha1) throws IOException {
        GitObjectStream is = this.open(sha1);
        try {
            if (GitType.BLOB != is.getType()) {
                throw new IOException(L.l("'{0}' is an unexpected type, expected 'blob'", (Object)is.getType()));
            }
            WriteStream os = path.openWrite();
            try {
                os.writeStream(is.getInputStream());
            }
            finally {
                os.close();
            }
        }
        finally {
            is.close();
        }
    }

    public boolean contains(String hash) {
        return this.lookup(hash).exists();
    }

    public Path lookup(String hash) {
        String prefix = hash.substring(0, 2);
        String suffix = hash.substring(2);
        Path path = this._root.lookup("objects").lookup(prefix).lookup(suffix);
        return path;
    }

    public boolean remove(String hash) {
        String prefix = hash.substring(0, 2);
        String suffix = hash.substring(2);
        Path path = this._root.lookup("objects").lookup(prefix).lookup(suffix);
        try {
            return path.remove();
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
    }

    public void gc(long expireTime) {
        ArrayList<String> activeList = new ArrayList<String>();
        for (String ref : this.allRefs()) {
            try {
                this.activeHashes(this.getTag(ref), activeList);
            }
            catch (IOException e) {
                log.warning("GC: " + ref + " " + e.toString());
                log.log(Level.FINER, e.toString(), e);
                return;
            }
        }
        long now = CurrentTime.getCurrentTimeActual();
        ArrayList<String> fileList = this.fileHashes();
        for (String hash : fileList) {
            Path path;
            long delta;
            if (activeList.contains(hash) || (delta = now - (path = this.lookup(hash)).getLastModified()) <= expireTime) continue;
            try {
                path.remove();
            }
            catch (IOException e) {
                log.warning(this + ": " + path + ": " + e);
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    public ArrayList<String> fileHashes() {
        try {
            ArrayList<String> hashes = new ArrayList<String>();
            Path objects = this._root.lookup("objects");
            for (String prefix : objects.list()) {
                if (prefix.length() != 2) continue;
                for (String suffix : objects.lookup(prefix).list()) {
                    if (suffix.length() <= 10) continue;
                    hashes.add(prefix + suffix);
                }
            }
            return hashes;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ArrayList<String> activeHashes(String hash) {
        try {
            ArrayList<String> hashes = new ArrayList<String>();
            this.activeHashes(hash, hashes);
            return hashes;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void activeHashes(String hash, ArrayList<String> hashes) throws IOException {
        GitTree tree;
        if (hash == null || hash.length() < 10) {
            return;
        }
        if (hashes.contains(hash)) {
            return;
        }
        hashes.add(hash);
        GitType type = this.objectType(hash);
        if (type == GitType.COMMIT) {
            GitCommit commit = this.parseCommit(hash);
            if (commit != null) {
                this.activeHashes(commit.getTree(), hashes);
                this.activeHashes(commit.getParent(), hashes);
            }
        } else if (type == GitType.TREE && (tree = this.parseTree(hash)) != null) {
            for (GitTree.Entry entry : tree.entries()) {
                this.activeHashes(entry.getSha1(), hashes);
            }
        }
    }

    public GitObjectStream open(String sha1) throws IOException {
        String prefix = sha1.substring(0, 2);
        String suffix = sha1.substring(2);
        Path path = this._root.lookup("objects").lookup(prefix).lookup(suffix);
        return new GitObjectStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(Path path) throws IOException {
        ReadStream is = path.openRead();
        try {
            TempOutputStream os = new TempOutputStream();
            String type = "blob";
            String hex = GitSystem.writeData(os, type, is, path.getLength());
            String string = this.writeFile(os, hex);
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBlobSha1(Path path) throws IOException {
        ReadStream is = path.openRead();
        try {
            String hex;
            NullOutputStream os = new NullOutputStream();
            String type = "blob";
            String string = hex = GitSystem.writeData(os, type, is, path.getLength());
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public String writeInputStream(InputStream is) throws IOException {
        TempStream tempOs = new TempStream();
        WriteStream out = new WriteStream(tempOs);
        out.writeStream(is);
        out.close();
        int length = tempOs.getLength();
        String type = "blob";
        TempOutputStream os = new TempOutputStream();
        String sha1 = GitSystem.writeData(os, type, tempOs.getInputStream(), length);
        return this.writeFile(os, sha1);
    }

    public String writeInputStream(InputStream is, long length) throws IOException {
        String type = "blob";
        TempOutputStream os = new TempOutputStream();
        String sha1 = GitSystem.writeData(os, type, is, length);
        return this.writeFile(os, sha1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeTree(GitTree tree) throws IOException {
        TempOutputStream treeOut = new TempOutputStream();
        tree.toData(treeOut);
        int treeLength = treeOut.getLength();
        ReadStream is = treeOut.openRead();
        try {
            TempOutputStream os = new TempOutputStream();
            String type = "tree";
            String hex = GitSystem.writeData(os, type, is, treeLength);
            String string = this.writeFile(os, hex);
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeCommit(GitCommit commit) throws IOException {
        Map<String, String> attr;
        TempStream commitOut = new TempStream();
        WriteStream out = new WriteStream(commitOut);
        out.print("tree ");
        out.println(commit.getTree());
        String parent = commit.getParent();
        if (parent != null) {
            out.print("parent ");
            out.println(parent);
        }
        if ((attr = commit.getMetaData()) != null) {
            ArrayList<String> keys = new ArrayList<String>(attr.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                out.print(key);
                out.print(' ');
                out.print(attr.get(key));
                out.println();
            }
        }
        out.println();
        if (commit.getMessage() != null) {
            out.println(commit.getMessage());
        }
        out.close();
        int commitLength = commitOut.getLength();
        ReadStream is = commitOut.openRead();
        try {
            TempOutputStream os = new TempOutputStream();
            String type = "commit";
            String hex = GitSystem.writeData(os, type, is, commitLength);
            String string = this.writeFile(os, hex);
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(TempOutputStream os, String hex) throws IOException {
        Path objectPath = this.lookupPath(hex);
        if (objectPath.exists()) {
            return hex;
        }
        objectPath.getParent().mkdirs();
        Path tmpDir = this._root.lookup("tmp");
        tmpDir.mkdirs();
        Path tmp = this._root.lookup("tmp").lookup("tmp." + hex);
        WriteStream tmpOs = tmp.openWrite();
        try {
            tmpOs.writeStream(os.openRead());
        }
        finally {
            tmpOs.close();
        }
        tmp.renameTo(objectPath);
        return hex;
    }

    public InputStream openRawGitFile(String sha1) throws IOException {
        Path objectPath = this.lookupPath(sha1);
        return objectPath.openRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeRawGitFile(String sha1, InputStream is) throws IOException {
        Path objectPath = this.lookupPath(sha1);
        if (objectPath.exists()) {
            return sha1;
        }
        objectPath.getParent().mkdirs();
        Path tmpDir = this._root.lookup("tmp");
        tmpDir.mkdirs();
        Path tmp = this._root.lookup("tmp").lookup("tmp." + sha1);
        try {
            WriteStream tmpOut = tmp.openWrite();
            try {
                tmpOut.writeStream(is);
            }
            finally {
                tmpOut.close();
            }
            String newHex = this.validate(tmp);
            if (!sha1.equals(newHex)) {
                throw new RuntimeException(L.l("{0}: file validation failed because sha-1 hash '{0}' does not match expected '{1}'", (Object)newHex, (Object)sha1));
            }
            tmp.renameTo(objectPath);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " addRawGitFile " + sha1 + " " + objectPath);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            tmp.remove();
        }
        return sha1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateRawGitFile(String sha1) {
        Path objectPath = this.lookupPath(sha1);
        if (!objectPath.exists()) {
            return;
        }
        boolean isValid = false;
        try {
            String newHex = this.validate(objectPath);
            if (sha1.equals(newHex)) {
                isValid = true;
            } else {
                log.warning(L.l("{0}: file validation failed because sha-1 hash '{0}' does not match expected '{1}'", (Object)newHex, (Object)sha1));
            }
        }
        catch (Exception e) {
            log.warning("git service " + sha1 + " " + e.toString());
        }
        finally {
            if (!isValid) {
                try {
                    objectPath.remove();
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
        }
    }

    private Path lookupPath(String sha1) {
        String prefix = sha1.substring(0, 2);
        String suffix = sha1.substring(2);
        return this._root.lookup("objects").lookup(prefix).lookup(suffix);
    }

    public static GitType validate(String hash, InputStream is) throws IOException, NoSuchAlgorithmException {
        int len;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        InflaterInputStream zin = new InflaterInputStream(is);
        DigestInputStream din = new DigestInputStream(zin, md);
        TempBuffer tBuf = TempBuffer.allocate();
        byte[] buffer = tBuf.getBuffer();
        GitType gitType = null;
        while ((len = din.read(buffer, 0, buffer.length)) >= 0) {
            if (gitType != null) continue;
            String value = new String(buffer, 0, len);
            if (value.startsWith("blob")) {
                gitType = GitType.BLOB;
                continue;
            }
            if (value.startsWith("tree")) {
                gitType = GitType.TREE;
                continue;
            }
            if (!value.startsWith("commit")) continue;
            gitType = GitType.COMMIT;
        }
        TempBuffer.free(tBuf);
        din.close();
        byte[] digest = md.digest();
        String digestHash = Hex.toHex(digest);
        if (!hash.equals(digestHash)) {
            throw new IOException(L.l("Git file corrupted.\n  expected: {0}\n actual: {1}", (Object)hash, (Object)digestHash));
        }
        return gitType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String validate(Path path) throws IOException, NoSuchAlgorithmException {
        ReadStream is = path.openRead();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            InflaterInputStream zin = new InflaterInputStream(is);
            DigestInputStream din = new DigestInputStream(zin, md);
            TempBuffer tBuf = TempBuffer.allocate();
            byte[] buffer = tBuf.getBuffer();
            while (din.read(buffer, 0, buffer.length) >= 0) {
            }
            TempBuffer.free(tBuf);
            din.close();
            byte[] digest = md.digest();
            String string = Hex.toHex(digest);
            return string;
        }
        finally {
            is.close();
        }
    }

    public static String writeData(OutputStream os, String type, InputStream is, long length) throws IOException {
        TempBuffer buf = TempBuffer.allocate();
        try {
            int len;
            ResinDeflaterOutputStream out = new ResinDeflaterOutputStream(os);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            for (int i = 0; i < type.length(); ++i) {
                char ch = type.charAt(i);
                out.write(ch);
                md.update((byte)ch);
            }
            out.write(32);
            md.update((byte)32);
            String lengthString = String.valueOf(length);
            for (int i = 0; i < lengthString.length(); ++i) {
                char ch = lengthString.charAt(i);
                out.write(ch);
                md.update((byte)ch);
            }
            out.write(0);
            md.update((byte)0);
            long readLength = 0L;
            byte[] buffer = buf.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, len);
                md.update(buffer, 0, len);
                readLength += (long)len;
            }
            out.close();
            if (readLength != length) {
                throw new IOException(L.l("written length does not match data"));
            }
            String string = Hex.toHex(md.digest());
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        finally {
            TempBuffer.free(buf);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._root + "]";
    }
}

