/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.git;

import com.caucho.util.Hex;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class GitTree {
    private HashMap<String, Entry> _treeMap = new LinkedHashMap<String, Entry>();

    public void addEntry(String name, int mode, String sha1) {
        this._treeMap.put(name, new Entry(name, mode, sha1));
    }

    public HashMap<String, Entry> getMap() {
        return this._treeMap;
    }

    public String getHash(String name) {
        Entry entry = this.getMap().get(name);
        if (entry != null) {
            return entry.getSha1();
        }
        return null;
    }

    public void addBlob(String name, int mode, String sha1) {
        Entry entry = new Entry(name, 0x8000 | mode & 0x1FF, sha1);
        this._treeMap.put(name, entry);
    }

    public void addDir(String name, String sha1) {
        Entry entry = new Entry(name, 16384, sha1);
        this._treeMap.put(name, entry);
    }

    public Collection<Entry> entries() {
        return this._treeMap.values();
    }

    public void toData(OutputStream out) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(this._treeMap.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            int i;
            Entry entry = this._treeMap.get(key);
            String mode = String.format("%o", entry.getMode());
            int len = mode.length();
            for (i = 0; i < len; ++i) {
                out.write(mode.charAt(i));
            }
            out.write(32);
            len = key.length();
            for (i = 0; i < len; ++i) {
                out.write(key.charAt(i));
            }
            out.write(0);
            String sha1 = entry.getSha1();
            byte[] hash = Hex.toBytes(sha1);
            out.write(hash, 0, hash.length);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    public class Entry {
        private final String _name;
        private final int _mode;
        private final String _sha1;

        Entry(String name, int mode, String sha1) {
            this._name = name;
            this._mode = mode;
            this._sha1 = sha1;
        }

        public String getName() {
            return this._name;
        }

        public int getMode() {
            return this._mode;
        }

        public String getSha1() {
            return this._sha1;
        }

        public boolean isDir() {
            return (this._mode & 0x3FE00) == 16384;
        }

        public boolean isFile() {
            return (this._mode & 0x3FE00) == 32768;
        }

        public String toString() {
            return "GitTree.Entry[" + this._name + "," + String.format("%o", this._mode) + "," + this._sha1 + "]";
        }
    }
}

