/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.BamException;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.RemoteListenerUnavailableException;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.client.LinkConnection;
import com.caucho.bam.client.LinkConnectionFactory;
import com.caucho.cloud.security.SecurityService;
import com.caucho.hmtp.AuthResult;
import com.caucho.hmtp.ClientAuthManager;
import com.caucho.hmtp.HmtpLinkConnection;
import com.caucho.hmtp.HmtpWebSocketListener;
import com.caucho.hmtp.NonceQuery;
import com.caucho.hmtp.SignedCredentials;
import com.caucho.remote.websocket.WebSocketClient;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.websocket.WebSocketListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.logging.Level;
import java.util.logging.Logger;

class HmtpLinkFactory
implements LinkConnectionFactory {
    private static final L10N L = new L10N(HmtpLinkFactory.class);
    private static final Logger log = Logger.getLogger(HmtpLinkFactory.class.getName());
    private String _url;
    private String _address;
    private String _virtualHost;
    private WebSocketClient _webSocketClient;
    private WebSocketListener _webSocketHandler;
    private String _user;
    private String _password;
    private Serializable _credentials;
    private BamException _connException;
    private ClientAuthManager _authManager = new ClientAuthManager();
    private boolean _isMasked;

    public void setUrl(String url) {
        this._url = url;
    }

    public void setVirtualHost(String host) {
        this._virtualHost = host;
    }

    public void setEncryptPassword(boolean isEncrypt) {
    }

    public void setMasked(boolean isMasked) {
        this._isMasked = isMasked;
    }

    public void connect() {
    }

    public void connect(String user, String password) {
        this._user = user;
        this._password = password;
    }

    public void connect(String user, Serializable credentials) {
        this._user = user;
        this._credentials = credentials;
    }

    @Override
    public LinkConnection open(Broker broker) {
        try {
            HmtpWebSocketListener webSocketHandler = new HmtpWebSocketListener(broker);
            WebSocketClient oldClient = this._webSocketClient;
            this._webSocketClient = new WebSocketClient(this._url, webSocketHandler);
            if (oldClient != null) {
                oldClient.close(1000, "ok");
            }
            if (this._virtualHost != null) {
                this._webSocketClient.setVirtualHost(this._virtualHost);
            }
            this._webSocketClient.setConnectTimeout(15000L);
            this._webSocketClient.setMasked(this._isMasked);
            this._webSocketClient.connect();
            return new HmtpLinkConnection(this._webSocketClient, webSocketHandler);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ConnectException e) {
            String msg = "Cannot connect to " + this._url + "\n  " + e;
            throw new RemoteConnectionFailedException(msg, e);
        }
        catch (IOException e) {
            String msg = "Cannot establish HTTP protocol connection to " + this._url + "\n  " + e;
            throw new RemoteListenerUnavailableException(msg, e);
        }
    }

    protected void loginImpl(String uid, Serializable credentials) {
        try {
            if (uid == null) {
                uid = "";
            }
            if (credentials == null) {
                credentials = "";
            }
            if (!(credentials instanceof SignedCredentials) && credentials instanceof String) {
                String password = (String)credentials;
                String clientNonce = String.valueOf(CurrentTime.getCurrentTime());
                NonceQuery nonceQuery = new NonceQuery("", uid, clientNonce);
                NonceQuery nonceResult = null;
                String algorithm = nonceResult.getAlgorithm();
                String serverNonce = nonceResult.getNonce();
                String serverSignature = nonceResult.getSignature();
                String testSignature = this._authManager.sign(algorithm, uid, clientNonce, password);
                if (!testSignature.equals(serverSignature) && "".equals(uid)) {
                    throw new BamException(L.l("{0} server signature does not match", (Object)this));
                }
                String signature = this._authManager.sign(algorithm, uid, serverNonce, password);
                SecurityService security = SecurityService.getCurrent();
                credentials = "".equals(uid) ? new SignedCredentials(uid, serverNonce, signature) : security.createCredentials(algorithm, uid, password, serverNonce);
            }
            AuthResult result = null;
            this._address = result.getAddress();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " login");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getAddress() {
        return this._address;
    }

    public String getBrokerAddress() {
        String address = this.getAddress();
        if (address == null) {
            return null;
        }
        int p = address.indexOf(64);
        int q = address.indexOf(47);
        if (p >= 0 && q >= 0) {
            return address.substring(p + 1, q);
        }
        if (p >= 0) {
            return address.substring(p + 1);
        }
        if (q >= 0) {
            return address.substring(0, q);
        }
        return address;
    }

    public void flush() throws IOException {
    }

    public void close() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close");
        }
        if (this._webSocketClient != null) {
            this._webSocketClient.close(1000, "ok");
        }
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._url + "]";
    }
}

