/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.actor.ActorHolder;
import com.caucho.bam.stream.MessageStream;
import com.caucho.hmtp.HmtpWebSocketReader;
import com.caucho.hmtp.HmtpWebSocketWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HmtpLinkWorker
implements Runnable {
    protected InputStream _is;
    protected OutputStream _os;
    private String _address;
    private MessageStream _actorStream;
    private HmtpWebSocketWriter _toLinkStream;
    private HmtpWebSocketReader _in;

    public HmtpLinkWorker(ActorHolder actor, InputStream is, OutputStream os) throws IOException {
        this._actorStream = actor.getActor();
        this._is = is;
        this._os = os;
        this._toLinkStream = new HmtpWebSocketWriter(this._os);
        this._in = new HmtpWebSocketReader(this._is);
        actor.setBroker(this._toLinkStream);
    }

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public MessageStream getLinkStream() {
        return this._toLinkStream;
    }

    public MessageStream getActorStream() {
        MessageStream stream = this._actorStream;
        if (stream != null) {
            return stream;
        }
        throw new RemoteConnectionFailedException("connection has been closed");
    }

    public boolean isClosed() {
        return this._actorStream == null;
    }

    @Override
    public void run() {
        try {
            while (!this.isClosed() && this._in.readPacket(this._actorStream)) {
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this._actorStream = null;
    }
}

