/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp;

import com.caucho.bam.stream.MessageStream;
import com.caucho.hmtp.HmtpReader;
import com.caucho.remote.websocket.UnmaskedFrameInputStream;
import com.caucho.remote.websocket.WebSocketInputStream;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.InputStream;

public class HmtpWebSocketReader {
    private InputStream _is;
    private WebSocketInputStream _wsIs;
    private HmtpReader _hIn = new HmtpReader();

    public HmtpWebSocketReader(InputStream is) throws IOException {
        UnmaskedFrameInputStream fIs = new UnmaskedFrameInputStream();
        WebSocketContext cxt = null;
        fIs.init(cxt, is);
        this._wsIs = new WebSocketInputStream(fIs);
    }

    public boolean readPacket(MessageStream actorStream) throws IOException {
        if (actorStream == null) {
            throw new IllegalStateException("HmtpReader.readPacket requires a valid ActorStream for callbacks");
        }
        if (this._wsIs.startBinaryMessage()) {
            boolean isPacket = this._hIn.readPacket(this._wsIs, actorStream);
            this._wsIs.close();
            return isPacket;
        }
        return false;
    }

    public boolean isDataAvailable() throws IOException {
        InputStream is = this._is;
        return is != null && is.available() > 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._is + "]";
    }

    public void close() {
    }
}

