/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.ra;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.jca.cfg.AdminObjectConfig;
import com.caucho.jca.cfg.ConnectionDefinition;
import com.caucho.jca.cfg.ConnectorConfig;
import com.caucho.jca.cfg.MessageListenerConfig;
import com.caucho.jca.cfg.ResourceAdapterConfig;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.util.L10N;
import com.caucho.vfs.Jar;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;

public class ResourceArchive
implements EnvironmentBean {
    static final L10N L = new L10N(ResourceArchive.class);
    static final Logger log = Logger.getLogger(ResourceArchive.class.getName());
    private ClassLoader _loader = Thread.currentThread().getContextClassLoader();
    private Path _rootDir;
    private Path _rarPath;
    private ConnectorConfig _config;

    ResourceArchive() {
    }

    public void setRootDirectory(Path rootDir) {
        this._rootDir = rootDir;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setRarPath(Path rarPath) {
        this._rarPath = rarPath;
    }

    public String getDisplayName() {
        return this._config.getDisplayName();
    }

    public ResourceAdapterConfig getResourceAdapter() {
        return this._config.getResourceAdapter();
    }

    public Class getResourceAdapterClass() {
        return this._config.getResourceAdapter().getResourceadapterClass();
    }

    public String getTransactionSupport() {
        if (this.getResourceAdapter() != null) {
            return this.getResourceAdapter().getTransactionSupport();
        }
        return null;
    }

    public ConnectionDefinition getConnectionDefinition(String type) {
        ResourceAdapterConfig raConfig = this._config.getResourceAdapter();
        if (raConfig != null) {
            return raConfig.getConnectionDefinition(type);
        }
        return null;
    }

    public MessageListenerConfig getMessageListener(String type) {
        ResourceAdapterConfig raConfig = this._config.getResourceAdapter();
        if (raConfig != null) {
            return raConfig.getMessageListener(type);
        }
        return null;
    }

    public AdminObjectConfig getAdminObject(String type) {
        ResourceAdapterConfig raConfig = this._config.getResourceAdapter();
        if (raConfig != null) {
            return raConfig.getAdminObject(type);
        }
        return null;
    }

    @PostConstruct
    public void init() throws ConfigException {
        try {
            ClassLoader loader;
            this.expandRar();
            for (loader = Thread.currentThread().getContextClassLoader(); loader != null && !(loader instanceof DynamicClassLoader); loader = loader.getParent()) {
            }
            if (loader == null) {
                throw new ConfigException(L.l("loader issues with resource adapter"));
            }
            this.addJars((DynamicClassLoader)loader, this._rootDir);
            this.addNative((DynamicClassLoader)loader, this._rootDir);
            Path raXml = this._rootDir.lookup("META-INF/ra.xml");
            if (!raXml.canRead()) {
                throw new ConfigException(L.l("missing ra.xml for rar {0}.  .rar files require a META-INF/ra.xml file.", (Object)this._rarPath));
            }
            this._config = new ConnectorConfig();
            new Config().configure((Object)this._config, raXml, "com/caucho/jca/jca.rnc");
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        log.info("ResourceArchive[" + this._config.getDisplayName() + "] loaded");
    }

    void destroy() {
    }

    private void addJars(DynamicClassLoader loader, Path path) throws IOException {
        if (path.getPath().endsWith(".jar")) {
            loader.addJar(path);
        } else if (path.isDirectory()) {
            String[] list = path.list();
            for (int i = 0; i < list.length; ++i) {
                this.addJars(loader, path.lookup(list[i]));
            }
        }
    }

    private void addNative(DynamicClassLoader loader, Path path) throws IOException {
        String fileName = path.getPath();
        if (fileName.endsWith(".so") || fileName.endsWith(".dll") || fileName.endsWith(".jnilib")) {
            loader.addNative(path);
        } else if (path.isDirectory()) {
            String[] list = path.list();
            for (int i = 0; i < list.length; ++i) {
                this.addNative(loader, path.lookup(list[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandRar() throws IOException {
        Path dependPath;
        Path rar;
        block47: {
            rar = this._rarPath;
            if (!rar.canRead()) {
                return;
            }
            try {
                this._rootDir.mkdirs();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Path expandDir = this._rootDir;
            Path tempDir = this._rootDir.getParent().lookup(".temp");
            dependPath = this._rootDir.lookup("META-INF/resin-rar.timestamp");
            if (dependPath.canRead()) {
                ReadStream is = null;
                ObjectInputStream ois = null;
                try {
                    is = dependPath.openRead();
                    ois = new ObjectInputStream(is);
                    long lastModified = ois.readLong();
                    long length = ois.readLong();
                    if (lastModified == rar.getLastModified() && length == rar.getLength()) {
                        return;
                    }
                }
                catch (IOException lastModified) {
                }
                finally {
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (is != null) {
                        is.close();
                    }
                }
            }
            try {
                if (log.isLoggable(Level.INFO)) {
                    log.info("expanding rar " + rar + " to " + tempDir);
                }
                if (!tempDir.equals(expandDir)) {
                    tempDir.removeAll();
                }
                tempDir.mkdirs();
                ReadStream rs = rar.openRead();
                ZipInputStream zis = new ZipInputStream(rs);
                try {
                    ZipEntry entry;
                    byte[] buffer = new byte[1024];
                    while ((entry = zis.getNextEntry()) != null) {
                        String name = entry.getName();
                        Path path = tempDir.lookup(name);
                        if (entry.isDirectory()) {
                            path.mkdirs();
                            continue;
                        }
                        long length = entry.getSize();
                        long lastModified = entry.getTime();
                        path.getParent().mkdirs();
                        WriteStream os = path.openWrite();
                        try {
                            int len;
                            while ((len = zis.read(buffer, 0, buffer.length)) > 0) {
                                os.write(buffer, 0, len);
                            }
                        }
                        catch (IOException e) {
                            log.log(Level.FINE, e.toString(), e);
                        }
                        finally {
                            os.close();
                        }
                        if (lastModified <= 0L) continue;
                        path.setLastModified(lastModified);
                    }
                }
                finally {
                    try {
                        zis.close();
                    }
                    catch (IOException entry) {}
                    rs.close();
                }
                if (tempDir.equals(expandDir)) break block47;
                if (log.isLoggable(Level.INFO)) {
                    log.info("moving rar " + rar + " to " + expandDir);
                }
                try {
                    Jar.clearJarCache();
                    ResourceArchive.removeAll(expandDir);
                }
                catch (Throwable e) {
                    Jar.clearJarCache();
                    ResourceArchive.removeAll(expandDir);
                }
                ResourceArchive.moveAll(tempDir, expandDir);
                ResourceArchive.removeAll(tempDir);
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
                return;
            }
        }
        try {
            dependPath.getParent().mkdirs();
            WriteStream os = dependPath.openWrite();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeLong(rar.getLastModified());
            oos.writeLong(rar.getLength());
            oos.close();
            os.close();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private static void removeAll(Path path) {
        try {
            if (path.isDirectory()) {
                String[] list = path.list();
                for (int i = 0; list != null && i < list.length; ++i) {
                    ResourceArchive.removeAll(path.lookup(list[i]));
                }
            }
            path.remove();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private static void moveAll(Path source, Path target) {
        block6: {
            try {
                if (source.isDirectory()) {
                    try {
                        target.mkdirs();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String[] list = source.list();
                    for (int i = 0; list != null && i < list.length; ++i) {
                        ResourceArchive.moveAll(source.lookup(list[i]), target.lookup(list[i]));
                    }
                    break block6;
                }
                source.renameTo(target);
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getResourceAdapterClass() + "]";
    }
}

