/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class GenericMetaData
extends JdbcMetaData {
    private static final Logger log = Logger.getLogger(GenericMetaData.class.getName());
    private static final L10N L = new L10N(GenericMetaData.class);
    private String _longType;
    private String _blobType;
    private Boolean _supportsPositionFunction;
    private Boolean _supportsGetGeneratedKeys;
    private String _falseLiteral;

    public GenericMetaData(DataSource ds) {
        super(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLongType() {
        if (this._longType != null) {
            return this._longType;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != -5) continue;
                    String string = this._longType = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getBlobType() {
        if (this._blobType != null) {
            return this._blobType;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != 2004) continue;
                    String string = this._blobType = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
            rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    short dataType = rs.getShort("DATA_TYPE");
                    if (rs.getShort("DATA_TYPE") != -4) continue;
                    String string = this._blobType = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
            rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != -2) continue;
                    String string = this._blobType = rs.getString("TYPE_NAME");
                    return string;
                }
            }
            finally {
                rs.close();
            }
            rs = md.getTypeInfo();
            try {
                do {
                    if (!rs.next()) return null;
                } while (rs.getShort("DATA_TYPE") != -3);
                String string = this._blobType = rs.getString("TYPE_NAME");
                return string;
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFalseLiteral() {
        if (this._falseLiteral != null) {
            return this._falseLiteral;
        }
        Connection conn = null;
        this._falseLiteral = "0";
        try {
            conn = this.getConnection();
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                ResultSet rs = null;
                try {
                    rs = stmt.executeQuery("select false");
                    this._falseLiteral = "false";
                }
                catch (SQLException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._falseLiteral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsGetGeneratedKeys() {
        boolean bl;
        if (this._supportsGetGeneratedKeys != null) {
            return this._supportsGetGeneratedKeys;
        }
        Connection conn = this.getConnection();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            this._supportsGetGeneratedKeys = metaData.supportsGetGeneratedKeys();
            bl = this._supportsGetGeneratedKeys;
        }
        catch (Throwable throwable) {
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
                return false;
            }
            catch (AbstractMethodError e) {
                log.log(Level.FINE, e.toString(), e);
                return false;
            }
        }
        conn.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsPositionFunction() {
        if (this._supportsPositionFunction != null) {
            return this._supportsPositionFunction;
        }
        Connection conn = null;
        this._supportsPositionFunction = Boolean.FALSE;
        try {
            conn = this.getConnection();
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                ResultSet rs = null;
                try {
                    rs = stmt.executeQuery("select position('a' in 'abc')");
                    this._supportsPositionFunction = Boolean.TRUE;
                }
                catch (SQLException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._supportsPositionFunction;
    }

    @Override
    public boolean supportsUpdateTableAlias() {
        return true;
    }

    @Override
    public boolean supportsUpdateTableList() {
        return false;
    }

    @Override
    public boolean supportsIdentity() {
        return false;
    }

    @Override
    public String createIdentitySQL(String sqlType) {
        throw new UnsupportedOperationException("createIdentitySQL");
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public String createSequenceSQL(String name, int size) {
        throw new UnsupportedOperationException("createSequenceSQL");
    }

    @Override
    public String selectSequenceSQL(String name) {
        throw new UnsupportedOperationException("selectSequenceSQL");
    }

    @Override
    public String getCreateColumnSQL(int sqlType, int length, int precision, int scale) {
        String type = null;
        switch (sqlType) {
            case 16: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(-7, length, precision, scale);
                break;
            }
            case 91: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(93, length, precision, scale);
                break;
            }
            case 92: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
                if (type != null) break;
                type = this.getCreateColumnSQLImpl(93, length, precision, scale);
                break;
            }
            case 8: {
                type = this.getCreateColumnSQLImpl(8, length, precision, scale);
                break;
            }
            case 2: {
                type = this.getCreateColumnSQLImpl(2, length, precision, scale);
                break;
            }
            default: {
                type = this.getCreateColumnSQLImpl(sqlType, length, precision, scale);
            }
        }
        if (type == null) {
            type = this.getDefaultCreateTableSQL(sqlType, length, precision, scale);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCreateColumnSQLImpl(int sqlType, int length, int precision, int scale) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTypeInfo();
            try {
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != sqlType) continue;
                    String typeName = rs.getString("TYPE_NAME");
                    String params = rs.getString("CREATE_PARAMS");
                    if (params == null || params.equals("")) {
                        String string = typeName;
                        return string;
                    }
                    if (params.startsWith("(M)")) {
                        if (length > 0) {
                            String string = typeName + "(" + length + ")";
                            return string;
                        }
                        String string = typeName;
                        return string;
                    }
                    if (params.startsWith("(M,D)") || params.equals("precision,scale")) {
                        if (precision > 0) {
                            typeName = typeName + "(" + precision;
                            if (scale > 0) {
                                typeName = typeName + "," + scale;
                            }
                            typeName = typeName + ")";
                        }
                        String string = typeName;
                        return string;
                    }
                    if (params.startsWith("(")) {
                        int tail = params.indexOf(41);
                        if (tail > 0) {
                            String value = params.substring(1, tail);
                            boolean isConstant = true;
                            for (int i = 0; i < value.length(); ++i) {
                                if (value.charAt(i) >= 'a' && value.charAt(i) <= 'z') {
                                    isConstant = false;
                                    continue;
                                }
                                if (value.charAt(i) < 'A' || value.charAt(i) > 'Z') continue;
                                isConstant = false;
                            }
                            if (isConstant) {
                                String string = typeName + "(" + value + ")";
                                return string;
                            }
                        }
                        String string = typeName;
                        return string;
                    }
                    String string = typeName;
                    return string;
                }
            }
            finally {
                rs.close();
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected String getDefaultCreateTableSQL(int sqlType, int length, int precision, int scale) {
        switch (sqlType) {
            case 16: {
                return "CHAR";
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "INTEGER";
            }
            case 2: 
            case 3: {
                String typeString = "NUMERIC";
                if (precision > 0) {
                    typeString = typeString + "(" + precision;
                    if (scale > 0) {
                        typeString = typeString + "," + scale;
                    }
                    typeString = typeString + ")";
                }
                return typeString;
            }
            case 6: 
            case 8: {
                return "DOUBLE";
            }
            case 1: {
                return "CHAR";
            }
            case 91: 
            case 92: 
            case 93: {
                return "TIMESTAMP";
            }
        }
        return "VARCHAR(" + length + ")";
    }
}

