/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.JmsRuntimeException;
import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.message.MessageFactory;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.selector.SelectorParser;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class MessageBrowserImpl
implements QueueBrowser {
    static final Logger log = Logger.getLogger(MessageBrowserImpl.class.getName());
    static final L10N L = new L10N(MessageBrowserImpl.class);
    private MessageFactory _messageFactory = new MessageFactory();
    private JmsSession _session;
    private AbstractQueue _queue;
    private String _messageSelector;
    private Selector _selector;

    public MessageBrowserImpl(JmsSession session, AbstractQueue queue, String messageSelector) throws JMSException {
        this._session = session;
        this._queue = queue;
        this._messageSelector = messageSelector;
        if (messageSelector != null) {
            this._selector = new SelectorParser().parse(messageSelector);
        }
    }

    public Queue getQueue() throws JMSException {
        return this._queue;
    }

    public String getMessageSelector() throws JMSException {
        return this._messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        ArrayList queueEntryList;
        ArrayList<MessageImpl> list = new ArrayList<MessageImpl>(0);
        if (this._session.isActive() && (queueEntryList = this._queue.getBrowserList()) != null) {
            Iterator iterator = queueEntryList.iterator();
            while (iterator.hasNext()) {
                MessageImpl messageCopy = this._messageFactory.copy((MessageImpl)iterator.next().getPayload());
                list.add(messageCopy);
            }
        }
        return new BrowserEnumeration(list, this._selector);
    }

    public void close() throws JMSException {
    }

    public String toString() {
        return "MessageBrowserImpl[" + this._queue + "]";
    }

    public static class BrowserEnumeration
    implements Enumeration {
        private ArrayList<MessageImpl> _messages;
        private Selector _selector;
        private int _index;

        BrowserEnumeration(ArrayList<MessageImpl> messages, Selector selector) {
            this._messages = messages;
            this._selector = selector;
            this.nextValidMessage();
        }

        @Override
        public boolean hasMoreElements() {
            return this._index < this._messages.size();
        }

        public Object nextElement() {
            if (this._index < this._messages.size()) {
                MessageImpl msg = this._messages.get(this._index);
                ++this._index;
                this.nextValidMessage();
                return msg;
            }
            return null;
        }

        private void nextValidMessage() {
            try {
                while (this._index < this._messages.size()) {
                    MessageImpl msg = this._messages.get(this._index);
                    if (this._selector == null || this._selector.isMatch(msg)) {
                        return;
                    }
                    ++this._index;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JmsRuntimeException(e);
            }
        }
    }
}

