/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.config.ConfigException;
import com.caucho.jms.JmsRuntimeException;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;

public class JmsBlockingQueue
extends AbstractQueue
implements BlockingQueue {
    private static final L10N L = new L10N(JmsBlockingQueue.class);
    private static final Logger log = Logger.getLogger(JmsBlockingQueue.class.getName());
    private static long _idRandom;
    private static long _idCount;
    private ConnectionFactory _factory;
    private Connection _conn;
    private Destination _destination;
    private Session _writeSession;
    private Session _readSession;
    private MessageProducer _producer;
    private MessageConsumer _consumer;
    private Object _readLock = new Object();
    private Object _writeLock = new Object();

    public JmsBlockingQueue() {
    }

    public JmsBlockingQueue(ConnectionFactory factory, Destination destination) {
        this._factory = factory;
        this._destination = destination;
    }

    public void setFactory(ConnectionFactory factory) {
        this._factory = factory;
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    @PostConstruct
    public void init() {
        if (this._factory == null) {
            throw new ConfigException("JmsBlockingQueue requires a 'factory' with the JMS ConnectionFactory");
        }
        if (this._destination == null) {
            throw new ConfigException("JmsBlockingQueue requires a 'destination' with the JMS Destination");
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean contains(Object obj) {
        return false;
    }

    @Override
    public boolean remove(Object obj) {
        return false;
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object value, long timeout, TimeUnit unit) {
        try {
            Object object = this._writeLock;
            synchronized (object) {
                MessageProducer producer = this.getWriteProducer();
                Object msg = value instanceof Message ? (Message)value : this._writeSession.createObjectMessage((Serializable)value);
                producer.send(this._destination, msg, 0, 0, Integer.MAX_VALUE);
                return true;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmsRuntimeException(e);
        }
    }

    public Object poll(long timeout, TimeUnit unit) {
        try {
            Object object = this._readLock;
            synchronized (object) {
                MessageConsumer consumer = this.getReadConsumer();
                long msTimeout = unit.toMillis(timeout);
                Message msg = consumer.receive(msTimeout);
                if (msg instanceof ObjectMessage) {
                    return ((ObjectMessage)msg).getObject();
                }
                if (msg instanceof TextMessage) {
                    return ((TextMessage)msg).getText();
                }
                if (msg == null) {
                    return null;
                }
                throw new JmsRuntimeException(L.l("'{0}' is an unsupported message for the BlockingQueue API.", (Object)msg));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmsRuntimeException(e);
        }
    }

    @Override
    public boolean offer(Object value) {
        return this.offer(value, 0L, TimeUnit.SECONDS);
    }

    public void put(Object value) {
        this.offer(value, (long)Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object peek() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Object poll() {
        return this.poll(0L, TimeUnit.MILLISECONDS);
    }

    public Object take() {
        return this.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    public int drainTo(Collection c) {
        throw new UnsupportedOperationException();
    }

    public int drainTo(Collection c, int max) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageProducer getWriteProducer() throws JMSException {
        JmsBlockingQueue jmsBlockingQueue = this;
        synchronized (jmsBlockingQueue) {
            if (this._conn == null) {
                this._conn = this._factory.createConnection();
                this._conn.start();
            }
            if (this._writeSession == null) {
                this._writeSession = this._conn.createSession(false, 1);
            }
            if (this._producer == null) {
                this._producer = this._writeSession.createProducer(this._destination);
            }
        }
        return this._producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageConsumer getReadConsumer() throws JMSException {
        JmsBlockingQueue jmsBlockingQueue = this;
        synchronized (jmsBlockingQueue) {
            if (this._conn == null) {
                this._conn = this._factory.createConnection();
                this._conn.start();
            }
            if (this._readSession == null) {
                this._readSession = this._conn.createSession(false, 1);
            }
            if (this._consumer == null) {
                this._consumer = this._readSession.createConsumer(this._destination);
            }
        }
        return this._consumer;
    }

    public void close() {
        MessageConsumer consumer = this._consumer;
        this._consumer = null;
        MessageProducer producer = this._producer;
        this._producer = null;
        Session readSession = this._readSession;
        this._readSession = null;
        Session writeSession = this._writeSession;
        this._writeSession = null;
        Connection conn = this._conn;
        this._conn = null;
        try {
            if (consumer != null) {
                consumer.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            if (producer != null) {
                producer.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            if (readSession != null) {
                readSession.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            if (writeSession != null) {
                writeSession.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._destination + "]";
    }
}

