/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.Jmx;
import com.caucho.jmx.MBeanContext;
import com.caucho.jmx.MBeanServerDelegateImpl;
import com.caucho.jmx.MBeanWrapper;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerDelegateMBean;

public class EnvironmentMBeanServer
extends AbstractMBeanServer {
    private static final L10N L = new L10N(EnvironmentMBeanServer.class);
    private static final Logger log = Logger.getLogger(EnvironmentMBeanServer.class.getName());
    private EnvironmentLocal<MBeanContext> _localContext = new EnvironmentLocal();
    private MBeanServerDelegate _globalDelegate;
    private MBeanContext _globalContext;

    public EnvironmentMBeanServer(String domain, MBeanServerDelegate delegate) {
        super(domain);
        MBeanContext context;
        if (Jmx.getMBeanServer() == null) {
            Jmx.setMBeanServer(this);
        }
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        this._globalContext = context = new MBeanContext(this, systemLoader, delegate, null);
        this._localContext.setGlobal(context);
        try {
            IntrospectionMBean mbean = new IntrospectionMBean(delegate, MBeanServerDelegateMBean.class);
            MBeanWrapper mbeanWrapper = new MBeanWrapper(context, SERVER_DELEGATE_NAME, delegate, mbean);
            context.registerMBean(mbeanWrapper, SERVER_DELEGATE_NAME);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MBeanContext createContext(ClassLoader loader) {
        EnvironmentLocal<MBeanContext> environmentLocal = this._localContext;
        synchronized (environmentLocal) {
            MBeanContext context = this._localContext.getLevel(loader);
            if (context == null) {
                if (loader instanceof DynamicClassLoader && ((DynamicClassLoader)loader).isDestroyed()) {
                    throw new IllegalStateException(L.l("JMX context {0} has been closed.", (Object)loader));
                }
                MBeanServerDelegateImpl delegate = new MBeanServerDelegateImpl("Resin-JMX");
                context = new MBeanContext(this, loader, delegate, this._globalContext);
                MBeanContext parent = null;
                if (loader != null) {
                    parent = this.createContext(loader.getParent());
                }
                if (parent != null) {
                    context.setProperties(parent.copyProperties());
                }
                this._localContext.set(context, loader);
                try {
                    IntrospectionMBean mbean = new IntrospectionMBean(delegate, MBeanServerDelegateMBean.class);
                    MBeanWrapper mbeanWrapper = new MBeanWrapper(context, SERVER_DELEGATE_NAME, delegate, mbean);
                    context.registerMBean(mbeanWrapper, SERVER_DELEGATE_NAME);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MBeanContext getCurrentContext(ClassLoader loader) {
        if (loader == null) {
            loader = Environment.getEnvironmentClassLoader(loader);
        }
        EnvironmentLocal<MBeanContext> environmentLocal = this._localContext;
        synchronized (environmentLocal) {
            return this._localContext.getLevel(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setCurrentContext(MBeanContext context, ClassLoader loader) {
        if (loader == null) {
            loader = Environment.getEnvironmentClassLoader(loader);
        }
        EnvironmentLocal<MBeanContext> environmentLocal = this._localContext;
        synchronized (environmentLocal) {
            if (this._localContext.getLevel(loader) != null && this._localContext.getLevel(loader) != context) {
                throw new IllegalStateException(L.l("replacing context is forbidden"));
            }
            this._localContext.set(context, loader);
        }
    }

    @Override
    protected MBeanContext getContext(ClassLoader loader) {
        return this._localContext.get(loader);
    }

    @Override
    protected void removeContext(MBeanContext context, ClassLoader loader) {
        if (this._localContext.get(loader) == context) {
            this._localContext.remove(loader);
        }
    }

    @Override
    public String toString() {
        return "EnvironmentMBeanServer[]";
    }
}

