/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.MBeanContext;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class MBeanWrapper
implements DynamicMBean {
    private static L10N L = new L10N(MBeanWrapper.class);
    private static Logger log = Logger.getLogger(MBeanWrapper.class.getName());
    private MBeanContext _context;
    private ObjectName _name;
    protected Object _object;
    protected DynamicMBean _mbean;
    private ObjectInstance _instance;

    protected MBeanWrapper(MBeanContext context, ObjectName name, Object object, DynamicMBean mbean) {
        this._context = context;
        this._name = name;
        this._object = object;
        this._mbean = mbean;
    }

    public ObjectInstance getObjectInstance() {
        if (this._instance == null) {
            this._instance = new ObjectInstance(this._name, this.getMBeanInfo().getClassName());
        }
        return this._instance;
    }

    MBeanContext getContext() {
        return this._context;
    }

    Object getObject() {
        return this._object;
    }

    private NotificationBroadcaster getBroadcaster() {
        return (NotificationBroadcaster)this._object;
    }

    private NotificationEmitter getEmitter() {
        return (NotificationEmitter)this._object;
    }

    public ObjectName getObjectName() {
        return this._name;
    }

    public ClassLoader getClassLoader() {
        return this._context.getClassLoader();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this._mbean.getMBeanInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) throws ReflectionException, AttributeNotFoundException, MBeanException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._context.getClassLoader());
            Object object = this._mbean.getAttribute(name);
            return object;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList getAttributes(String[] names) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._context.getClassLoader());
            AttributeList attributeList = this._mbean.getAttributes(names);
            return attributeList;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(Attribute attr) throws ReflectionException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._context.getClassLoader());
            this._mbean.setAttribute(attr);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList setAttributes(AttributeList list) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._context.getClassLoader());
            AttributeList attributeList = this._mbean.setAttributes(list);
            return attributeList;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public Object invoke(String operation, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._context.getClassLoader());
            Object object = this._mbean.invoke(operation, params, signature);
            return object;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this._mbean + "." + operation + "\n  " + e, e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public NotificationListener getListener() {
        Object obj = this.getObject();
        if (obj instanceof NotificationListener) {
            return (NotificationListener)obj;
        }
        return null;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.getBroadcaster().addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.getBroadcaster().removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        Object obj = this.getObject();
        if (obj instanceof NotificationEmitter) {
            this.getEmitter().removeNotificationListener(listener, filter, handback);
        } else {
            this.getBroadcaster().removeNotificationListener(listener);
        }
    }
}

