/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.json.ser;

import com.caucho.json.JsonInput;
import com.caucho.json.ser.JsonDeserializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.logging.Logger;

public class JavaDeserializer
implements JsonDeserializer {
    private static final Logger log = Logger.getLogger(JavaDeserializer.class.getName());
    private Class _type;
    private Constructor _ctor;
    private HashMap<String, JsonField> _fieldMap = new HashMap();

    JavaDeserializer(Class type) {
        try {
            this._type = type;
            this._ctor = this.introspectConstructor(type);
            this._ctor.setAccessible(true);
            this.introspect();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void introspect() {
        this.introspectConstructor(this._type);
        this.introspectFields(this._type);
    }

    private Constructor introspectConstructor(Class type) {
        for (Constructor<?> ctor : type.getDeclaredConstructors()) {
            if (ctor.getParameterTypes().length != 0) continue;
            return ctor;
        }
        throw new IllegalStateException(type + " needs a zero-arg constructor");
    }

    private void introspectFields(Class type) {
        if (type == null) {
            return;
        }
        this.introspectFields(type.getSuperclass());
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                this._fieldMap.put(field.getName(), new JsonIntField(field));
                continue;
            }
            if (fieldType == Long.TYPE || fieldType == Long.class) {
                this._fieldMap.put(field.getName(), new JsonLongField(field));
                continue;
            }
            if (fieldType == Double.TYPE || fieldType == Double.class) {
                this._fieldMap.put(field.getName(), new JsonDoubleField(field));
                continue;
            }
            this._fieldMap.put(field.getName(), new JsonObjectField(field));
        }
    }

    @Override
    public Object read(JsonInput in) throws IOException {
        Object bean = this.create();
        in.parseBeanMap(bean, this);
        return bean;
    }

    public Object create() {
        try {
            return this._ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readField(JsonInput in, Object bean, String fieldName) throws IOException {
        JsonField jsonField = this._fieldMap.get(fieldName);
        if (jsonField != null) {
            jsonField.read(in, bean);
        } else {
            in.readObject();
        }
    }

    public Object complete(Object bean) {
        return bean;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._type + "]";
    }

    static class JsonObjectField
    extends JsonField {
        private final Field _field;

        JsonObjectField(Field field) {
            this._field = field;
        }

        @Override
        void read(JsonInput in, Object bean) throws IOException {
            Object value = in.readObject(this._field.getType());
            if (value == null) {
                return;
            }
            if (!this._field.getType().isAssignableFrom(value.getClass())) {
                throw new IOException(value.getClass() + " is an illegal value for " + this._field);
            }
            try {
                this._field.set(bean, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class JsonDoubleField
    extends JsonField {
        private final Field _field;

        JsonDoubleField(Field field) {
            this._field = field;
        }

        @Override
        void read(JsonInput in, Object bean) throws IOException {
            double value = in.readDouble();
            try {
                this._field.setDouble(bean, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class JsonLongField
    extends JsonField {
        private final Field _field;

        JsonLongField(Field field) {
            this._field = field;
        }

        @Override
        void read(JsonInput in, Object bean) throws IOException {
            long value = in.readLong();
            try {
                this._field.setLong(bean, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class JsonIntField
    extends JsonField {
        private final Field _field;

        JsonIntField(Field field) {
            this._field = field;
        }

        @Override
        void read(JsonInput in, Object bean) throws IOException {
            long value = in.readLong();
            try {
                this._field.setInt(bean, (int)value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static abstract class JsonField {
        JsonField() {
        }

        abstract void read(JsonInput var1, Object var2) throws IOException;
    }
}

