/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.config.types.Signature;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.cfg.TldAttribute;
import com.caucho.jsp.java.JavaTagGenerator;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.io.IOException;
import javax.servlet.jsp.tagext.JspFragment;

public class JspDirectiveAttribute
extends JspNode {
    static L10N L = new L10N(JspDirectiveAttribute.class);
    private static final QName NAME = new QName("name");
    private static final QName REQUIRED = new QName("required");
    private static final QName FRAGMENT = new QName("fragment");
    private static final QName RTEXPRVALUE = new QName("rtexprvalue");
    private static final QName TYPE = new QName("type");
    private static final QName DESCRIPTION = new QName("description");
    private static final QName DEFERRED_VALUE = new QName("deferredValue");
    private static final QName DEFERRED_VALUE_TYPE = new QName("deferredValueType");
    private static final QName DEFERRED_METHOD = new QName("deferredMethod");
    private static final QName DEFERRED_METHOD_SIGNATURE = new QName("deferredMethodSignature");
    private String _name;
    private String _type;
    private boolean _isRequired;
    private boolean _isFragment;
    private Boolean _isRtexprvalue;
    private String _description;
    private Boolean _deferredValue;
    private String _deferredValueType;
    private Boolean _deferredMethod;
    private String _deferredMethodSignature;

    @Override
    public void addAttribute(QName name, String value) throws JspParseException {
        if (!this._gen.getParseState().isTag()) {
            throw this.error(L.l("'{0}' is only allowed in .tag files.  Attribute directives are not allowed in normal JSP files.", (Object)this.getTagName()));
        }
        JavaTagGenerator gen = (JavaTagGenerator)this._gen;
        if (NAME.equals(name)) {
            if (gen.findVariable(value) != null) {
                throw this.error(L.l("@attribute name '{0}' is already used by a variable.", (Object)value));
            }
            if (gen.findAttribute(value) != null) {
                throw this.error(L.l("@attribute name '{0}' is already used by another attribute.", (Object)value));
            }
            this._name = value;
        } else if (TYPE.equals(name)) {
            this._type = value;
        } else if (REQUIRED.equals(name)) {
            this._isRequired = this.attributeToBoolean(name.getName(), value);
        } else if (FRAGMENT.equals(name)) {
            this._isFragment = this.attributeToBoolean(name.getName(), value);
        } else if (RTEXPRVALUE.equals(name)) {
            this._isRtexprvalue = this.attributeToBoolean(name.getName(), value);
        } else if (DESCRIPTION.equals(name)) {
            this._description = value;
        } else if (DEFERRED_VALUE.equals(name)) {
            if (this._gen.isPre21()) {
                throw this.error("deferredValue requires JSP 2.1 or later tag file");
            }
            this._deferredValue = this.attributeToBoolean(name.getName(), value);
            if (this._deferredValue.booleanValue()) {
                this._type = "javax.el.ValueExpression";
            }
        } else if (DEFERRED_VALUE_TYPE.equals(name)) {
            if (this._gen.isPre21()) {
                throw this.error("deferredValueType requires JSP 2.1 or later tag file");
            }
            this._type = "javax.el.ValueExpression";
            this._deferredValueType = value;
        } else if (DEFERRED_METHOD.equals(name)) {
            if (this._gen.isPre21()) {
                throw this.error("deferredMethod requires JSP 2.1 or later tag file");
            }
            this._deferredMethod = this.attributeToBoolean(name.getName(), value);
            if (Boolean.TRUE.equals(this._deferredMethod)) {
                this._type = "javax.el.MethodExpression";
            }
        } else if (DEFERRED_METHOD_SIGNATURE.equals(name)) {
            if (this._gen.isPre21()) {
                throw this.error("deferredMethodSignature requires JSP 2.1 or later tag file");
            }
            try {
                new Signature(value);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
            this._type = "javax.el.MethodExpression";
            this._deferredMethodSignature = value;
        } else {
            throw this.error(L.l("'{0}' is an unknown JSP attribute directive attributes.  The valid attributes are: deferredMethod, deferredMethodSignature, deferredValue, deferredValueType, description, fragment, name, rtexprvalue, type.", (Object)name.getName()));
        }
    }

    @Override
    public void endElement() throws JspParseException {
        if (!this._gen.getParseState().isTag()) {
            throw this.error(L.l("'{0}' is only allowed in .tag files.  Attribute directives are not allowed in normal JSP files.", (Object)this.getTagName()));
        }
        if (this._name == null) {
            throw this.error(L.l("<{0}> needs a 'name' attribute.", (Object)this.getTagName()));
        }
        JavaTagGenerator tagGen = (JavaTagGenerator)this._gen;
        TldAttribute attr = new TldAttribute();
        attr.setName(this._name);
        if (this._type == null) {
            attr.setType(String.class);
        } else {
            Class type = this.loadClass(this._type);
            if (type == null) {
                throw this.error(L.l("type '{0}' is an unknown class for tag attribute {1}.", (Object)this._type, (Object)this._name));
            }
            if (type.isPrimitive()) {
                throw this.error(L.l("attribute type '{0}' cannot be a Java primitive for {1}.", (Object)this._type, (Object)this._name));
            }
            attr.setType(type);
        }
        attr.setRequired(this._isRequired);
        if (this._isFragment && this._isRtexprvalue != null) {
            throw this.error(L.l("@attribute rtexprvalue cannot be set when fragment is true."));
        }
        if (this._isFragment && this._type != null) {
            throw this.error(L.l("@attribute type cannot be set when fragment is true."));
        }
        if (this._isRtexprvalue == null || Boolean.TRUE.equals(this._isRtexprvalue)) {
            attr.setRtexprvalue(Boolean.TRUE);
        }
        if (this._isFragment) {
            attr.setType(JspFragment.class);
        }
        if (this._deferredValue != null && this._deferredValueType != null) {
            throw this.error(L.l("@attribute deferredValue and deferredValueType may not both be specified"));
        }
        if (this._deferredMethod != null && this._deferredMethodSignature != null) {
            throw this.error(L.l("@attribute deferredMethod and deferredMethodSignature may not both be specified"));
        }
        if (!(this._deferredValue == null && this._deferredValueType == null || this._deferredMethod == null && this._deferredMethodSignature == null)) {
            throw this.error(L.l("@attribute deferredValue and deferredMethod may not both be specified"));
        }
        if (Boolean.TRUE.equals(this._deferredValue) || this._deferredValueType != null) {
            attr.setDeferredValue(new TldAttribute.DeferredValue());
            if (this._deferredValueType != null) {
                attr.getDeferredValue().setType(this._deferredValueType);
            }
        }
        if (Boolean.TRUE.equals(this._deferredMethod) || this._deferredMethodSignature != null) {
            attr.setDeferredMethod(new TldAttribute.DeferredMethod());
            if (this._deferredMethodSignature != null) {
                attr.getDeferredMethod().setMethodSignature(new Signature(this._deferredMethodSignature));
            }
        }
        tagGen.addAttribute(attr);
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public void printXml(WriteStream os) throws IOException {
        os.print("<jsp:directive.attribute");
        os.print(" jsp:id=\"" + this._gen.generateJspId() + "\"");
        os.print(" name=\"" + this._name + "\"");
        if (this._type != null) {
            os.print(" type=\"" + this._type + "\"");
        }
        os.println("/>");
    }

    @Override
    public void generate(JspJavaWriter out) throws Exception {
    }
}

