/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.ClassPackage;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class JarEntry {
    private static final L10N L = new L10N(JarEntry.class);
    private static final Logger log = Logger.getLogger(JarEntry.class.getName());
    private Manifest _manifest;
    private boolean _isManifestRead;
    private JarPath _jarPath;
    private ArrayList<ClassPackage> _packages = new ArrayList();

    JarEntry(JarPath jarPath) {
        this._jarPath = jarPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest() {
        if (this._isManifestRead) {
            return;
        }
        JarEntry jarEntry = this;
        synchronized (jarEntry) {
            if (this._isManifestRead) {
                return;
            }
            try {
                this._manifest = this._jarPath.getManifest();
                if (this._manifest == null) {
                    return;
                }
                Attributes attr = this._manifest.getMainAttributes();
                if (attr != null) {
                    this.addManifestPackage("", attr);
                }
                Map<String, Attributes> entries = this._manifest.getEntries();
                for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                    String pkg = entry.getKey();
                    attr = entry.getValue();
                    if (attr == null) continue;
                    this.addManifestPackage(pkg, attr);
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                this._isManifestRead = true;
            }
        }
    }

    private void addManifestPackage(String name, Attributes attr) {
        if (!name.endsWith("/") && !name.equals("")) {
            return;
        }
        String specTitle = attr.getValue("Specification-Title");
        String specVersion = attr.getValue("Specification-Version");
        String specVendor = attr.getValue("Specification-Vendor");
        String implTitle = attr.getValue("Implementation-Title");
        String implVersion = attr.getValue("Implementation-Version");
        String implVendor = attr.getValue("Implementation-Vendor");
        if (specTitle == null && specVersion == null && specVendor != null && implTitle == null && implVersion == null && implVendor != null) {
            return;
        }
        ClassPackage pkg = new ClassPackage(name);
        pkg.setSpecificationTitle(specTitle);
        pkg.setSpecificationVersion(specVersion);
        pkg.setSpecificationVendor(specVendor);
        pkg.setImplementationTitle(implTitle);
        pkg.setImplementationVersion(implVersion);
        pkg.setImplementationVendor(implVendor);
        this._packages.add(pkg);
    }

    public void validate() throws ConfigException {
        this.loadManifest();
        if (this._manifest != null) {
            JarEntry.validateManifest(this._jarPath.getContainer().getURL(), this._manifest);
        }
    }

    public static void validateManifest(String manifestName, Manifest manifest) throws ConfigException {
        Attributes attr = manifest.getMainAttributes();
        if (attr == null) {
            return;
        }
        String extList = attr.getValue("Extension-List");
        if (extList == null) {
            return;
        }
        Pattern pattern = Pattern.compile("[, \t]+");
        String[] split = pattern.split(extList);
        for (int i = 0; i < split.length; ++i) {
            String ext = split[i];
            String name = attr.getValue(ext + "-Extension-Name");
            if (name == null) continue;
            Package pkg = Package.getPackage(name);
            if (pkg == null) {
                log.warning(L.l("package {0} is missing.  {1} requires package {0}.", (Object)name, (Object)manifestName));
                continue;
            }
            String version = attr.getValue(ext + "-Specification-Version");
            if (version == null) continue;
            if (pkg.getSpecificationVersion() == null || pkg.getSpecificationVersion().equals("")) {
                log.warning(L.l("installed {0} is not compatible with version `{1}'.  {2} requires version {1}.", (Object)name, (Object)version, (Object)manifestName));
                continue;
            }
            if (pkg.isCompatibleWith(version)) continue;
            log.warning(L.l("installed {0} is not compatible with version `{1}'.  {2} requires version {1}.", (Object)name, (Object)version, (Object)manifestName));
        }
    }

    public ClassPackage getPackage(String name) {
        this.loadManifest();
        ClassPackage bestPackage = null;
        int bestLength = -1;
        for (int i = 0; i < this._packages.size(); ++i) {
            ClassPackage pkg = this._packages.get(i);
            String prefix = pkg.getPrefix();
            if (!name.startsWith(prefix) || bestLength >= prefix.length()) continue;
            bestPackage = pkg;
            bestLength = prefix.length();
        }
        return bestPackage;
    }

    public JarPath getJarPath() {
        return this._jarPath;
    }

    public CodeSource getCodeSource(String path) {
        try {
            Path jarPath = this._jarPath.lookup(path);
            Certificate[] certificates = jarPath.getCertificates();
            URL url = new URL(this._jarPath.getContainer().getURL());
            return new CodeSource(url, certificates);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof JarEntry)) {
            return false;
        }
        JarEntry entry = (JarEntry)o;
        return this._jarPath.equals(entry._jarPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._jarPath + "]";
    }
}

