/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.jmx.Description;
import com.caucho.jmx.Units;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ManagedObjectMXBean;
import java.util.Date;

@Description(value="Client-view of a cluster's server, i.e. a target server with which this instance can communicate")
public interface ClusterServerMXBean
extends ManagedObjectMXBean {
    @Description(value="The configured Cluster which contains the server")
    public ClusterMXBean getCluster();

    @Description(value="The configured index of this server in the cluster, used for distributed objects.")
    public int getClusterIndex();

    @Description(value="The configured IP address or host name of the server")
    public String getAddress();

    @Description(value="The configured port number of the target server")
    public int getPort();

    @Description(value="Returns true for a dynamic server")
    public boolean isDynamicServer();

    @Description(value="Returns true for a triad server")
    public boolean isTriadServer();

    @Description(value="Returns true for the server's own ClusterServer")
    public boolean isSelfServer();

    @Description(value="The configured timeout for a client connect to the server")
    @Units(value="milliseconds")
    public long getConnectTimeout();

    @Description(value="The minimum connections for green load balancing")
    public int getConnectionMin();

    @Description(value="The configured timeout for assuming a target server remains unavailable once a connection attempt fails. When the timeout period elapses another attempt is made to connect to the target server")
    @Units(value="milliseconds")
    public long getRecoverTime();

    @Description(value="The configured timeout for an idle socket that is connected to the target server. If the socket is not used within the timeout period the idle connection is closed")
    @Units(value="milliseconds")
    public long getIdleTime();

    @Description(value="The configured timeout for a client read from the server")
    @Units(value="milliseconds")
    public long getSocketTimeout();

    @Description(value="The configured warmup time in milliseconds for ramping up connections to the server")
    @Units(value="milliseconds")
    public long getWarmupTime();

    @Description(value="The configured load balance weight.  Weights over 100 will get more traffic and weights less than 100 will get less traffic")
    public int getWeight();

    @Description(value="The configured timeout for an idle socket that is connected to the target server. If the socket is not used within the timeout period the idle connection is closed")
    @Units(value="milliseconds")
    public long getClusterIdleTime();

    @Description(value="The current lifecycle state of the client")
    public String getClusterState();

    @Description(value="The current lifecycle state of the client")
    public String getLoadBalanceState();

    @Description(value="True if the heartbeat is active")
    public boolean isHeartbeatActive();

    @Description(value="Returns the heartbeat state")
    public String getHeartbeatState();

    @Description(value="The time of the last received heartbeat from this server")
    public Date getLastHeartbeatTime();

    @Description(value="The current number of connections actively being used to communicate with the target server")
    public int getConnectionActiveCount();

    @Description(value="The current number of idle connections in the connection pool")
    public int getConnectionIdleCount();

    @Description(value="The total number of new connections that have been made to the target server")
    public long getConnectionNewCountTotal();

    @Description(value="The total number of keepalive connections that have been made to the target server")
    public long getConnectionKeepaliveCountTotal();

    @Description(value="The total number of failed connections attempts to the target server")
    public long getConnectionFailCountTotal();

    @Description(value="The current last time a connection attempt failed")
    public Date getLastFailTime();

    @Description(value="The total number of busy responses from the target server")
    public long getConnectionBusyCountTotal();

    @Description(value="The current last time the target server refused a request because it was busy")
    public Date getLastBusyTime();

    @Description(value="The load average of the backend server")
    public double getServerCpuLoadAvg();

    @Description(value="The latency factor of the backend server")
    public double getLatencyFactor();

    @Description(value="The number of messages in the outgoing message queue")
    public int getMessageQueueSize();

    @Description(value="The number of messages in the outgoing large message queue")
    public int getMessageQueueLargeSize();

    @Description(value="Enables connections to the target server")
    public void start();

    @Description(value="Enable only sticky-session requests to the target server")
    public void enableSessionOnly();

    @Description(value="Disables connections to the target server")
    public void stop();

    @Description(value="Remove this server as a dynamic server")
    public void removeDynamicServer();

    @Description(value="Tries to connect to the target server, returning true if successful")
    public boolean ping();
}

