/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.env.thread.AbstractThreadLauncher;
import com.caucho.env.thread.ThreadPool;
import com.caucho.inject.Module;
import com.caucho.network.listen.AcceptTask;
import com.caucho.network.listen.ConnectionTask;
import com.caucho.network.listen.TcpPort;
import com.caucho.network.listen.TcpSocketAcceptThread;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.network.listen.TcpSocketResumeThread;
import com.caucho.util.RingValueQueue;
import java.util.concurrent.atomic.AtomicInteger;

@Module
class SocketLinkThreadLauncher
extends AbstractThreadLauncher {
    private final ThreadPool _threadPool = ThreadPool.getThreadPool();
    private TcpPort _listener;
    private final RingValueQueue<AcceptTask> _acceptTaskQueue = new RingValueQueue(1024);
    private final RingValueQueue<ConnectionTask> _resumeTaskQueue = new RingValueQueue(16384);
    private String _threadName;
    private final AtomicInteger _resumeStartCount = new AtomicInteger();

    SocketLinkThreadLauncher(TcpPort listener) {
        this._listener = listener;
    }

    @Override
    protected boolean isEnable() {
        if (this._listener.isClosed()) {
            return false;
        }
        return super.isEnable();
    }

    @Override
    public boolean isPermanent() {
        return true;
    }

    public void init() {
        this._threadName = this.generateThreadName() + "-launcher";
    }

    boolean offerResumeTask(ConnectionTask task) {
        if (!this._resumeTaskQueue.offer(task)) {
            System.out.println("FAILED_SUBMIT:");
        }
        this.wakeResumeTask(1);
        return true;
    }

    boolean submitResumeTask(ConnectionTask task) {
        if (!this._resumeTaskQueue.offer(task)) {
            System.out.println("FAILED_SUBMIT:");
        }
        this.wakeResumeTask(1);
        return true;
    }

    void wakeScheduler() {
        this._threadPool.wakeScheduler();
    }

    @Override
    protected String getThreadName() {
        if (this._threadName == null) {
            this._threadName = this.generateThreadName() + "-launcher";
        }
        return this._threadName;
    }

    String generateThreadName() {
        String address = this._listener.getAddress();
        int port = this._listener.getPort();
        if (address != null) {
            return "resin-port-" + address + ":" + port;
        }
        return "resin-port-" + port;
    }

    void handleTasks(boolean isResume) {
        int retryMax;
        int retryCount = retryMax = 8;
        while (retryCount-- >= 0) {
            ConnectionTask task = (ConnectionTask)this._acceptTaskQueue.poll();
            if (task == null) {
                if (!isResume) {
                    isResume = true;
                    this._resumeStartCount.incrementAndGet();
                }
                task = (ConnectionTask)this._resumeTaskQueue.poll();
            }
            if (!this._resumeTaskQueue.isEmpty()) {
                this.wakeResumeTask(4);
            }
            if (isResume) {
                isResume = false;
                this._resumeStartCount.decrementAndGet();
            }
            if (!this._resumeTaskQueue.isEmpty()) {
                this.wakeResumeTask(1);
            }
            if (task == null) continue;
            retryCount = retryMax;
            task.run();
        }
    }

    void wakeResumeTask(int min) {
        int startCount = 0;
        while (startCount < min) {
            int threadCount = this.getThreadCount();
            int startingCount = this.getStartingCount();
            int resumeCount = this._resumeStartCount.get();
            if (this.getThreadMax() <= threadCount + startingCount + resumeCount) {
                return;
            }
            int size = this._resumeTaskQueue.size();
            if (size < min) {
                min = size;
            }
            if (min <= resumeCount) {
                return;
            }
            if (!this._resumeStartCount.compareAndSet(resumeCount, resumeCount + 1)) continue;
            ++startCount;
            this._threadPool.schedule(new TcpSocketResumeThread(this));
        }
    }

    void addResumeStart() {
        this._resumeStartCount.incrementAndGet();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void launchChildThread(int id) {
        ClassLoader loader;
        Thread thread;
        block7: {
            thread = Thread.currentThread();
            loader = thread.getContextClassLoader();
            TcpSocketLink startConn = null;
            try {
                thread.setContextClassLoader(this._listener.getClassLoader());
                startConn = this._listener.allocateConnection();
                AcceptTask acceptTask = startConn.requestAccept();
                if (acceptTask != null && this._acceptTaskQueue.offer(acceptTask)) {
                    startConn = null;
                    this._threadPool.schedule(new TcpSocketAcceptThread(this));
                }
                if (startConn == null) break block7;
            }
            catch (RuntimeException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (startConn != null) {
                        this._listener.closeConnection(startConn);
                    }
                    thread.setContextClassLoader(loader);
                    throw throwable;
                }
            }
            this._listener.closeConnection(startConn);
        }
        thread.setContextClassLoader(loader);
    }

    @Override
    protected void startWorkerThread() {
        this._threadPool.schedule(this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._listener + "]";
    }
}

