/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.remote.websocket.FrameInputStream;
import com.caucho.remote.websocket.WebSocketConstants;
import com.caucho.remote.websocket.WebSocketInputStream;
import com.caucho.remote.websocket.WebSocketOutputStream;
import com.caucho.remote.websocket.WebSocketPrintWriter;
import com.caucho.remote.websocket.WebSocketWriter;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.caucho.websocket.WebSocketContext;
import com.caucho.websocket.WebSocketEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketContextStreamImpl
implements WebSocketContext,
WebSocketConstants {
    private static final L10N L = new L10N(WebSocketContextStreamImpl.class);
    private static final Logger log = Logger.getLogger(WebSocketContextStreamImpl.class.getName());
    private WriteStream _out;
    private WebSocketOutputStream _binaryOut;
    private WebSocketWriter _textOut;
    private PrintWriter _textWriter;
    private AtomicBoolean _isWriteClosed = new AtomicBoolean();

    public WebSocketContextStreamImpl(WriteStream out) {
        this._out = out;
    }

    @Override
    public void setTimeout(long timeout) {
    }

    @Override
    public long getTimeout() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public OutputStream startBinaryMessage() throws IOException {
        if (this._isWriteClosed.get()) {
            throw new IllegalStateException(L.l("{0} is closed for writing.", (Object)this));
        }
        if (this._binaryOut == null) {
            this._binaryOut = new WebSocketOutputStream(this.getWriteStream(), TempBuffer.allocate().getBuffer());
        }
        this._binaryOut.init();
        return this._binaryOut;
    }

    @Override
    public PrintWriter startTextMessage() throws IOException {
        if (this._textOut == null) {
            WriteStream os = this.getWriteStream();
            if (os == null) {
                throw new IllegalStateException(L.l("{0} is closed for writing."));
            }
            this._textOut = new WebSocketWriter(os, TempBuffer.allocate().getBuffer());
            this._textWriter = new WebSocketPrintWriter(this._textOut);
        }
        this._textOut.init();
        return this._textWriter;
    }

    @Override
    public void pong(byte[] bytes) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void close() {
        this.close(1000, "ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int code, String msg) {
        if (this._isWriteClosed.getAndSet(true)) {
            return;
        }
        try {
            WriteStream out = this.getWriteStream();
            out.write(136);
            out.write(0);
            out.flush();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this.disconnect();
        }
    }

    protected WriteStream getWriteStream() {
        return this._out;
    }

    @Override
    public void disconnect() {
        this._out = null;
    }

    void onStart() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        WriteStream out = this.getWriteStream();
        out.flush();
    }

    protected WebSocketInputStream createWebSocketInputStream(FrameInputStream is) throws IOException {
        return new WebSocketInputStream(is);
    }

    @Override
    public void onClose(int closeCode, String closeMessage) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getWriteStream() + "]";
    }

    @Override
    public <T> BlockingQueue<T> createOutputQueue(WebSocketEncoder<T> encoder) {
        return null;
    }

    @Override
    public void setAutoFlush(boolean isAutoFlush) {
    }

    @Override
    public boolean isAutoFlush() {
        return false;
    }
}

