/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resources;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.Service;
import com.caucho.config.Unbound;
import com.caucho.config.cfg.BeanConfig;
import com.caucho.config.types.Period;
import com.caucho.loader.AbstractEnvironmentListener;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.resources.ScheduledTask;
import javax.annotation.PostConstruct;
import javax.el.MethodExpression;
import javax.enterprise.context.Dependent;

@Service
@Unbound
public class ScheduledTaskConfig
extends BeanConfig {
    private ScheduledTask _scheduledTask = new ScheduledTask();
    private boolean _isTask = false;

    public ScheduledTaskConfig() {
        this.setBeanConfigClass(Runnable.class);
        this.setScopeType(Dependent.class);
    }

    @Override
    protected boolean isStartup() {
        return false;
    }

    @Configurable
    public void setDelay(Period delay) {
        this._scheduledTask.setDelay(delay);
    }

    @Configurable
    public void setPeriod(Period period) {
        this._scheduledTask.setPeriod(period);
    }

    public void setCron(String cron) {
        this._scheduledTask.setCron(cron);
    }

    public void setMethod(MethodExpression method) {
        this._scheduledTask.setMethod(method);
        this._isTask = true;
    }

    public void setUrl(String url) {
        this._scheduledTask.setUrl(url);
        this._isTask = true;
    }

    @Deprecated
    public void setWork(Runnable work) {
        this._scheduledTask.setTask(work);
        this._isTask = true;
    }

    @Configurable
    public void setTask(Runnable task) {
        this._scheduledTask.setTask(task);
        this._isTask = true;
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        if (this.getClassType() != null) {
            super.init();
        }
        Environment.addEnvironmentListener(new StartListener());
    }

    private void start() {
        if (!this._isTask && this._scheduledTask.getTask() == null) {
            this._scheduledTask.setTask((Runnable)this.getObject());
        }
        this._scheduledTask.init();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._scheduledTask + "]";
    }

    class StartListener
    extends AbstractEnvironmentListener {
        StartListener() {
        }

        @Override
        public void environmentStart(EnvironmentClassLoader loader) {
            ScheduledTaskConfig.this.start();
        }
    }
}

