/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.ConfigException;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.AuthorizationResult;
import com.caucho.server.security.SecurityConstraint;
import com.caucho.server.util.CauchoSystem;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Deny
extends SecurityConstraint {
    private ArrayList<Pattern> _patternList = new ArrayList();
    private ArrayList<RequestPredicate> _predicateList = new ArrayList();

    @Override
    public void addURLPattern(String pattern) {
        String regexpPattern = UrlMap.urlPatternToRegexpPattern(pattern);
        int flags = CauchoSystem.isCaseInsensitive() ? 2 : 0;
        try {
            this._patternList.add(Pattern.compile(regexpPattern, flags));
        }
        catch (PatternSyntaxException e) {
            throw ConfigException.create(e);
        }
    }

    public void add(RequestPredicate predicate) {
        this._predicateList.add(predicate);
    }

    @Override
    public boolean isMatch(String url) {
        for (int i = 0; i < this._patternList.size(); ++i) {
            Pattern pattern = this._patternList.get(i);
            if (!pattern.matcher(url).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFallthrough() {
        return true;
    }

    @Override
    public ArrayList<String> getMethods(String url) {
        return null;
    }

    @Override
    public AbstractConstraint getConstraint() {
        return new DenyConstraint(this._predicateList);
    }

    class DenyConstraint
    extends AbstractConstraint {
        private RequestPredicate[] _predicateList;

        DenyConstraint(ArrayList<RequestPredicate> predicateList) {
            this._predicateList = new RequestPredicate[predicateList.size()];
            predicateList.toArray(this._predicateList);
        }

        @Override
        public AuthorizationResult isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext webApp) {
            for (RequestPredicate predicate : this._predicateList) {
                if (predicate.isMatch(request)) continue;
                return AuthorizationResult.DEFAULT_ALLOW;
            }
            return AuthorizationResult.DENY;
        }
    }
}

