/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.security.AbstractLogin;
import com.caucho.security.Authenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.HttpDigestCredentials;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.RandomUtil;
import com.caucho.util.StringCharCursor;
import com.caucho.xml.XmlChar;
import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ApplicationScoped
public class DigestLogin
extends AbstractLogin {
    private static final Logger log = Logger.getLogger(DigestLogin.class.getName());
    private String _realm;

    public void setRealmName(String realm) {
        this._realm = realm;
    }

    public String getRealmName() {
        return this._realm;
    }

    @Override
    public String getAuthType() {
        return "Digest";
    }

    @Override
    protected Principal getUserPrincipalImpl(HttpServletRequest request) {
        String value = request.getHeader("authorization");
        if (value == null) {
            return null;
        }
        String username = null;
        String realm = null;
        String uri = null;
        String nonce = null;
        String cnonce = null;
        String nc = null;
        String qop = null;
        String digest = null;
        StringCharCursor cursor = new StringCharCursor(value);
        String key = this.scanKey(cursor);
        if (!"Digest".equalsIgnoreCase(key)) {
            return null;
        }
        while ((key = this.scanKey(cursor)) != null) {
            value = this.scanValue(cursor);
            if (key.equals("username")) {
                username = value;
                continue;
            }
            if (key.equals("realm")) {
                realm = value;
                continue;
            }
            if (key.equals("uri")) {
                uri = value;
                continue;
            }
            if (key.equals("nonce")) {
                nonce = value;
                continue;
            }
            if (key.equals("response")) {
                digest = value;
                continue;
            }
            if (key.equals("cnonce")) {
                cnonce = value;
                continue;
            }
            if (key.equals("nc")) {
                nc = value;
                continue;
            }
            if (!key.equals("qop")) continue;
            qop = value;
        }
        byte[] clientDigest = this.decodeDigest(digest);
        if (clientDigest == null || username == null || uri == null || nonce == null) {
            return null;
        }
        Authenticator auth = this.getAuthenticator();
        BasicPrincipal principal = new BasicPrincipal(username);
        HttpDigestCredentials cred = new HttpDigestCredentials();
        cred.setCnonce(cnonce);
        cred.setMethod(request.getMethod());
        cred.setNc(nc);
        cred.setNonce(nonce);
        cred.setQop(qop);
        cred.setRealm(realm);
        cred.setResponse(clientDigest);
        cred.setUri(uri);
        Principal user = auth.authenticate(principal, cred, request);
        if (log.isLoggable(Level.FINE)) {
            log.fine("digest: " + username + " -> " + user);
        }
        return user;
    }

    @Override
    protected void loginChallenge(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String realm = this.getRealmName();
        if (realm == null) {
            realm = "resin";
        }
        StringBuilder cb = new StringBuilder();
        Base64.encode(cb, RandomUtil.getRandomLong());
        String nonce = cb.toString();
        cb.setLength(0);
        cb.append("Digest ");
        cb.append("realm=\"");
        cb.append(realm);
        cb.append("\", qop=\"auth\", ");
        cb.append("nonce=\"");
        cb.append(nonce);
        cb.append("\"");
        res.setHeader("WWW-Authenticate", cb.toString());
        res.sendError(401);
    }

    protected long getRandomLong(ServletContext application) {
        return RandomUtil.getRandomLong();
    }

    protected byte[] decodeDigest(String digest) {
        if (digest == null) {
            return null;
        }
        int len = (digest.length() + 1) / 2;
        byte[] clientDigest = new byte[len];
        int i = 0;
        while (i + 1 < digest.length()) {
            char ch1 = digest.charAt(i);
            char ch2 = digest.charAt(i + 1);
            int b = 0;
            if (ch1 >= '0' && ch1 <= '9') {
                b += ch1 - 48;
            } else if (ch1 >= 'a' && ch1 <= 'f') {
                b += ch1 - 97 + 10;
            }
            b *= 16;
            if (ch2 >= '0' && ch2 <= '9') {
                b += ch2 - 48;
            } else if (ch2 >= 'a' && ch2 <= 'f') {
                b += ch2 - 97 + 10;
            }
            clientDigest[i / 2] = (byte)b;
            i += 2;
        }
        return clientDigest;
    }

    protected String scanKey(CharCursor cursor) {
        char ch;
        while (XmlChar.isWhitespace(ch = cursor.current()) || ch == ',') {
            cursor.next();
        }
        ch = cursor.current();
        if (ch == '\uffff') {
            return null;
        }
        if (!XmlChar.isNameStart(ch)) {
            throw new RuntimeException("bad key: " + (char)ch + " " + cursor);
        }
        CharBuffer cb = CharBuffer.allocate();
        while (XmlChar.isNameChar(ch = cursor.read())) {
            cb.append(ch);
        }
        if (ch != '\uffff') {
            cursor.previous();
        }
        return cb.close();
    }

    protected String scanValue(CharCursor cursor) {
        this.skipWhitespace(cursor);
        char ch = cursor.read();
        if (ch != '=') {
            throw new RuntimeException("expected '='");
        }
        this.skipWhitespace(cursor);
        CharBuffer cb = CharBuffer.allocate();
        ch = cursor.read();
        if (ch == '\"') {
            while ((ch = cursor.read()) != '\uffff' && ch != '\"') {
                cb.append(ch);
            }
        } else {
            while (ch != '\uffff' && ch != ',' && !XmlChar.isWhitespace(ch)) {
                cb.append(ch);
                ch = cursor.read();
            }
            if (ch != '\uffff') {
                cursor.previous();
            }
        }
        return cb.close();
    }

    protected void skipWhitespace(CharCursor cursor) {
        while (XmlChar.isWhitespace(cursor.current())) {
            cursor.next();
        }
    }
}

