/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.VersionFactory;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.manager.BamManager;
import com.caucho.bam.stream.MessageStream;
import com.caucho.cloud.bam.BamSystem;
import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.distcache.ClusterCache;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.env.thread.ThreadPool;
import com.caucho.hemp.broker.HempBrokerManager;
import com.caucho.hemp.servlet.ServerAuthManager;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.make.AlwaysModified;
import com.caucho.management.server.EnvironmentMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.rewrite.DispatchRule;
import com.caucho.security.AdminAuthenticator;
import com.caucho.security.PermissionManager;
import com.caucho.server.cluster.ServerAdmin;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationBuilder;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.dispatch.InvocationMatcher;
import com.caucho.server.dispatch.InvocationServer;
import com.caucho.server.distcache.PersistentStoreConfig;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.server.host.HostExpandDeployGenerator;
import com.caucho.server.http.HttpBufferStore;
import com.caucho.server.httpcache.AbstractProxyCache;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.server.log.AccessLog;
import com.caucho.server.resin.Resin;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.FreeRing;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.Vfs;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;

public class ServletService
implements AlarmListener,
ClassLoaderListener,
InvocationBuilder,
Dependency {
    private static final L10N L = new L10N(ServletService.class);
    private static final Logger log = Logger.getLogger(ServletService.class.getName());
    private static final long ALARM_INTERVAL = 60000L;
    private static final EnvironmentLocal<String> _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    private static final EnvironmentLocal<ServletService> _serverLocal = new EnvironmentLocal();
    private final Resin _resin;
    private final ResinSystem _resinSystem;
    private final CloudServer _selfServer;
    private Throwable _configException;
    private ServerAuthManager _authManager;
    private AdminAuthenticator _adminAuth;
    private InjectManager _cdiManager;
    private BamSystem _bamService;
    private InvocationServer _invocationServer;
    private HostContainer _hostContainer;
    private ErrorPageManager _errorPageManager = new ErrorPageManager(this);
    private String _stage = "production";
    private boolean _isPreview;
    private boolean _isEnabled = true;
    private String _serverHeader;
    private int _urlLengthMax = 8192;
    private int _headerSizeMax = TempBuffer.isSmallmem() ? 4096 : 16384;
    private int _headerCountMax = TempBuffer.isSmallmem() ? 32 : 256;
    private long _waitForActiveTime = 10000L;
    private boolean _isDevelopmentModeErrorPage;
    private long _shutdownWaitMax = 120000L;
    private boolean _isIgnoreClientDisconnect = true;
    private String _connectionErrorPage;
    private ServerAdmin _admin;
    private Alarm _alarm;
    private AbstractProxyCache _proxyCache;
    private PersistentStoreConfig _persistentStoreConfig;
    private boolean _isSendfileEnabled = true;
    private long _sendfileMinLength = 32768L;
    private final FreeRing<HttpBufferStore> _httpBufferFreeList = new FreeRing(256);
    private ClusterCache _systemStore;
    private final AtomicLong _sendfileCount = new AtomicLong();
    private long _startTime;
    private final Lifecycle _lifecycle;
    private AccessLog _accessLog;
    private int _accessLogBufferSize;
    private boolean _isErrorPageServerId = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletService(Resin resin) {
        if (resin == null) {
            throw new NullPointerException();
        }
        ResinSystem resinSystem = resin.getResinSystem();
        if (resinSystem == null) {
            throw new NullPointerException();
        }
        this._resin = resin;
        this._resinSystem = resinSystem;
        this._invocationServer = new InvocationServer(this);
        this._selfServer = resin.getSelfServer();
        String id = this._selfServer.getId();
        if ("".equals(id)) {
            throw new IllegalStateException();
        }
        _serverLocal.set(this, this.getClassLoader());
        this._serverHeader = !CurrentTime.isTest() ? "Resin/" + VersionFactory.getVersion() : "Resin/1.1";
        try {
            Thread thread = Thread.currentThread();
            Environment.addClassLoaderListener(this, this.getClassLoader());
            PermissionManager permissionManager = new PermissionManager();
            PermissionManager.setPermissionManager(permissionManager);
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.getClassLoader());
                _serverIdLocal.set(this._selfServer.getId());
                this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
                this.preInit();
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw ConfigException.create(e);
        }
    }

    protected void preInit() {
        this._cdiManager = InjectManager.create();
        this._hostContainer = new HostContainer(this);
        this._alarm = new Alarm(this);
        this._bamService = BamSystem.getCurrent();
        this._authManager = new ServerAuthManager();
        this._authManager.setAuthenticationRequired(false);
        this._bamService.setLinkManager(this._authManager);
    }

    public static ServletService getCurrent() {
        return _serverLocal.get();
    }

    public ResinSystem getResinSystem() {
        return this._resinSystem;
    }

    public boolean isResinServer() {
        if (this._resin != null) {
            return this._resin.isResinServer();
        }
        return false;
    }

    public String getUniqueServerName() {
        return this._resin.getUniqueServerName();
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._resinSystem.getClassLoader();
    }

    public Throwable getConfigException() {
        return this._configException;
    }

    public void setConfigException(Throwable exn) {
        this._configException = exn;
    }

    public Resin getResin() {
        return this._resin;
    }

    public boolean isWatchdog() {
        return this.getResin().isWatchdog();
    }

    public CloudCluster getCluster() {
        return this._selfServer.getCluster();
    }

    public CloudCluster[] getClusterList() {
        return this._selfServer.getCluster().getSystem().getClusterList();
    }

    public Path getResinDataDirectory() {
        return this._resin.getResinDataDirectory();
    }

    protected HempBrokerManager createBrokerManager() {
        return new HempBrokerManager(this._resinSystem);
    }

    protected ClusterServer getClusterServer() {
        return this.getSelfServer();
    }

    public ClusterServer getSelfServer() {
        return this._selfServer.getData(ClusterServer.class);
    }

    public CloudPod getPod() {
        return this._selfServer.getPod();
    }

    public BamManager getBamManager() {
        return this._bamService.getBamManager();
    }

    public ManagedBroker getBamBroker() {
        return this._bamService.getBroker();
    }

    public ManagedBroker getAdminBroker() {
        return this.getBamBroker();
    }

    public BamManager getAdminBrokerManager() {
        return this._bamService.getBamManager();
    }

    public ActorSender createAdminClient(String uid) {
        return this.createAdminClient(uid, null);
    }

    public ActorSender createAdminClient(String uid, String resource) {
        return this.getAdminBrokerManager().createClient(uid, resource);
    }

    public String getBamAdminName() {
        return this.getClusterServer().getBamAdminName();
    }

    public Broker getBroker() {
        return this._bamService.getBroker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminAuthenticator getAdminAuthenticator() {
        if (this._adminAuth == null) {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.getClassLoader());
                this._adminAuth = this._cdiManager.getReference(AdminAuthenticator.class, new Annotation[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, e.toString(), e);
                } else {
                    log.finer(e.toString());
                }
                this._adminAuth = new AdminAuthenticator();
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
        return this._adminAuth;
    }

    public boolean isDevelopmentModeErrorPage() {
        return this._isDevelopmentModeErrorPage;
    }

    public void setDevelopmentModeErrorPage(boolean isEnable) {
        this._isDevelopmentModeErrorPage = isEnable;
    }

    public boolean isErrorPageServerId() {
        return this._isErrorPageServerId;
    }

    public void setErrorPageServerId(boolean isEnable) {
        this._isErrorPageServerId = isEnable;
    }

    public void setStage(String stage) {
        this._stage = stage == null || "".equals(stage) ? "production" : stage;
        this._isPreview = "preview".equals(this._stage);
    }

    public String getStage() {
        return this._stage;
    }

    public boolean isPreview() {
        return this._isPreview;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this._isEnabled = isEnabled;
        this.clearCache();
    }

    public void setShutdownWaitMax(Period waitTime) {
        this._shutdownWaitMax = waitTime.getPeriod();
    }

    public long getShutdownWaitMax() {
        return this._shutdownWaitMax;
    }

    public void setConnectionErrorPage(String errorPage) {
        this._connectionErrorPage = errorPage;
    }

    public String getConnectionErrorPage() {
        return this._connectionErrorPage;
    }

    public boolean isDeployError() {
        return this._configException != null;
    }

    public boolean isIgnoreClientDisconnect() {
        return this._isIgnoreClientDisconnect;
    }

    public void setIgnoreClientDisconnect(boolean isIgnore) {
        this._isIgnoreClientDisconnect = isIgnore;
    }

    public String getServerId() {
        return this._selfServer.getId();
    }

    public void setRootDirectory(Path path) {
        this._hostContainer.setRootDirectory(path);
        Vfs.setPwd(path, this.getClassLoader());
    }

    public Path getRootDirectory() {
        return this._hostContainer.getRootDirectory();
    }

    public void setServerHeader(String server) {
        this._serverHeader = server;
    }

    public String getServerHeader() {
        return this._serverHeader;
    }

    public void setUrlLengthMax(int length) {
        this._urlLengthMax = length;
        this.getInvocationDecoder().setMaxURILength(length);
    }

    public int getUrlLengthMax() {
        return this._urlLengthMax;
    }

    public void setHeaderSizeMax(int length) {
        this._headerSizeMax = length;
    }

    public int getHeaderSizeMax() {
        return this._headerSizeMax;
    }

    public void setHeaderCountMax(int length) {
        this._headerCountMax = length;
    }

    public int getHeaderCountMax() {
        return this._headerCountMax;
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._hostContainer.addWebAppDefault(init);
    }

    public void addEarDefault(EarConfig config) {
        this._hostContainer.addEarDefault(config);
    }

    public void addHostDefault(HostConfig init) {
        this._hostContainer.addHostDefault(init);
    }

    public HostExpandDeployGenerator createHostDeploy() {
        return this._hostContainer.createHostDeploy();
    }

    public void addHostDeploy(HostExpandDeployGenerator deploy) {
        this._hostContainer.addHostDeploy(deploy);
    }

    public void addHost(HostConfig host) {
        this._hostContainer.addHost(host);
    }

    public RewriteDispatch createRewriteDispatch() {
        return this._hostContainer.createRewriteDispatch();
    }

    public void add(DispatchRule rewriteRule) {
        this.createRewriteDispatch().addRule(rewriteRule);
    }

    public AbstractProxyCache getProxyCache() {
        return this._proxyCache;
    }

    public final AbstractProxyCache createProxyCache() throws ConfigException {
        if (this._proxyCache == null) {
            this._proxyCache = this.instantiateProxyCache();
        }
        return this._proxyCache;
    }

    protected AbstractProxyCache instantiateProxyCache() {
        log.warning(L.l("<proxy-cache> requires Resin Professional.  Please see http://www.caucho.com for Resin Professional information and licensing."));
        return new AbstractProxyCache();
    }

    public void setSendfileEnable(boolean isEnable) {
        this._isSendfileEnabled = isEnable;
    }

    public boolean isSendfileEnable() {
        return this._isSendfileEnabled;
    }

    public long getSendfileMinLength() {
        return this._sendfileMinLength;
    }

    public void setSendfileMinLength(long bytes) {
        this._sendfileMinLength = bytes;
    }

    public long getSendfileCount() {
        return this._sendfileCount.get();
    }

    public void addSendfileCount() {
        this._sendfileCount.incrementAndGet();
    }

    public void setAccessLog(AccessLog log) {
        this._accessLog = log;
        Environment.setAttribute("caucho.server.access-log", log);
    }

    public AbstractAccessLog getAccessLog() {
        return this._accessLog;
    }

    public void setAccessLogBufferSize(Bytes bytes) {
        this._accessLogBufferSize = (int)bytes.getBytes();
    }

    public int getAccessLogBufferSize() {
        if (this._accessLogBufferSize > 0) {
            return this._accessLogBufferSize;
        }
        if (this._accessLog != null) {
            return this._accessLog.getBufferSize();
        }
        return 1024;
    }

    public long getDependencyCheckInterval() {
        return Environment.getDependencyCheckInterval(this.getClassLoader());
    }

    public void setSessionCookie(String cookie) {
        this.getInvocationDecoder().setSessionCookie(cookie);
    }

    public String getSessionCookie() {
        return this.getInvocationDecoder().getSessionCookie();
    }

    public void setSSLSessionCookie(String cookie) {
        this.getInvocationDecoder().setSSLSessionCookie(cookie);
    }

    public String getSSLSessionCookie() {
        return this.getInvocationDecoder().getSSLSessionCookie();
    }

    public void setSessionURLPrefix(String urlPrefix) {
        this.getInvocationDecoder().setSessionURLPrefix(urlPrefix);
    }

    public String getSessionURLPrefix() {
        return this.getInvocationDecoder().getSessionURLPrefix();
    }

    public void setAlternateSessionURLPrefix(String urlPrefix) throws ConfigException {
        this.getInvocationDecoder().setAlternateSessionURLPrefix(urlPrefix);
    }

    public String getAlternateSessionURLPrefix() {
        return this.getInvocationDecoder().getAlternateSessionURLPrefix();
    }

    public void setURLCharacterEncoding(String encoding) throws ConfigException {
        this.getInvocationDecoder().setEncoding(encoding);
    }

    public String getURLCharacterEncoding() {
        return this.getInvocationDecoder().getEncoding();
    }

    public InvocationDecoder getInvocationDecoder() {
        return this.getInvocationServer().getInvocationDecoder();
    }

    public InvocationServer getInvocationServer() {
        return this._invocationServer;
    }

    public void addErrorPage(ErrorPage errorPage) {
        WebApp webApp = this.getErrorWebApp();
        if (webApp != null) {
            webApp.addErrorPage(errorPage);
        }
    }

    public void setPersistentStore(PersistentStoreConfig config) {
        this._persistentStoreConfig = config;
    }

    public PersistentStoreConfig getPersistentStore() {
        return this._persistentStoreConfig;
    }

    public int getServerIndex() {
        return this._selfServer.getIndex();
    }

    public long getStartTime() {
        return this._startTime;
    }

    public String getState() {
        return this._lifecycle.getStateName();
    }

    public double getCpuLoad() {
        return 0.0;
    }

    @Override
    public Invocation buildInvocation(Invocation invocation) throws ConfigException {
        if (this._configException != null) {
            invocation.setFilterChain(new ExceptionFilterChain(this._configException));
            invocation.setWebApp(this.getErrorWebApp());
            invocation.setDependency(AlwaysModified.create());
            return invocation;
        }
        if (this._lifecycle.waitForActive(this._waitForActiveTime)) {
            return this._hostContainer.buildInvocation(invocation);
        }
        int code = 503;
        invocation.setFilterChain(new ErrorFilterChain(code));
        invocation.setWebApp(this.getErrorWebApp());
        invocation.setDependency(AlwaysModified.create());
        return invocation;
    }

    public ServerMXBean getAdmin() {
        return this._admin;
    }

    public EnvironmentMXBean getEnvironmentAdmin() {
        return this.getClassLoader().getAdmin();
    }

    public WebApp getDefaultWebApp() {
        WebApp webApp = this.getWebApp("", 80, "");
        if (webApp != null) {
            return webApp;
        }
        return this.getErrorWebApp();
    }

    public WebApp getWebApp(String hostName, int port, String url) {
        try {
            HostContainer hostContainer = this._hostContainer;
            if (hostContainer == null) {
                return null;
            }
            Host host = hostContainer.getHost(hostName, port);
            if (host == null) {
                return null;
            }
            return host.getWebAppContainer().findWebAppByURI(url);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public WebApp getErrorWebApp() {
        if (this.isActive()) {
            return this._hostContainer.getErrorWebApp();
        }
        return null;
    }

    public ErrorPageManager getErrorPageManager() {
        WebApp errorWebApp = this.getErrorWebApp();
        if (errorWebApp != null) {
            return errorWebApp.getErrorPageManager();
        }
        return this._errorPageManager;
    }

    public HostController[] getHostControllers() {
        HostContainer hostContainer = this._hostContainer;
        if (hostContainer == null) {
            return new HostController[0];
        }
        return hostContainer.getHostList();
    }

    public Host getHost(String hostName, int port) {
        try {
            return this._hostContainer.getHost(hostName, port);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public HostController getHostController(String hostName, int port) {
        try {
            return this._hostContainer.getHostController(hostName, port);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterCache getSystemStore() {
        ServletService servletService = this;
        synchronized (servletService) {
            if (this._systemStore == null) {
                this._systemStore = new ClusterCache();
                this._systemStore.setName("resin:system");
                this._systemStore.setManagerName("resin");
                this._systemStore.setModifiedExpireTimeoutMillis(0x3FFFFFFFFFFFFFFFL);
                this._systemStore.setAccessedExpireTimeoutMillis(0x3FFFFFFFFFFFFFFFL);
                this._systemStore.setLocalExpireTimeoutMillis(10L);
            }
        }
        this._systemStore.init();
        return this._systemStore;
    }

    public HttpBufferStore allocateHttpBuffer() {
        HttpBufferStore buffer = this._httpBufferFreeList.allocate();
        if (buffer == null) {
            buffer = new HttpBufferStore(this.getUrlLengthMax(), this.getHeaderSizeMax(), this.getHeaderCountMax());
        }
        return buffer;
    }

    public void freeHttpBuffer(HttpBufferStore buffer) {
        this._httpBufferFreeList.free(buffer);
    }

    @Override
    public void classLoaderInit(DynamicClassLoader loader) {
    }

    @Override
    public void classLoaderDestroy(DynamicClassLoader loader) {
    }

    @PostConstruct
    public void init() {
        if (!this._lifecycle.toInit()) {
            return;
        }
        if (this._proxyCache != null && this._invocationServer.getInvocationCacheSize() < this._proxyCache.getEntries()) {
            this._invocationServer.setInvocationCacheSize(this._proxyCache.getEntries());
        }
        this._invocationServer.init();
        this._admin = this.createAdmin();
    }

    protected ServerAdmin createAdmin() {
        return new ServerAdmin(this);
    }

    public void start() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            if (!this._lifecycle.toStarting()) {
                return;
            }
            this._startTime = CurrentTime.getCurrentTime();
            if (!CurrentTime.isTest()) {
                log.info("");
                Resin resin = Resin.getCurrent();
                if (resin != null) {
                    log.info("resin.home = " + resin.getResinHome().getNativePath());
                    log.info("resin.root = " + resin.getRootDirectory().getNativePath());
                    if (resin.getResinConf() != null) {
                        log.info("resin.conf = " + resin.getResinConf().getNativePath());
                    }
                    log.info("");
                    String serverType = resin.isWatchdog() ? "watchdog" : "server";
                    log.info(serverType + "    = " + this._selfServer.getAddress() + ":" + this._selfServer.getPort() + " (" + this.getCluster().getId() + ":" + this.getServerId() + ")");
                } else {
                    log.info("resin.home = " + System.getProperty("resin.home"));
                }
                log.info("stage      = " + this._stage);
            }
            this._lifecycle.toStarting();
            if (this.isResinServer()) {
                this.getSystemStore();
            }
            this._hostContainer.start();
            this._alarm.queue(60000L);
            this._lifecycle.toActive();
            this.logModules();
            AdminAuthenticator adminAuth = this.getAdminAuthenticator();
            if (adminAuth != null) {
                adminAuth.init();
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.toString(), e);
            this._lifecycle.toError();
            throw e;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            this._lifecycle.toError();
            throw new RuntimeException(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void startImpl() {
    }

    protected void logModules() {
    }

    @Override
    public void handleAlarm(Alarm alarm) {
        if (!this._lifecycle.isActive()) {
            return;
        }
        try {
            if (this.isModified()) {
                String msg = L.l("Resin restarting due to configuration change");
                ShutdownSystem.getCurrent().shutdown(ExitCode.MODIFIED, msg);
                return;
            }
        }
        finally {
            if (this._lifecycle.isActive()) {
                alarm.queue(60000L);
            }
        }
    }

    @Override
    public boolean isModified() {
        EnvironmentClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            return classLoader.isModified();
        }
        return true;
    }

    @Override
    public boolean logModified(Logger log) {
        EnvironmentClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            return classLoader.logModified(log);
        }
        log.info(this + " is closed");
        return true;
    }

    public boolean isModifiedNow() {
        EnvironmentClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            return classLoader.isModifiedNow();
        }
        return true;
    }

    public boolean isAfterStarting() {
        return this._lifecycle.getState().isAfterStarting();
    }

    public boolean isStopping() {
        return this._lifecycle.isStopping();
    }

    public boolean isStopped() {
        return this._lifecycle.isStopped();
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public boolean isDestroying() {
        return this._lifecycle.isDestroying();
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public void clearCacheByPattern(String hostPattern, String uriPattern) {
        final Matcher hostMatcher = hostPattern != null ? Pattern.compile(hostPattern).matcher("") : null;
        final Matcher uriMatcher = uriPattern != null ? Pattern.compile(uriPattern).matcher("") : null;
        InvocationMatcher matcher = new InvocationMatcher(){

            @Override
            public boolean isMatch(Invocation invocation) {
                if (hostMatcher != null) {
                    hostMatcher.reset(invocation.getHost());
                    if (!hostMatcher.find()) {
                        return false;
                    }
                }
                if (uriMatcher != null) {
                    uriMatcher.reset(invocation.getURI());
                    if (!uriMatcher.find()) {
                        return false;
                    }
                }
                return true;
            }
        };
        this.getInvocationServer().invalidateMatchingInvocations(matcher);
    }

    public void clearCache() {
        if (this.isStopping()) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finest("ServletServer clearCache");
        }
        this.getInvocationServer().clearCache();
        if (this._proxyCache != null) {
            this._proxyCache.clear();
        }
    }

    public long getProxyCacheHitCount() {
        if (this._proxyCache != null) {
            return this._proxyCache.getHitCount();
        }
        return 0L;
    }

    public long getProxyCacheMissCount() {
        if (this._proxyCache != null) {
            return this._proxyCache.getMissCount();
        }
        return 0L;
    }

    public MessageStream getHmtpStream() {
        return null;
    }

    public void restart() {
        String msg = L.l("Server restarting due to configuration change");
        ShutdownSystem.shutdownActive(ExitCode.MODIFIED, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            if (!this._lifecycle.toStopping()) {
                return;
            }
            this.notifyStop();
            Alarm alarm = this._alarm;
            this._alarm = null;
            if (alarm != null) {
                alarm.dequeue();
            }
            try {
                if (this._systemStore != null) {
                    this._systemStore.close();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                ThreadPool.getThreadPool().clearIdleThreads();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                Thread.sleep(1L);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this._hostContainer != null) {
                    this._hostContainer.stop();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                this.getClassLoader().stop();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            this._lifecycle.toStop();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void notifyStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            try {
                this._hostContainer.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            log.fine(this + " destroyed");
            this.getInvocationServer().destroy();
            this._proxyCache = null;
        }
        finally {
            DynamicClassLoader.setOldLoader(thread, oldLoader);
            Resin resin = this._resin;
            if (resin != null) {
                resin.destroy();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getServerId() + ",cluster=" + this._selfServer.getCluster().getId() + "]";
    }
}

