/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;

public class UrlMap<E> {
    private static final L10N L = new L10N(UrlMap.class);
    private ArrayList<RegexpEntry<E>> _regexps = new ArrayList();

    public UrlMap() {
    }

    public UrlMap(boolean bestShort) {
    }

    void setBestShort(boolean bestShort) {
    }

    boolean contains(Filter<E> filter) {
        for (int i = this._regexps.size() - 1; i >= 0; --i) {
            RegexpEntry<E> regexp = this._regexps.get(i);
            if (!filter.isMatch(regexp.getValue())) continue;
            return true;
        }
        return false;
    }

    int size() {
        return this._regexps.size();
    }

    public void addMap(String pattern, E value, boolean isIgnore) throws PatternSyntaxException {
        this.addMap(pattern, null, value, isIgnore, false);
    }

    public void addMap(String pattern, E value) throws PatternSyntaxException {
        this.addMap(pattern, null, value, false, false);
    }

    public void addMap(String pattern, E value, boolean isIgnore, boolean ifAbsent) throws PatternSyntaxException {
        this.addMap(pattern, null, value, isIgnore, ifAbsent);
    }

    public void addMap(String pattern, String flags, E value, boolean isIgnore, boolean ifAbsent) throws PatternSyntaxException {
        boolean startsWithSlash;
        if (pattern.length() == 0) {
            this.addRegexp(-1, "^/$", flags, value, true, isIgnore, ifAbsent);
            return;
        }
        boolean bl = startsWithSlash = pattern.charAt(0) == '/';
        if (pattern.length() == 1 && startsWithSlash) {
            this.addRegexp(-1, "", flags, value, true, isIgnore, ifAbsent);
            return;
        }
        if (pattern.equals("/*")) {
            this.addRegexp(1, "/*", flags, value, true, isIgnore, ifAbsent);
            return;
        }
        int length = pattern.length();
        boolean isExact = true;
        if (!startsWithSlash && pattern.charAt(0) != '*') {
            pattern = "/" + pattern;
            ++length;
        }
        int prefixLength = -1;
        boolean isShort = false;
        boolean hasWildcard = false;
        CharBuffer cb = new CharBuffer();
        cb.append("^");
        for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            if (ch == '*' && i + 1 == length && i > 0) {
                hasWildcard = true;
                isExact = false;
                if (pattern.charAt(i - 1) == '/') {
                    cb.setLength(cb.length() - 1);
                    if (prefixLength < 0) {
                        prefixLength = i - 1;
                    }
                } else if (prefixLength < 0) {
                    prefixLength = i;
                }
                if (prefixLength != 0) continue;
                prefixLength = 1;
                continue;
            }
            if (ch == '*') {
                hasWildcard = true;
                isExact = false;
                cb.append(".*");
                if (prefixLength < 0) {
                    prefixLength = i;
                }
                if (i != 0) continue;
                isShort = true;
                continue;
            }
            if (ch == '.' || ch == '[' || ch == '^' || ch == '$' || ch == '{' || ch == '}' || ch == '|' || ch == '(' || ch == ')' || ch == '?') {
                cb.append('\\');
                cb.append(ch);
                continue;
            }
            cb.append(ch);
        }
        if (isExact) {
            cb.append("$");
        } else {
            cb.append("(?=/)|" + cb.toString() + "\\z");
        }
        if (prefixLength < 0) {
            prefixLength = pattern.length();
        } else if (prefixLength < pattern.length() && pattern.charAt(prefixLength) == '/') {
            --prefixLength;
        }
        if (cb.length() > 0 && cb.charAt(0) == '/') {
            cb.insert(0, '^');
        }
        this.addRegexp(prefixLength, pattern, cb.close(), flags, value, isShort, isIgnore, ifAbsent, !hasWildcard);
    }

    public static String urlPatternToRegexpPattern(String pattern) {
        if (pattern.length() == 0 || pattern.length() == 1 && pattern.charAt(0) == '/') {
            return "^.*$";
        }
        if (pattern.equals("/*")) {
            return "^.*$";
        }
        int length = pattern.length();
        if (pattern.charAt(0) != '/' && pattern.charAt(0) != '*') {
            pattern = "/" + pattern;
            ++length;
        }
        boolean isExact = true;
        CharBuffer cb = new CharBuffer();
        cb.append("^");
        for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            if (ch == '*' && i + 1 == length && i > 0) {
                isExact = false;
                if (pattern.charAt(i - 1) != '/') continue;
                cb.setLength(cb.length() - 1);
                continue;
            }
            if (ch == '*') {
                isExact = false;
                cb.append(".*");
                continue;
            }
            if (ch == '.' || ch == '[' || ch == '^' || ch == '$' || ch == '{' || ch == '}' || ch == '|' || ch == '(' || ch == ')' || ch == '?') {
                cb.append('\\');
                cb.append(ch);
                continue;
            }
            cb.append(ch);
        }
        if (isExact) {
            cb.append("\\z");
        } else {
            cb.append("(?=/)|" + cb.toString() + "\\z");
        }
        if (cb.length() > 0 && cb.charAt(0) == '/') {
            cb.insert(0, '^');
        }
        return cb.close();
    }

    public void addStrictMap(String pattern, String flags, E value) throws PatternSyntaxException, ServletException {
        boolean ifAbsent = false;
        if (pattern.length() == 0 || pattern.length() == 1 && pattern.charAt(0) == '/') {
            this.addRegexp(-1, "^.*$", flags, value, true, false, ifAbsent);
            return;
        }
        int length = pattern.length();
        if (pattern.charAt(0) != '/' && pattern.charAt(0) != '*') {
            pattern = "/" + pattern;
            ++length;
        }
        if (pattern.indexOf(42) < pattern.lastIndexOf(42)) {
            throw new ServletException("at most one '*' is allowed");
        }
        int prefixLength = -1;
        boolean isShort = false;
        CharBuffer cb = new CharBuffer();
        cb.append('^');
        block4: for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '*': {
                    if (i > 0 && i + 1 == length && pattern.charAt(i - 1) == '/') {
                        cb.append(".*");
                        continue block4;
                    }
                    if (i == 0 && length > 1 && pattern.charAt(1) == '.' && pattern.lastIndexOf(47) < 0) {
                        cb.append(".*");
                        continue block4;
                    }
                    throw new ServletException(L.l("illegal url-pattern '{0}'", (Object)pattern));
                }
                case '$': 
                case '(': 
                case '.': 
                case '?': 
                case '[': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    cb.append('\\');
                    cb.append(ch);
                    continue block4;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        cb.append("$");
        this.addRegexp(prefixLength, pattern, cb.close(), flags, value, isShort, false, ifAbsent, false);
    }

    public void addRegexp(String regexp, String flags, E value) throws PatternSyntaxException {
        this.addRegexp(0, regexp, flags, value, false, false, false);
    }

    public void addRegexp(String regexp, E value) throws PatternSyntaxException {
        this.addRegexp(0, regexp, null, value, false, false, false);
    }

    public void addRegexpIfAbsent(String regexp, E value) throws PatternSyntaxException {
        this.addRegexp(0, regexp, null, value, false, false, true);
    }

    public void addRegexp(int prefixLength, String regexp, String flags, E value, boolean isShort, boolean isIgnore, boolean ifAbsent) throws PatternSyntaxException {
        RegexpEntry<E> entry = new RegexpEntry<E>(prefixLength, regexp, flags, value);
        for (int i = 0; i < this._regexps.size(); ++i) {
            RegexpEntry<E> re = this._regexps.get(i);
            if (!re.equals(entry)) continue;
            if (ifAbsent) {
                return;
            }
            this._regexps.remove(i);
            break;
        }
        if (isShort) {
            entry.setShortMatch();
        }
        if (isIgnore) {
            entry.setIgnore(true);
        }
        this._regexps.add(entry);
    }

    public void addRegexp(int prefixLength, String pattern, String regexp, String flags, E value, boolean isShort, boolean isIgnore, boolean ifAbsent, boolean isSimple) throws PatternSyntaxException {
        RegexpEntry<E> entry = new RegexpEntry<E>(prefixLength, pattern, regexp, flags, value, isIgnore, isSimple);
        for (int i = this._regexps.size() - 1; i >= 0; --i) {
            RegexpEntry<E> re = this._regexps.get(i);
            if (!re.equals(entry)) continue;
            if (ifAbsent) {
                return;
            }
            this._regexps.remove(i);
        }
        if (isShort) {
            entry.setShortMatch();
        }
        this._regexps.add(entry);
    }

    public E map(String uri) {
        return this.map(uri, null);
    }

    public E map(String uri, ArrayList<String> vars) {
        return this.map(uri, vars, false);
    }

    public E map(String uri, ArrayList<String> vars, boolean isWelcome) {
        E best = null;
        if (vars != null) {
            vars.add(uri);
        }
        int bestPrefixLength = -2;
        int bestMinLength = -2;
        for (int i = 0; i < this._regexps.size(); ++i) {
            Matcher matcher;
            RegexpEntry<E> entry = this._regexps.get(i);
            if (isWelcome && !entry.isSimple() || entry.isIgnore() || entry._prefixLength < bestPrefixLength || !(matcher = entry._regexp.matcher(uri)).find()) continue;
            int begin = matcher.start();
            int end = matcher.end();
            int length = end - begin;
            if (bestPrefixLength >= entry._prefixLength && bestMinLength >= length) continue;
            if (vars != null) {
                vars.clear();
                if ("/*".equals(entry.getPattern())) {
                    vars.add("");
                } else {
                    vars.add(uri.substring(0, end));
                }
                for (int j = 1; j <= matcher.groupCount(); ++j) {
                    vars.add(matcher.group(j));
                }
            }
            best = entry._value;
            bestPrefixLength = entry._prefixLength;
            if (!entry.isShortMatch()) {
                bestMinLength = length;
            }
            if (bestMinLength >= entry._prefixLength) continue;
            bestMinLength = entry._prefixLength;
        }
        return best;
    }

    public ArrayList<String> getURLPatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (int i = 0; i < this._regexps.size(); ++i) {
            RegexpEntry<E> entry = this._regexps.get(i);
            String urlPattern = entry.getURLPattern();
            if (urlPattern == null) continue;
            patterns.add(urlPattern);
        }
        return patterns;
    }

    public static interface Filter<X> {
        public boolean isMatch(X var1);
    }

    static class RegexpEntry<E> {
        String _urlPattern;
        String _pattern;
        int _flags;
        Pattern _regexp;
        E _value;
        int _prefixLength;
        boolean _shortMatch;
        boolean _isIgnore;
        boolean _isSimple;

        RegexpEntry(int prefixLength, String pattern, String flags, E value) throws PatternSyntaxException {
            this(prefixLength, pattern, pattern, flags, value, false, false);
        }

        RegexpEntry(int prefixLength, String urlPattern, String pattern, String flags, E value, boolean isIgnore, boolean isSimple) throws PatternSyntaxException {
            this._urlPattern = urlPattern;
            this._prefixLength = prefixLength;
            this._pattern = pattern;
            if (flags == null && CauchoSystem.isCaseInsensitive()) {
                this._flags = 2;
            } else if (flags != null && flags.equals("i")) {
                this._flags = 2;
            }
            this._regexp = Pattern.compile(pattern, this._flags);
            this._value = value;
            this._isIgnore = isIgnore;
            this._isSimple = isSimple;
        }

        void setIgnore(boolean isIgnore) {
            this._isIgnore = isIgnore;
        }

        boolean isIgnore() {
            return this._isIgnore;
        }

        void setShortMatch() {
            this._shortMatch = true;
        }

        boolean isShortMatch() {
            return this._shortMatch;
        }

        String getURLPattern() {
            return this._urlPattern;
        }

        String getPattern() {
            return this._pattern;
        }

        E getValue() {
            return this._value;
        }

        boolean isSimple() {
            return this._isSimple;
        }

        public int hashCode() {
            if (this._urlPattern != null) {
                return this._urlPattern.hashCode();
            }
            if (this._pattern != null) {
                return this._pattern.hashCode();
            }
            return 17;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RegexpEntry)) {
                return false;
            }
            RegexpEntry re = (RegexpEntry)o;
            if (this._urlPattern != null) {
                return this._urlPattern.equals(re._urlPattern);
            }
            if (this._pattern != null) {
                return this._pattern.equals(re._pattern);
            }
            return false;
        }

        public String toString() {
            if (this._urlPattern != null) {
                return "RegexpEntry[" + this._urlPattern + "]";
            }
            if (this._pattern != null) {
                return "RegexpEntry[" + this._pattern + "]";
            }
            return super.toString();
        }
    }
}

