/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class VersionInvocation
extends Invocation {
    static final L10N L = new L10N(Invocation.class);
    private static final Logger log = Logger.getLogger(Invocation.class.getName());
    private final Invocation _invocation;
    private final WebApp _webApp;
    private final Invocation _oldInvocation;
    private final WebApp _oldWebApp;
    private final long _expireTime;

    public VersionInvocation(Invocation invocation, WebApp webApp, Invocation oldInvocation, WebApp oldWebApp, long expireTime) {
        this._invocation = invocation;
        this._webApp = webApp;
        this.setWebApp(webApp);
        this._oldInvocation = oldInvocation;
        this._oldWebApp = oldWebApp;
        this._expireTime = expireTime;
    }

    @Override
    public boolean isModified() {
        long now = CurrentTime.getCurrentTime();
        if (this._expireTime < now) {
            return true;
        }
        return this._invocation.isModified() || this._oldInvocation.isModified();
    }

    @Override
    public boolean logModified(Logger log) {
        long now = CurrentTime.getCurrentTime();
        if (this._expireTime < now) {
            log.info(L.l("{0}: versioning rollover complete.", (Object)this._webApp));
            return true;
        }
        return this._invocation.logModified(log) || this._oldInvocation.logModified(log);
    }

    @Override
    public Invocation getRequestInvocation(HttpServletRequestImpl request) {
        if (this._expireTime < CurrentTime.getCurrentTime()) {
            return this._invocation;
        }
        request.setInvocation(this);
        String sessionId = request.getRequestedSessionId();
        if (sessionId == null) {
            sessionId = this._invocation.getSessionId();
        }
        if (sessionId == null) {
            return this._invocation;
        }
        SessionManager oldSessionManager = this._oldWebApp.getSessionManager();
        if (oldSessionManager != null && oldSessionManager.containsSession(sessionId)) {
            return this._oldInvocation;
        }
        return this._invocation;
    }

    @Override
    public int hashCode() {
        return this._invocation.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this._invocation.equals(o);
    }
}

