/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.loader.Environment;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheImpl;
import com.caucho.server.distcache.CacheManagerImpl;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.util.L10N;
import java.util.concurrent.ConcurrentHashMap;

public class DistCacheSystem
extends AbstractResinSubSystem {
    private static final L10N L = new L10N(DistCacheSystem.class);
    public static final int START_PRIORITY = 45;
    private ConcurrentHashMap<String, CacheManagerImpl> _managerMap = new ConcurrentHashMap();
    private CacheStoreManager _distCacheManager;

    public DistCacheSystem(CacheStoreManager distCacheManager) {
        if (distCacheManager == null) {
            throw new NullPointerException();
        }
        this._distCacheManager = distCacheManager;
    }

    public static DistCacheSystem createAndAddService(CacheStoreManager distCacheManager) {
        ResinSystem system = DistCacheSystem.preCreate(DistCacheSystem.class);
        DistCacheSystem service = new DistCacheSystem(distCacheManager);
        system.addService(DistCacheSystem.class, service);
        return service;
    }

    public static DistCacheSystem getCurrent() {
        return ResinSystem.getCurrentService(DistCacheSystem.class);
    }

    public static CacheImpl getMatchingCache(String name) {
        DistCacheSystem cacheService = DistCacheSystem.getCurrent();
        if (cacheService == null) {
            return null;
        }
        CacheManagerImpl localManager = cacheService.getCacheManager();
        String contextId = Environment.getEnvironmentName();
        String guid = contextId + ":" + name;
        return localManager.getCache(guid);
    }

    public CacheStoreManager getDistCacheManager() {
        return this._distCacheManager;
    }

    public CacheManagerImpl getCacheManager() {
        String name = "Resin";
        return this.getCacheManager(name);
    }

    public CacheManagerImpl getCacheManager(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return this.getCacheManager(name, loader);
    }

    public CacheManagerImpl getCacheManager(String name, ClassLoader loader) {
        String guid = name + ":" + Environment.getEnvironmentName(loader);
        CacheManagerImpl cacheManager = this._managerMap.get(guid);
        if (cacheManager == null) {
            cacheManager = new CacheManagerImpl(this, name, guid, loader);
            this._managerMap.putIfAbsent(guid, cacheManager);
        }
        return this._managerMap.get(guid);
    }

    void removeCacheManager(String guid) {
        this._managerMap.remove(guid);
    }

    public CacheConfig getCacheConfig(byte[] cacheHash) {
        return this.getDistCacheManager().getCacheConfig(cacheHash);
    }

    @Override
    public int getStartPriority() {
        return 45;
    }

    @Override
    public void start() {
        this._distCacheManager.start();
    }

    @Override
    public void stop() {
        this._distCacheManager.close();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._distCacheManager + "]";
    }
}

