/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.inject.Module;
import com.caucho.server.distcache.CacheDataBackingImpl;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.LocalDataManager;
import com.caucho.server.distcache.LocalMnodeManager;
import com.caucho.util.HashKey;
import com.caucho.vfs.StreamSource;
import java.util.logging.Logger;

@Module
public final class LocalStoreManager {
    private static final Logger log = Logger.getLogger(LocalStoreManager.class.getName());
    private CacheDataBackingImpl _dataBacking;
    private final CacheStoreManager _cacheManager;
    private final LocalMnodeManager _localMnodeManager;
    private final LocalDataManager _localDataManager;

    LocalStoreManager(CacheStoreManager cacheStore) {
        this._cacheManager = cacheStore;
        this._localMnodeManager = cacheStore.getLocalMnodeManager();
        this._localDataManager = cacheStore.getLocalDataManager();
    }

    public StreamSource loadDataSource(byte[] keyHash, byte[] cacheHash) {
        HashKey key = HashKey.create(keyHash);
        HashKey cacheKey = HashKey.create(cacheHash);
        Object config = null;
        DistCacheEntry entry = this._cacheManager.loadLocalEntry(key, cacheKey);
        return entry.getValueStream();
    }
}

