/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.lang.ref.SoftReference;
import java.sql.Blob;

public final class MnodeEntry
extends MnodeValue {
    private static final L10N L = new L10N(MnodeEntry.class);
    public static final MnodeEntry NULL = new MnodeEntry(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, null, 0L, 0L, false, true);
    public static final long NULL_KEY = 0L;
    public static final long ANY_KEY = MnodeEntry.createAnyKey();
    private final long _valueDataId;
    private final long _valueDataTime;
    private final boolean _isServerVersionValid;
    private final boolean _isImplicitNull;
    private final long _lastModifiedTime;
    private volatile long _lastAccessTime;
    private int _leaseOwner = -1;
    private long _leaseExpireTime;
    private long _lastRemoteAccessTime;
    private int _hits = 0;
    private SoftReference<Object> _valueRef;
    private transient Blob _blob;

    public MnodeEntry(long valueHash, long valueLength, long version, long flags, long accessedExpireTimeout, long modifiedExpireTimeout, long leaseExpireTimeout, long valueDataId, long valueDataTime, Object value, long lastAccessTime, long lastModifiedTime, boolean isServerVersionValid, boolean isImplicitNull) {
        super(valueHash, valueLength, version, flags, accessedExpireTimeout, modifiedExpireTimeout, leaseExpireTimeout);
        this._valueDataId = valueDataId;
        this._valueDataTime = valueDataTime;
        this._lastRemoteAccessTime = lastAccessTime;
        this._lastModifiedTime = lastModifiedTime;
        this.setLastAccessTime(lastAccessTime);
        this._isImplicitNull = isImplicitNull;
        this._isServerVersionValid = isServerVersionValid;
        if (value != null) {
            this._valueRef = new SoftReference<Object>(value);
        }
        if (valueDataId != 0L != (valueHash != 0L)) {
            throw new IllegalStateException(L.l("mismatch dataId {0} and valueHash {1}", (Object)this._valueDataId, (Object)this));
        }
    }

    public MnodeEntry(MnodeValue mnodeValue, long valueDataId, long valueDataTime, Object value, long lastAccessTime, long lastModifiedTime, boolean isServerVersionValid, boolean isImplicitNull, int leaseOwner) {
        this(mnodeValue.getValueHash(), mnodeValue.getValueLength(), mnodeValue.getVersion(), mnodeValue.getFlags(), mnodeValue.getAccessedExpireTimeout(), mnodeValue.getModifiedExpireTimeout(), mnodeValue.getLeaseExpireTimeout(), valueDataId, valueDataTime, value, lastAccessTime, lastModifiedTime, isServerVersionValid, isImplicitNull);
        long now = CurrentTime.getCurrentTime();
        this.setLeaseOwner(leaseOwner, now);
    }

    public MnodeEntry(MnodeEntry oldMnodeValue, long valueDataId, long valueDataTime, long accessTimeout, long lastAccessTime) {
        super(oldMnodeValue.getValueHash(), oldMnodeValue.getValueLength(), oldMnodeValue.getVersion(), oldMnodeValue.getFlags(), accessTimeout, oldMnodeValue.getModifiedExpireTimeout(), oldMnodeValue.getLeaseExpireTimeout());
        this._valueDataId = valueDataId;
        this._valueDataTime = valueDataTime;
        this._lastRemoteAccessTime = lastAccessTime;
        this.setLastAccessTime(lastAccessTime);
        this._lastModifiedTime = oldMnodeValue._lastModifiedTime;
        this._leaseExpireTime = oldMnodeValue._leaseExpireTime;
        this._leaseOwner = oldMnodeValue._leaseOwner;
        this._isImplicitNull = oldMnodeValue.isImplicitNull();
        this._isServerVersionValid = oldMnodeValue.isServerVersionValid();
        Object value = oldMnodeValue.getValue();
        if (value != null) {
            this._valueRef = new SoftReference<Object>(value);
        }
    }

    public static MnodeEntry createInitialNull(CacheConfig config) {
        long accessedExpireTimeout = 0L;
        long modifiedExpireTimeout = 0L;
        long leaseExpireTimeout = 0L;
        long now = 0L;
        if (config != null) {
            accessedExpireTimeout = config.getAccessedExpireTimeout();
            modifiedExpireTimeout = config.getModifiedExpireTimeout();
            leaseExpireTimeout = config.getLeaseExpireTimeout();
        }
        return new MnodeEntry(0L, 0L, 0L, 0L, accessedExpireTimeout, modifiedExpireTimeout, leaseExpireTimeout, 0L, 0L, null, now, now, false, true);
    }

    public MnodeEntry updateModifiedTime(long now) {
        return new MnodeEntry(this.getValueHash(), this.getValueLength(), this.getVersion(), this.getFlags(), this.getAccessedExpireTimeout(), this.getModifiedExpireTimeout(), this.getLeaseExpireTimeout(), this.getValueDataId(), this.getValueDataTime(), this.getValue(), now, now, this.isServerVersionValid(), this.isImplicitNull());
    }

    public long getValueDataId() {
        return this._valueDataId;
    }

    public long getValueDataTime() {
        return this._valueDataTime;
    }

    public long getLastAccessedTime() {
        return this._lastAccessTime;
    }

    public void setLastAccessTime(long accessTime) {
        this._lastAccessTime = accessTime;
    }

    public long getLastRemoteAccessTime() {
        return this._lastRemoteAccessTime;
    }

    public void setLastRemoteAccessTime(long accessTime) {
        this._lastRemoteAccessTime = accessTime;
    }

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public final long getExpirationTime() {
        return this._lastModifiedTime + this.getModifiedExpireTimeout();
    }

    public final boolean isLocalExpired(int serverIndex, long now, CacheConfig config) {
        return this.isLocalExpired(serverIndex, now, config.getLocalExpireTimeout());
    }

    public final boolean isLocalExpired(int serverIndex, long now, long localExpireTimeout) {
        if (!this._isServerVersionValid) {
            return true;
        }
        if (this.isExpired(now)) {
            return true;
        }
        if (now <= this._lastAccessTime + localExpireTimeout) {
            return false;
        }
        return (serverIndex > 2 || localExpireTimeout <= 0L && this.getLeaseExpireTimeout() <= 0L) && (this._leaseOwner != serverIndex || now > this._leaseExpireTime);
    }

    public final boolean isLeaseExpired(long now) {
        return this._leaseOwner <= 0 || this._leaseExpireTime <= now;
    }

    public final boolean isExpired(long now) {
        return this.isIdleExpired(now) || this.isValueExpired(now);
    }

    public final boolean isValueExpired(long now) {
        return this._lastModifiedTime + this.getModifiedExpireTimeout() < now;
    }

    public final boolean isIdleExpired(long now) {
        return this._lastAccessTime + this.getAccessedExpireTimeout() < now;
    }

    public final int getLeaseOwner() {
        return this._leaseOwner;
    }

    public final void setLeaseOwner(int leaseOwner, long now) {
        if (leaseOwner > 2 && this.getLeaseExpireTimeout() > 0L) {
            this._leaseOwner = leaseOwner;
            this._leaseExpireTime = now + this.getLeaseExpireTimeout();
        } else {
            this._leaseOwner = -1;
            this._leaseExpireTime = 0L;
        }
    }

    public final void clearLease() {
        this._leaseOwner = -1;
        this._leaseExpireTime = 0L;
    }

    public final void clearLease(int oldLeaseOwner) {
        if (this._leaseOwner == oldLeaseOwner) {
            this._leaseOwner = -1;
            this._leaseExpireTime = 0L;
        }
    }

    public long getAccessExpireTimeoutWindow() {
        long windowMax;
        long window = this.getAccessedExpireTimeout() / 4L;
        if (window < (windowMax = 900000L)) {
            return window;
        }
        return windowMax;
    }

    public final void setObjectValue(Object value) {
        if (value != null && (this._valueRef == null || this._valueRef.get() == null)) {
            this._valueRef = new SoftReference<Object>(value);
        }
    }

    public boolean isValueNull() {
        return this.getValueHash() == 0L;
    }

    public final Object getValue() {
        SoftReference<Object> valueRef = this._valueRef;
        if (valueRef != null) {
            ++this._hits;
            return valueRef.get();
        }
        return null;
    }

    public Blob getBlob() {
        return this._blob;
    }

    public void setBlob(Blob blob) {
        this._blob = blob;
    }

    public MnodeUpdate getRemoteUpdate() {
        return new MnodeUpdate(this.getValueHash(), this.getValueLength(), this.getVersion(), this, this.getLeaseOwner());
    }

    public boolean isServerVersionValid() {
        return this._isServerVersionValid;
    }

    public boolean isImplicitNull() {
        return this._isImplicitNull;
    }

    public boolean isUnloadedValue() {
        return this == NULL;
    }

    public int compareTo(MnodeEntry mnode) {
        if (this.getVersion() < mnode.getVersion()) {
            return -1;
        }
        if (mnode.getVersion() < this.getVersion()) {
            return 1;
        }
        if (this.getValueHash() == 0L) {
            return -1;
        }
        return (int)(this.getValueHash() - mnode.getValueHash());
    }

    public boolean isValid() {
        return !this.isExpired(CurrentTime.getCurrentTime());
    }

    public int getHits() {
        return this._hits;
    }

    private static long createAnyKey() {
        return -1L;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[value=" + Long.toHexString(this.getValueHash()) + ",flags=0x" + Long.toHexString(this.getFlags()) + ",version=" + this.getVersion() + ",lease=" + this._leaseOwner + "]";
    }
}

