/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.db.jdbc.DataSourceImpl;
import com.caucho.server.distcache.CacheData;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.CurrentTime;
import com.caucho.util.FreeList;
import com.caucho.util.HashKey;
import com.caucho.util.Hex;
import com.caucho.util.JdbcUtil;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class MnodeStore {
    private static final L10N L = new L10N(MnodeStore.class);
    private static final Logger log = Logger.getLogger(MnodeStore.class.getName());
    private FreeList<CacheMapConnection> _freeConn = new FreeList(32);
    private final String _serverName;
    private final String _tableName;
    private DataSource _dataSource;
    private boolean _isLocalDataSource;
    private String _loadQuery;
    private String _insertQuery;
    private String _updateSaveQuery;
    private String _updateAccessTimeQuery;
    private String _selectExpireQuery;
    private String _deleteExpireQuery;
    private String _selectCacheKeysQuery;
    private String _countQuery;
    private String _updatesSinceQuery;
    private String _remoteUpdatesSinceQuery;
    private String _deleteQuery;
    private long _serverVersion;
    private long _startupLastAccessTime;
    private final AtomicLong _entryCount = new AtomicLong();

    public MnodeStore(DataSource dataSource, String tableName, String serverName) throws Exception {
        this._dataSource = dataSource;
        this._isLocalDataSource = dataSource instanceof DataSourceImpl;
        this._serverName = serverName;
        this._tableName = tableName;
        if (dataSource == null) {
            throw new NullPointerException();
        }
        if (this._tableName == null) {
            throw new NullPointerException();
        }
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public String getTableName() {
        return this._tableName;
    }

    public long getStartupLastUpdateTime() {
        return this._startupLastAccessTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getStartupLastUpdateTime(HashKey cacheKey) {
        long l;
        ResultSet rs;
        Connection conn;
        block8: {
            long l2;
            block7: {
                conn = null;
                rs = null;
                try {
                    conn = this._dataSource.getConnection();
                    String sql = "SELECT MAX(update_time) FROM " + this._tableName + " WHERE cache_id=?";
                    PreparedStatement pStmt = conn.prepareStatement(sql);
                    pStmt.setBytes(1, cacheKey.getHash());
                    rs = pStmt.executeQuery(sql);
                    if (rs.next()) {
                        l2 = rs.getLong(1);
                        JdbcUtil.close(rs);
                        break block7;
                    }
                    l = 0L;
                    JdbcUtil.close(rs);
                    break block8;
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, e.toString(), e);
                    long l3 = 0L;
                    return l3;
                }
            }
            JdbcUtil.close(conn);
            return l2;
        }
        JdbcUtil.close(conn);
        return l;
        finally {
            JdbcUtil.close(rs);
            JdbcUtil.close(conn);
        }
    }

    protected void init() throws Exception {
        this._loadQuery = "SELECT value_hash,value_data_id,value_data_time,value_length,     cache_id,flags,     item_version,server_version,     access_timeout,modified_timeout,     access_time,modified_time FROM " + this._tableName + " WHERE id=?";
        this._insertQuery = "INSERT into " + this._tableName + " (id,value_hash,value_data_id,value_data_time,value_length,cache_id,flags,  item_version,server_version,  access_timeout,modified_timeout,  access_time,modified_time) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        this._updateSaveQuery = "UPDATE " + this._tableName + " SET value_hash=?,value_data_id=?,value_data_time=?,value_length=?,cache_id=?,flags=?,     item_version=?,server_version=?,     access_timeout=?,modified_timeout=?,     access_time=?,modified_time=? WHERE id=? AND item_version<=?";
        this._updateAccessTimeQuery = "UPDATE " + this._tableName + " SET access_timeout=?,access_time=? WHERE id=? AND item_version=?";
        this._selectExpireQuery = "SELECT resin_oid,id,cache_id,value_data_id,value_data_time,     access_time,access_timeout,     modified_time,modified_timeout FROM " + this._tableName + " WHERE (access_time + 1.25 * access_timeout < ?        OR modified_time + 1.25 * modified_timeout < ?)";
        this._deleteExpireQuery = "DELETE FROM " + this._tableName + " WHERE (access_time + 5 * access_timeout < ?        OR modified_time + 5 * modified_timeout < ?)";
        this._selectCacheKeysQuery = "SELECT resin_oid,id FROM " + this._tableName + " WHERE cache_id=? AND ? < resin_oid LIMIT 4096";
        this._deleteQuery = "DELETE FROM " + this._tableName + " WHERE id=?";
        this._countQuery = "SELECT count(*) FROM " + this._tableName;
        this._updatesSinceQuery = "SELECT id,value_hash,value_data_id,value_data_time,value_length,cache_id,flags,item_version,     access_timeout,modified_timeout,     access_time,modified_time FROM " + this._tableName + " WHERE ? <= access_time   AND bitand(flags, " + 4 + ") <> 0 LIMIT 1024";
        this._remoteUpdatesSinceQuery = "SELECT id,value_hash,value_data_id,value_data_time,value_length,     cache_id,flags,item_version,     access_timeout,modified_timeout,      access_time,modified_time FROM " + this._tableName + " WHERE ? = cache_id AND ? <= access_time LIMIT 1024";
        this.initDatabase();
        this._serverVersion = this.initVersion();
        this._startupLastAccessTime = this.initLastAccessTime();
        long initCount = this.getCountImpl();
        if (initCount > 0L) {
            this._entryCount.set(initCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDatabase() throws Exception {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            try {
                String sql = "SELECT id, value_hash, value_data_id, value_data_time, value_length, cache_id, flags,     access_timeout, modified_timeout,     access_time, modified_time     server_version, item_version FROM " + this._tableName + " WHERE 1=0";
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                return;
            }
            catch (Exception e) {
                log.log(Level.ALL, e.toString(), e);
                log.finer(this + " " + e.toString());
                try {
                    stmt.executeQuery("DROP TABLE " + this._tableName);
                }
                catch (Exception e2) {
                    log.log(Level.ALL, e2.toString(), e2);
                    log.finer(this + " " + e2.toString());
                }
                String sql = "CREATE TABLE " + this._tableName + " (\n  id BINARY(32) PRIMARY KEY,\n  cache_id BINARY(32),\n  value_hash BIGINT,\n  value_data_id BIGINT,\n  value_data_time BIGINT,\n  value_length BIGINT,\n  access_timeout BIGINT,\n  modified_timeout BIGINT,\n  access_time BIGINT,\n  modified_time BIGINT,\n  item_version BIGINT,\n  flags BIGINT,\n  server_version INTEGER)";
                log.fine(sql);
                stmt.executeUpdate(sql);
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int initVersion() throws Exception {
        ResultSet rs;
        Connection conn;
        block2: {
            int n;
            conn = this._dataSource.getConnection();
            rs = null;
            try {
                Statement stmt = conn.createStatement();
                String sql = "SELECT MAX(server_version) FROM " + this._tableName;
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block2;
                n = rs.getInt(1) + 1;
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                conn.close();
                throw throwable;
            }
            JdbcUtil.close(rs);
            conn.close();
            return n;
        }
        JdbcUtil.close(rs);
        conn.close();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long initLastAccessTime() throws Exception {
        ResultSet rs;
        Connection conn;
        block2: {
            long l;
            conn = this._dataSource.getConnection();
            rs = null;
            try {
                Statement stmt = conn.createStatement();
                String sql = "SELECT MAX(access_time) FROM " + this._tableName;
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block2;
                l = rs.getLong(1);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                conn.close();
                throw throwable;
            }
            JdbcUtil.close(rs);
            conn.close();
            return l;
        }
        JdbcUtil.close(rs);
        conn.close();
        return 0L;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<CacheData> getUpdates(long updateTime, int offset) {
        ArrayList<CacheData> arrayList;
        ResultSet rs;
        Connection conn;
        block9: {
            block8: {
                conn = null;
                rs = null;
                try {
                    conn = this._dataSource.getConnection();
                    String sql = this._updatesSinceQuery;
                    PreparedStatement pstmt = conn.prepareStatement(sql);
                    pstmt.setLong(1, updateTime);
                    ArrayList<CacheData> entryList = new ArrayList<CacheData>();
                    rs = pstmt.executeQuery();
                    rs.relative(offset);
                    while (rs.next()) {
                        HashKey cacheKey;
                        byte[] keyHash = rs.getBytes(1);
                        long valueHash = rs.getLong(2);
                        long valueDataId = rs.getLong(3);
                        long valueDataTime = rs.getLong(4);
                        long valueLength = rs.getLong(5);
                        byte[] cacheHash = rs.getBytes(6);
                        long flags = rs.getLong(7);
                        long version = rs.getLong(8);
                        long accessTimeout = rs.getLong(9);
                        long modifiedTimeout = rs.getLong(10);
                        long accessTime = rs.getLong(11);
                        long modifiedTime = rs.getLong(12);
                        long leaseTimeout = 30000L;
                        HashKey hashKey = cacheKey = cacheHash != null ? new HashKey(cacheHash) : null;
                        if (keyHash == null) continue;
                        entryList.add(new CacheData(new HashKey(keyHash), cacheKey, valueHash, valueDataId, valueDataTime, valueLength, version, flags, accessTimeout, modifiedTimeout, leaseTimeout, accessTime, modifiedTime));
                    }
                    if (entryList.size() > 0) {
                        arrayList = entryList;
                        JdbcUtil.close(rs);
                        break block8;
                    }
                    arrayList = null;
                    JdbcUtil.close(rs);
                    break block9;
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, e.toString(), e);
                    return null;
                }
            }
            JdbcUtil.close(conn);
            return arrayList;
        }
        JdbcUtil.close(conn);
        return arrayList;
        finally {
            JdbcUtil.close(rs);
            JdbcUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<CacheData> getUpdates(HashKey cacheKey, long updateTime, int offset) {
        ArrayList<CacheData> arrayList;
        ResultSet rs;
        Connection conn;
        block9: {
            block8: {
                conn = null;
                rs = null;
                try {
                    conn = this._dataSource.getConnection();
                    String sql = this._remoteUpdatesSinceQuery;
                    PreparedStatement pstmt = conn.prepareStatement(sql);
                    pstmt.setBytes(1, cacheKey.getHash());
                    pstmt.setLong(2, updateTime);
                    ArrayList<CacheData> entryList = new ArrayList<CacheData>();
                    rs = pstmt.executeQuery();
                    rs.relative(offset);
                    while (rs.next()) {
                        byte[] keyHash = rs.getBytes(1);
                        long valueHash = rs.getLong(2);
                        long valueIndex = rs.getLong(3);
                        long valueDataTime = rs.getLong(4);
                        long valueLength = rs.getLong(5);
                        byte[] cacheHash = rs.getBytes(6);
                        long flags = rs.getLong(7);
                        long version = rs.getLong(8);
                        long accessTimeout = rs.getLong(9);
                        long modifiedTimeout = rs.getLong(10);
                        long accessTime = rs.getLong(11);
                        long modifiedTime = rs.getLong(12);
                        long leaseTimeout = 30000L;
                        if (keyHash == null) continue;
                        entryList.add(new CacheData(new HashKey(keyHash), HashKey.create(cacheHash), valueHash, valueIndex, valueDataTime, valueLength, version, flags, accessTimeout, modifiedTimeout, leaseTimeout, accessTime, modifiedTime));
                    }
                    if (entryList.size() > 0) {
                        arrayList = entryList;
                        JdbcUtil.close(rs);
                        break block8;
                    }
                    arrayList = null;
                    JdbcUtil.close(rs);
                    break block9;
                }
                catch (SQLException e) {
                    log.log(Level.WARNING, e.toString(), e);
                    return null;
                }
            }
            JdbcUtil.close(conn);
            return arrayList;
        }
        JdbcUtil.close(conn);
        return arrayList;
        finally {
            JdbcUtil.close(rs);
            JdbcUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MnodeEntry load(HashKey id) {
        block12: {
            MnodeEntry mnodeEntry;
            CacheMapConnection conn = null;
            ResultSet rs = null;
            try {
                conn = this.getConnection();
                PreparedStatement pstmt = conn.prepareLoad();
                pstmt.setBytes(1, id.getHash());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    long valueHash = rs.getLong(1);
                    long valueDataId = rs.getLong(2);
                    long valueDataTime = rs.getLong(3);
                    long valueLength = rs.getLong(4);
                    byte[] cacheHash = rs.getBytes(5);
                    long flags = rs.getLong(6);
                    long itemVersion = rs.getLong(7);
                    long serverVersion = rs.getLong(8);
                    long accessedExpireTimeout = rs.getLong(9);
                    long modifiedExpireTimeout = rs.getLong(10);
                    long accessTime = rs.getLong(11);
                    long modifiedTime = rs.getLong(12);
                    long leaseTimeout = 300000L;
                    MnodeEntry entry = new MnodeEntry(valueHash, valueLength, itemVersion, flags, accessedExpireTimeout, modifiedExpireTimeout, leaseTimeout, valueDataId, valueDataTime, null, accessTime, modifiedTime, serverVersion == this._serverVersion, false);
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(this + " load " + id + " " + entry);
                    }
                    MnodeEntry mnodeEntry2 = entry;
                    JdbcUtil.close(rs);
                    if (conn != null) {
                        conn.close();
                    }
                    return mnodeEntry2;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this + " load: no mnode for cache key " + id);
                }
                mnodeEntry = null;
                JdbcUtil.close(rs);
            }
            catch (SQLException e) {
                log.log(Level.FINE, e.toString(), e);
                break block12;
            }
            finally {
                JdbcUtil.close(rs);
                if (conn != null) {
                    conn.close();
                }
            }
            if (conn != null) {
                conn.close();
            }
            return mnodeEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean selectCacheKeys(KeysIterator iter, HashKey cacheKey, long oid) {
        block6: {
            boolean bl;
            Connection conn = null;
            ResultSet rs = null;
            try {
                conn = this._dataSource.getConnection();
                String sql = this._selectCacheKeysQuery;
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setBytes(1, cacheKey.getHash());
                pstmt.setLong(2, oid);
                rs = pstmt.executeQuery();
                boolean isValue = false;
                while (rs.next()) {
                    long newOid = rs.getLong(1);
                    byte[] keyHash = rs.getBytes(2);
                    iter.addKey(newOid, keyHash);
                    isValue = true;
                }
                bl = isValue;
                JdbcUtil.close(rs);
            }
            catch (SQLException e) {
                log.log(Level.WARNING, e.toString(), e);
                break block6;
            }
            finally {
                JdbcUtil.close(rs);
                JdbcUtil.close(conn);
            }
            JdbcUtil.close(conn);
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(HashKey id, HashKey cacheKey, MnodeValue mnodeUpdate, long valueDataId, long valueDataTime, long lastAccessTime, long lastModifiedTime) {
        if (valueDataId == 0L != (mnodeUpdate.getValueHash() == 0L)) {
            throw new IllegalStateException(L.l("data {0} vs hash {1} mismatch for cache mnode {2}", (Object)valueDataId, (Object)mnodeUpdate.getValueHash(), (Object)id));
        }
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareInsert();
            stmt.setBytes(1, id.getHash());
            stmt.setLong(2, mnodeUpdate.getValueHash());
            stmt.setLong(3, valueDataId);
            stmt.setLong(4, valueDataTime);
            stmt.setLong(5, mnodeUpdate.getValueLength());
            stmt.setBytes(6, cacheKey.getHash());
            stmt.setLong(7, mnodeUpdate.getFlags());
            stmt.setLong(8, mnodeUpdate.getVersion());
            stmt.setLong(9, this._serverVersion);
            stmt.setLong(10, mnodeUpdate.getAccessedExpireTimeout());
            stmt.setLong(11, mnodeUpdate.getModifiedExpireTimeout());
            long now = CurrentTime.getCurrentTime();
            stmt.setLong(12, lastAccessTime);
            stmt.setLong(13, lastModifiedTime);
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " insert key=" + id + " " + mnodeUpdate + " count=" + count);
            }
            if (count > 0) {
                this._entryCount.addAndGet(1L);
            } else {
                System.out.println("INS_FAILED: " + stmt);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSave(byte[] key, byte[] cacheHash, MnodeValue mnodeUpdate, long valueDataId, long valueDataTime, long lastAccessTime, long lastModifiedTime) {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareUpdateSave();
            stmt.setLong(1, mnodeUpdate.getValueHash());
            stmt.setLong(2, valueDataId);
            stmt.setLong(3, valueDataTime);
            stmt.setLong(4, mnodeUpdate.getValueLength());
            stmt.setBytes(5, cacheHash);
            stmt.setLong(6, mnodeUpdate.getFlags());
            stmt.setLong(7, mnodeUpdate.getVersion());
            stmt.setLong(8, this._serverVersion);
            stmt.setLong(9, mnodeUpdate.getAccessedExpireTimeout());
            stmt.setLong(10, mnodeUpdate.getModifiedExpireTimeout());
            stmt.setLong(11, lastAccessTime);
            stmt.setLong(12, lastModifiedTime);
            stmt.setBytes(13, key);
            stmt.setLong(14, mnodeUpdate.getVersion());
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                if (count > 0) {
                    log.finer(this + " updateSave " + HashKey.create(key) + " " + mnodeUpdate);
                } else {
                    log.finer(this + " updateSave-failed " + HashKey.create(key) + " " + mnodeUpdate);
                }
            }
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAccessTime(HashKey id, long itemVersion, long accessTimeout, long accessTime) {
        CacheMapConnection conn = null;
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.preparedUpdateAccessTime();
            stmt.setLong(1, accessTimeout);
            stmt.setLong(2, accessTime);
            stmt.setBytes(3, id.getHash());
            stmt.setLong(4, itemVersion);
            int count = stmt.executeUpdate();
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " updateUpdateTime key=" + id);
            }
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(byte[] key) {
        CacheMapConnection conn = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareDelete();
            pstmt.setBytes(1, key);
            int count = pstmt.executeUpdate();
            if (count > 0) {
                this._entryCount.addAndGet(-1L);
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " remove " + HashKey.create(key));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            JdbcUtil.close(rs);
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    public Iterator<HashKey> getKeys(HashKey cacheKey) {
        return new KeysIterator(cacheKey);
    }

    public ExpiredState createExpiredState() {
        return new ExpiredState();
    }

    public long getCount() {
        return this._entryCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getCountImpl() {
        long l;
        ResultSet rs;
        CacheMapConnection conn;
        block5: {
            conn = null;
            rs = null;
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareCount();
            rs = stmt.executeQuery();
            if (rs == null || !rs.next()) break block5;
            long value = rs.getLong(1);
            rs.close();
            long l2 = value;
            JdbcUtil.close(rs);
            conn.close();
            return l2;
        }
        try {
            l = -1L;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, e.toString(), e);
            }
            catch (Throwable throwable) {
                JdbcUtil.close(rs);
                conn.close();
                throw throwable;
            }
            JdbcUtil.close(rs);
            conn.close();
            return -1L;
        }
        JdbcUtil.close(rs);
        conn.close();
        return l;
    }

    public void destroy() {
        this._dataSource = null;
        this._freeConn = null;
    }

    private CacheMapConnection getConnection() throws SQLException {
        CacheMapConnection cConn = this._freeConn.allocate();
        if (cConn == null) {
            Connection conn = this._dataSource.getConnection();
            cConn = new CacheMapConnection(conn);
        }
        return cConn;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverName + "]";
    }

    class KeysIterator
    implements Iterator<HashKey> {
        private HashKey _cacheKey;
        private long _startOid;
        private ArrayList<HashKey> _keys = new ArrayList();
        private boolean _isClosed;

        KeysIterator(HashKey cacheKey) {
            this._cacheKey = cacheKey;
        }

        @Override
        public boolean hasNext() {
            if (this._keys.size() == 0) {
                this.loadKeys();
            }
            return this._keys.size() > 0;
        }

        @Override
        public HashKey next() {
            if (this._keys.size() == 0) {
                this.loadKeys();
            }
            if (this._keys.size() == 0) {
                return null;
            }
            return this._keys.remove(0);
        }

        void addKey(long newOid, byte[] keyHash) {
            this._startOid = Math.max(this._startOid, newOid);
            this._keys.add(HashKey.create(keyHash));
        }

        private void loadKeys() {
            if (!this._isClosed && !MnodeStore.this.selectCacheKeys(this, this._cacheKey, this._startOid)) {
                this._isClosed = true;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    public static final class ExpiredMnode
    extends Mnode {
        private final byte[] _key;
        private final byte[] _cacheHash;
        private final long _dataId;
        private final long _dataTime;

        ExpiredMnode(long oid, byte[] key, byte[] cacheHash, long dataId, long dataTime) {
            super(oid);
            this._key = key;
            this._cacheHash = cacheHash;
            this._dataId = dataId;
            this._dataTime = dataTime;
        }

        public final byte[] getKey() {
            return this._key;
        }

        public final byte[] getCacheHash() {
            return this._cacheHash;
        }

        public final long getDataId() {
            return this._dataId;
        }

        public final long getDataTime() {
            return this._dataTime;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Hex.toHex(this._key, 0, 4) + "," + Long.toHexString(this._dataId) + "]";
        }
    }

    public static class Mnode {
        private final long _oid;

        Mnode(long oid) {
            this._oid = oid;
        }

        public final long getOid() {
            return this._oid;
        }
    }

    private class CacheMapConnection {
        private Connection _conn;
        private PreparedStatement _loadStatement;
        private PreparedStatement _insertStatement;
        private PreparedStatement _updateSaveStatement;
        private PreparedStatement _updateAccessTimeStatement;
        private PreparedStatement _selectExpireStatement;
        private PreparedStatement _deleteExpireStatement;
        private PreparedStatement _deleteStatement;
        private PreparedStatement _countStatement;

        CacheMapConnection(Connection conn) {
            this._conn = conn;
        }

        PreparedStatement prepareLoad() throws SQLException {
            if (this._loadStatement == null) {
                this._loadStatement = this._conn.prepareStatement(MnodeStore.this._loadQuery);
            }
            return this._loadStatement;
        }

        PreparedStatement prepareInsert() throws SQLException {
            if (this._insertStatement == null) {
                this._insertStatement = this._conn.prepareStatement(MnodeStore.this._insertQuery);
            }
            return this._insertStatement;
        }

        PreparedStatement prepareUpdateSave() throws SQLException {
            if (this._updateSaveStatement == null) {
                this._updateSaveStatement = this._conn.prepareStatement(MnodeStore.this._updateSaveQuery);
            }
            return this._updateSaveStatement;
        }

        PreparedStatement preparedUpdateAccessTime() throws SQLException {
            if (this._updateAccessTimeStatement == null) {
                this._updateAccessTimeStatement = this._conn.prepareStatement(MnodeStore.this._updateAccessTimeQuery);
            }
            return this._updateAccessTimeStatement;
        }

        PreparedStatement prepareSelectExpire() throws SQLException {
            if (this._selectExpireStatement == null) {
                this._selectExpireStatement = this._conn.prepareStatement(MnodeStore.this._selectExpireQuery);
            }
            return this._selectExpireStatement;
        }

        PreparedStatement prepareDeleteExpire() throws SQLException {
            if (this._deleteExpireStatement == null) {
                this._deleteExpireStatement = this._conn.prepareStatement(MnodeStore.this._deleteExpireQuery);
            }
            return this._deleteExpireStatement;
        }

        PreparedStatement prepareDelete() throws SQLException {
            if (this._deleteStatement == null) {
                this._deleteStatement = this._conn.prepareStatement(MnodeStore.this._deleteQuery);
            }
            return this._deleteStatement;
        }

        PreparedStatement prepareCount() throws SQLException {
            if (this._countStatement == null) {
                this._countStatement = this._conn.prepareStatement(MnodeStore.this._countQuery);
            }
            return this._countStatement;
        }

        void close() {
            if (!MnodeStore.this._isLocalDataSource || MnodeStore.this._freeConn == null || !MnodeStore.this._freeConn.freeCareful(this)) {
                try {
                    this._conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public class ExpiredState {
        private long _lastOid;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<Mnode> selectExpiredData() {
            ArrayList<Mnode> expireList = new ArrayList<Mnode>();
            CacheMapConnection conn = null;
            try {
                conn = MnodeStore.this.getConnection();
                PreparedStatement pstmt = conn.prepareSelectExpire();
                long now = CurrentTime.getCurrentTime();
                pstmt.setLong(1, now);
                pstmt.setLong(2, now);
                ResultSet rs = pstmt.executeQuery();
                boolean isValue = false;
                while (rs.next()) {
                    isValue = true;
                    long oid = rs.getLong(1);
                    byte[] key = rs.getBytes(2);
                    byte[] cacheHash = rs.getBytes(3);
                    long dataId = rs.getLong(4);
                    long dataTime = rs.getLong(5);
                    long accessTime = rs.getLong(6);
                    long accessTimeout = rs.getLong(7);
                    long modifiedTime = rs.getLong(8);
                    long modifiedTimeout = rs.getLong(9);
                    this._lastOid = Math.max(this._lastOid, oid);
                    if (!((double)accessTime + 1.25 * (double)accessTimeout < (double)now) && modifiedTime + modifiedTimeout >= now) continue;
                    expireList.add(new ExpiredMnode(oid, key, cacheHash, dataId, dataTime));
                }
                if (!isValue) {
                    this._lastOid = 0L;
                }
            }
            catch (Exception e) {
                this._lastOid = 0L;
                e.printStackTrace();
                log.log(Level.FINE, e.toString(), e);
            }
            finally {
                conn.close();
            }
            return expireList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int removeExpiredData() {
            CacheMapConnection conn = null;
            try {
                int count;
                conn = MnodeStore.this.getConnection();
                PreparedStatement pstmt = conn.prepareDeleteExpire();
                long now = CurrentTime.getCurrentTime();
                pstmt.setLong(1, now);
                pstmt.setLong(2, now);
                int n = count = pstmt.executeUpdate();
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.log(Level.FINE, e.toString(), e);
                int n = 0;
                return n;
            }
            finally {
                conn.close();
            }
        }
    }
}

