/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.env.service.ResinSystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.env.thread.ThreadPool;
import com.caucho.env.warning.WarningService;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.ResinActor;
import com.caucho.server.resin.ResinLink;
import com.caucho.server.resin.ResinWarningHandler;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResinWaitForExitService {
    private static final Logger log = Logger.getLogger(ResinWaitForExitService.class.getSimpleName());
    private static final L10N L = new L10N(ResinWaitForExitService.class);
    private Resin _resin;
    private ResinSystem _resinSystem;
    private InputStream _waitIn;
    private Socket _pingSocket;
    private ResinActor _resinActor;

    ResinWaitForExitService(Resin resin, ResinSystem resinSystem, InputStream waitIn, Socket pingSocket) {
        this._resin = resin;
        this._resinSystem = resinSystem;
        this._waitIn = waitIn;
        this._pingSocket = pingSocket;
    }

    ResinActor getResinActor() {
        return this._resinActor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForExit() {
        int socketExceptionCount = 0;
        Runtime runtime = Runtime.getRuntime();
        ShutdownSystem shutdown = this._resinSystem.getService(ShutdownSystem.class);
        if (shutdown == null) {
            throw new IllegalStateException(L.l("'{0}' requires an active {1}", (Object)this, (Object)ShutdownSystem.class.getSimpleName()));
        }
        while (!this._resin.isClosing()) {
            try {
                Thread.sleep(10L);
                if (!this.checkMemory(runtime)) {
                    shutdown.shutdown(ExitCode.MEMORY, "Resin shutdown from out of memory");
                    return;
                }
                if (!this.checkFileDescriptor()) {
                    shutdown.shutdown(ExitCode.MEMORY, "Resin shutdown from out of file descriptors");
                    return;
                }
                if (this._waitIn != null) {
                    if (this._waitIn.read() >= 0) {
                        socketExceptionCount = 0;
                        continue;
                    }
                    shutdown.shutdown(ExitCode.WATCHDOG_EXIT, "Stopping due to watchdog or user.");
                    return;
                }
                ResinWaitForExitService resinWaitForExitService = this;
                synchronized (resinWaitForExitService) {
                    this.wait(10000L);
                }
            }
            catch (SocketTimeoutException e) {
                socketExceptionCount = 0;
            }
            catch (InterruptedIOException e) {
                socketExceptionCount = 0;
            }
            catch (InterruptedException e) {
                socketExceptionCount = 0;
            }
            catch (SocketException e) {
                if (socketExceptionCount++ == 0) {
                    log.log(Level.FINE, e.toString(), e);
                    continue;
                }
                if (socketExceptionCount <= 100) continue;
                return;
            }
            catch (OutOfMemoryError e) {
                String msg = "Resin shutdown from out of memory";
                ShutdownSystem.shutdownOutOfMemory(msg);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                return;
            }
        }
    }

    private boolean checkMemory(Runtime runtime) throws InterruptedException {
        long minFreeMemory = 0L;
        if (minFreeMemory <= 0L) {
            return true;
        }
        if (2L * minFreeMemory < ResinWaitForExitService.getFreeMemory(runtime)) {
            return true;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(L.l("free memory {0} max:{1} total:{2} free:{3}", (Object)("" + ResinWaitForExitService.getFreeMemory(runtime)), (Object)("" + runtime.maxMemory()), (Object)("" + runtime.totalMemory()), (Object)("" + runtime.freeMemory())));
        }
        log.info(L.l("Forcing GC due to low memory. {0} free bytes.", ResinWaitForExitService.getFreeMemory(runtime)));
        runtime.gc();
        Thread.sleep(1000L);
        runtime.gc();
        if (ResinWaitForExitService.getFreeMemory(runtime) < minFreeMemory) {
            log.severe(L.l("Restarting due to low free memory. {0} free bytes", ResinWaitForExitService.getFreeMemory(runtime)));
            return false;
        }
        this.allocateMemory();
        return true;
    }

    private Object allocateMemory() {
        return new Object();
    }

    private boolean checkFileDescriptor() {
        try {
            ReadStream is = this._resin.getResinConf().openRead();
            is.close();
            return true;
        }
        catch (IOException e) {
            log.severe(L.l("Restarting due to file descriptor failure:\n{0}", (Object)e));
            return false;
        }
    }

    private static long getFreeMemory(Runtime runtime) {
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        if (maxMemory < totalMemory) {
            return freeMemory;
        }
        return maxMemory - totalMemory + freeMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startResinActor() throws IOException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._resinSystem.getClassLoader());
            WarningService warning = WarningService.getCurrent();
            if (this._pingSocket != null) {
                this._resinActor = new ResinActor(this._resin);
                warning.addHandler(new ResinWarningHandler(this._resinActor));
                InputStream is = this._pingSocket.getInputStream();
                OutputStream os = this._pingSocket.getOutputStream();
                ResinLink link = new ResinLink(this._resinActor, is, os);
                ThreadPool.getThreadPool().schedule(link);
            }
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this._resinSystem.getId() + "]";
    }
}

