/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.distcache.ByteStreamCache;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.json.Json;
import com.caucho.json.Transient;
import com.caucho.security.Login;
import com.caucho.server.session.HashChunkInputStream;
import com.caucho.server.session.HashChunkOutputStream;
import com.caucho.server.session.SessionDeserializer;
import com.caucho.server.session.SessionManager;
import com.caucho.server.session.SessionSerializer;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CacheListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionImpl
implements HttpSession,
CacheListener {
    private static final Logger log = Logger.getLogger(SessionImpl.class.getName());
    private static final L10N L = new L10N(SessionImpl.class);
    @Json(name="SessionId")
    private String _id;
    @Transient
    protected SessionManager _manager;
    @Transient
    protected Map<String, Object> _values;
    @Json(name="CreationTime")
    private long _creationTime;
    @Json(name="AccessTime")
    private long _accessTime;
    @Json(name="LastUseTime")
    private long _lastUseTime;
    @Json(name="IdleTimeout")
    private long _idleTimeout;
    @Json(name="IdleIsSet")
    private boolean _isIdleSet;
    @Json(name="New")
    private boolean _isNew = true;
    @Transient
    private boolean _isModified;
    @Json(name="Valid")
    private State _state = State.active;
    @Transient
    private ExtCacheEntry _cacheEntry;
    @Json(name="UseCount")
    private final AtomicInteger _useCount = new AtomicInteger();
    @Json(name="LastSaveLength")
    private int _lastSaveLength;

    public SessionImpl(SessionManager manager, String id, long creationTime) {
        this._manager = manager;
        this._creationTime = creationTime = CurrentTime.getExactTime();
        this.setAccessTime(creationTime);
        this._lastUseTime = this._accessTime;
        this._idleTimeout = manager.getSessionTimeout();
        this._id = id;
        this._values = this.createValueMap();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " new");
        }
    }

    protected Map<String, Object> createValueMap() {
        return new TreeMap<String, Object>();
    }

    private boolean isClosed() {
        return this._state.isClosed();
    }

    public long getCreationTime() {
        if (this.isClosed()) {
            throw new IllegalStateException(L.l("{0}: can't call getCreationTime() when session is no longer valid.", (Object)this));
        }
        return this._creationTime;
    }

    public String getId() {
        return this._id;
    }

    public long getLastAccessedTime() {
        if (this.isClosed()) {
            throw new IllegalStateException(L.l("{0}: can't call getLastAccessedTime() when session is no longer valid.", (Object)this));
        }
        return this._accessTime;
    }

    public int getMaxInactiveInterval() {
        if (0x3FFFFFFFFFFFFFFFL <= this._idleTimeout) {
            return -1;
        }
        return (int)(this._idleTimeout / 1000L);
    }

    public void setMaxInactiveInterval(int value) {
        this._idleTimeout = value < 0 ? 0x3FFFFFFFFFFFFFFFL : (long)value * 1000L;
        this._isIdleSet = true;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public ServletContext getServletContext() {
        return this._manager.getWebApp();
    }

    public SessionManager getManager() {
        return this._manager;
    }

    public boolean isNew() {
        if (this.isClosed()) {
            throw new IllegalStateException(L.l("{0} can't call isNew() when session is no longer valid.", (Object)this));
        }
        return this._isNew;
    }

    public boolean isValid() {
        return this._state.isValid();
    }

    public boolean isTimeout() {
        return this.isTimeout(CurrentTime.getCurrentTime());
    }

    boolean isTimeout(long now) {
        long maxIdleTime = this._idleTimeout;
        if (this.isInUse()) {
            return false;
        }
        if (now < this._lastUseTime + maxIdleTime) {
            return false;
        }
        long lastUseTime = this.getLastUseTime();
        return lastUseTime + maxIdleTime < now;
    }

    private long getLastUseTime() {
        ByteStreamCache cache = this._manager.getCache();
        if (cache == null) {
            return this._lastUseTime;
        }
        ExtCacheEntry<?, ?> entry = cache.peekExtCacheEntry(this._id);
        if (entry == null) {
            return this._lastUseTime;
        }
        return entry.getLastAccessedTime();
    }

    boolean isClosing() {
        return this._state.isClosing();
    }

    public boolean isEmpty() {
        return this._values == null || this._values.size() == 0;
    }

    public boolean isInUse() {
        return this._useCount.get() > 0;
    }

    protected int getUseCount() {
        return this._useCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (this.isClosed()) {
            throw new IllegalStateException(L.l("{0}: can't call getAttribute() when session is no longer valid.", (Object)this));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            Object value = this._values.get(name);
            return value;
        }
    }

    void setModified() {
        if (this._values.size() > 0) {
            this._isModified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        ArrayList<HttpSessionAttributeListener> listeners;
        HttpSessionBindingListener listener;
        Object oldValue;
        if (this.isClosed()) {
            throw new IllegalStateException(L.l("{0}: can't call setAttribute(String, Object) when session is no longer valid.", (Object)this));
        }
        if (value != null && !(value instanceof Serializable) && log.isLoggable(Level.FINE)) {
            log.fine(L.l("{0} attribute '{1}' value is non-serializable type '{2}'", (Object)this, (Object)name, (Object)value.getClass().getName()));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            oldValue = value != null ? this._values.put(name, value) : this._values.remove(name);
        }
        this._isModified = true;
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
        }
        if (value instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)value;
            listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
        if ((listeners = this._manager.getAttributeListeners()) != null && listeners.size() > 0) {
            HttpSessionBindingEvent event = oldValue != null ? new HttpSessionBindingEvent((HttpSession)this, name, oldValue) : new HttpSessionBindingEvent((HttpSession)this, name, value);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener2 = listeners.get(i);
                if (oldValue != null) {
                    listener2.attributeReplaced(event);
                    continue;
                }
                listener2.attributeAdded(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object oldValue;
        if (this.isClosed()) {
            throw new IllegalStateException(L.l("{0}: can't call removeAttribute(String) when session is no longer valid.", (Object)this));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            oldValue = this._values.remove(name);
        }
        if (oldValue != null) {
            this._isModified = true;
        }
        this.notifyValueUnbound(name, oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (this.isClosed()) {
                throw new IllegalStateException(L.l("{0} can't call getAttributeNames() when session is no longer valid.", (Object)this));
            }
            return Collections.enumeration(this._values.keySet());
        }
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (this.isClosed()) {
                throw new IllegalStateException(L.l("{0} can't call getValueNames() when session is no longer valid.", (Object)this));
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] s = new String[this._values.size()];
            Enumeration e = this.getAttributeNames();
            int count = 0;
            while (e.hasMoreElements()) {
                s[count++] = (String)e.nextElement();
            }
            return s;
        }
    }

    void create(long now, boolean isCreate) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " create session");
        }
        if (!this.isClosed()) {
            this.unbind();
        }
        now = CurrentTime.getExactTime();
        this._isNew = true;
        this.setAccessTime(now);
        this._creationTime = now;
        this._isModified = true;
    }

    boolean addUse() {
        this._lastUseTime = CurrentTime.getCurrentTime();
        this._useCount.incrementAndGet();
        return true;
    }

    void endUse() {
        this._useCount.decrementAndGet();
    }

    void setAccess(long now) {
        if (this._useCount.get() > 1) {
            return;
        }
        this._isNew = false;
    }

    public void setAccessTime(long accessTime) {
        this._accessTime = accessTime;
    }

    public int getLastSaveLength() {
        return this._lastSaveLength;
    }

    public void finishRequest() {
        this.setAccessTime(CurrentTime.getExactTime());
        this._isNew = false;
        if (this._useCount.decrementAndGet() > 0) {
            return;
        }
        this.saveAfterRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(boolean isNew) {
        long now = CurrentTime.getCurrentTime();
        if (!this._state.isValid()) {
            return false;
        }
        if (this._isIdleSet && this._accessTime + this._idleTimeout < now) {
            return false;
        }
        if (this._useCount.get() > 1) {
            return true;
        }
        try {
            ByteStreamCache cache = this._manager.getCache();
            if (cache == null) {
                return !isNew;
            }
            if (!isNew && this._manager.isSaveOnShutdown()) {
                return true;
            }
            ExtCacheEntry<?, ?> entry = cache.getExtCacheEntry(this._id);
            ExtCacheEntry cacheEntry = this._cacheEntry;
            if (entry != null && !entry.isValueNull()) {
                this._idleTimeout = entry.getAccessedExpireTimeout();
                long lastAccessTime = entry.getLastAccessedTime();
                if (lastAccessTime + this._idleTimeout * 5L / 4L < now) {
                    return false;
                }
            }
            if (entry != null && cacheEntry != null && (entry.getValueHash() == cacheEntry.getValueHash() || entry.getVersion() <= cacheEntry.getVersion())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " session load-same valueHash=" + (entry != null ? Long.toHexString(entry.getValueHash()) : null));
                }
                entry.updateAccessTime();
                this._isModified = false;
                return true;
            }
            TempOutputStream os = new TempOutputStream();
            if (cache.get(this._id, os)) {
                InputStream is = os.getInputStream();
                boolean isValid = false;
                try {
                    HashChunkInputStream crcIs = new HashChunkInputStream(is);
                    SessionDeserializer in = this._manager.createSessionDeserializer(crcIs);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " session load valueHash=" + (entry != null ? Long.toHexString(entry.getValueHash()) : null));
                    }
                    isValid = this.load(in);
                    in.close();
                    crcIs.close();
                }
                finally {
                    is.close();
                }
                if (isValid) {
                    this._cacheEntry = entry;
                    this._isModified = false;
                    return true;
                }
                this._cacheEntry = entry;
                this._isModified = true;
                return false;
            }
            this._cacheEntry = null;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " session remove");
            }
            if (cacheEntry == null) {
                return true;
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(SessionDeserializer in) throws IOException {
        HttpSessionActivationListener listener;
        int i;
        HttpSessionEvent event = null;
        ArrayList<Object> listeners = null;
        String id = null;
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            Map<String, Object> map = this._values;
            synchronized (map) {
                this._values.clear();
                try {
                    id = (String)in.readObject();
                    int size = in.readInt();
                    for (int i2 = 0; i2 < size; ++i2) {
                        String key = (String)in.readObject();
                        Object value = in.readObject();
                        if (value == null) continue;
                        this._values.put(key, value);
                        if (!(value instanceof HttpSessionActivationListener)) continue;
                        HttpSessionActivationListener listener2 = (HttpSessionActivationListener)value;
                        if (event == null) {
                            event = new HttpSessionEvent((HttpSession)this);
                        }
                        if (listeners == null) {
                            listeners = new ArrayList();
                        }
                        listeners.add(listener2);
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    id = null;
                }
            }
        }
        for (i = 0; listeners != null && i < listeners.size(); ++i) {
            listener = listeners.get(i);
            if (event == null) {
                event = new HttpSessionEvent((HttpSession)this);
            }
            listener.sessionDidActivate(event);
        }
        listeners = this._manager.getActivationListeners();
        for (i = 0; listeners != null && i < listeners.size(); ++i) {
            listener = listeners.get(i);
            if (event == null) {
                event = new HttpSessionEvent((HttpSession)this);
            }
            listener.sessionDidActivate(event);
        }
        if (this.getId().equals(id)) {
            return true;
        }
        log.warning("Invalid session load id=" + this.getId() + ", but loaded id=" + id);
        Map<String, Object> map = this._values;
        synchronized (map) {
            this._values.clear();
        }
        return false;
    }

    void reset(long now) {
        if (log.isLoggable(Level.FINER)) {
            log.fine(this + " reset");
        }
        now = CurrentTime.getCurrentTime();
        this.unbind();
        this._isNew = true;
        this.setAccessTime(now);
        this._creationTime = now;
    }

    public final void saveBeforeFlush() {
        if (this._manager == null || !this._manager.isSaveBeforeFlush()) {
            return;
        }
        this.save();
    }

    public final void saveBeforeHeaders() {
        if (this._manager == null || !this._manager.isSaveBeforeHeaders()) {
            return;
        }
        this.save();
    }

    public final void saveAfterRequest() {
        if (this._manager == null || !this._manager.isSaveAfterRequest()) {
            return;
        }
        this.save();
    }

    public final void save() {
        if (!this.isValid()) {
            return;
        }
        try {
            long lastAccessTime;
            if (!this._isModified && !this._manager.getAlwaysSaveSession()) {
                return;
            }
            if (!this._manager.isPersistenceEnabled()) {
                return;
            }
            this._isModified = false;
            TempOutputStream os = new TempOutputStream();
            HashChunkOutputStream crcOs = new HashChunkOutputStream(os);
            SessionSerializer out = this._manager.createSessionSerializer(crcOs);
            this.store(out);
            out.close();
            crcOs.close();
            int length = os.getLength();
            this._manager.addSessionSaveSample(length);
            this._lastSaveLength = length;
            long lastModifiedTime = lastAccessTime = this._accessTime;
            this._cacheEntry = this._manager.getCache().put(this._id, os.getInputStream(), this._idleTimeout, -1L, lastAccessTime, lastModifiedTime);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " session save valueHash=" + (this._cacheEntry != null ? Long.toHexString(this._cacheEntry.getValueHash()) : null));
            }
            os.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, this + ": can't serialize session", e);
        }
    }

    void saveOnShutdown() {
        this.save();
    }

    public void passivate() {
        this.unbind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(SessionSerializer out) throws IOException {
        Set<Map.Entry<String, Object>> set = null;
        HttpSessionEvent event = null;
        out.writeObject(this.getId());
        Object object = this._values;
        synchronized (object) {
            int size;
            set = this._values.entrySet();
            int n = size = set == null ? 0 : set.size();
            if (size == 0) {
                out.writeInt(0);
                return;
            }
            ArrayList<HttpSessionActivationListener> listeners = this._manager.getActivationListeners();
            if (listeners != null && listeners.size() > 0) {
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                for (int i = 0; i < listeners.size(); ++i) {
                    HttpSessionActivationListener listener = listeners.get(i);
                    listener.sessionWillPassivate(event);
                }
            }
            for (Map.Entry<String, Object> entry : set) {
                Object value = entry.getValue();
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                listener.sessionWillPassivate(event);
            }
        }
        object = this;
        synchronized (object) {
            Map<String, Object> map = this._values;
            synchronized (map) {
                set = this._values.entrySet();
                int size = set == null ? 0 : set.size();
                out.writeInt(size);
                if (size == 0) {
                    return;
                }
                boolean ignoreNonSerializable = this.getManager().getIgnoreSerializationErrors();
                for (Map.Entry<String, Object> entry : set) {
                    Object value = entry.getValue();
                    out.writeObject(entry.getKey());
                    if (ignoreNonSerializable && !(value instanceof Serializable)) {
                        out.writeObject(null);
                        continue;
                    }
                    try {
                        out.writeObject(value);
                    }
                    catch (NotSerializableException e) {
                        log.warning(L.l("{0}: failed storing persistent session attribute '{1}'.  Persistent session values must extend java.io.Serializable.\n{2}", (Object)this, (Object)entry.getKey(), (Object)String.valueOf(e)));
                        throw e;
                    }
                }
            }
        }
    }

    public void invalidate() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " invalidate");
        }
        this._state = this._state.toInvalidating();
        this.invalidate(Logout.INVALIDATE);
    }

    public void timeout() {
        if (!this._manager.isPersistenceEnabled()) {
            this.invalidateTimeout();
        } else {
            this.invalidateTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEvent() {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            if (this._state.isInvalidating() || this._useCount.get() <= 0) {
                this._state = this._state.toLru();
            }
        }
        if (!this._state.isClosing()) {
            log.warning(L.l("{0} LRU while in use (use-count={1}).  Consider increasing session-count.", (Object)this, (Object)this._useCount));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " remove " + (Object)((Object)this._state));
        }
        long now = CurrentTime.getCurrentTime();
        if (this._state.isInvalidating() || this._manager.isDestroyOnLru() || this._accessTime + (long)this.getMaxInactiveInterval() < now) {
            this.notifyDestroy();
        }
        this.invalidateLocal();
    }

    private void notifyDestroy() {
        ArrayList<HttpSessionListener> listeners = this._manager.getListeners();
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (int i = listeners.size() - 1; i >= 0; --i) {
                HttpSessionListener listener = listeners.get(i);
                listener.sessionDestroyed(event);
            }
        }
    }

    public void invalidateLogout() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " logout");
        }
        this._state = this._state.toInvalidating();
        this.invalidate(Logout.INVALIDATE);
    }

    void invalidateTimeout() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " timeout");
        }
        if (this._manager.isOwner(this._id)) {
            this._state = this._state.toInvalidating();
        }
        this.invalidate(Logout.TIMEOUT);
    }

    void invalidateLru() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " lru");
        }
        this.invalidateImpl(Logout.LRU);
    }

    public void invalidateRemote() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " invalidate remote");
        }
        this._state = this._state.toInvalidating();
        this.invalidate(Logout.INVALIDATE);
    }

    private void invalidate(Logout logout) {
        if (this.isClosed()) {
            throw new IllegalStateException(L.l("{0}: Can't call invalidate() when session is no longer valid.", (Object)this));
        }
        try {
            Login login = this._manager.getWebApp().getLogin();
            if (login != null) {
                login.sessionInvalidate(this, logout == Logout.TIMEOUT);
            }
            this._manager.removeSession(this);
            this.invalidateImpl(logout);
        }
        finally {
            this._state = this._state.toClosed();
        }
    }

    private void invalidateImpl(Logout logout) {
        State state = this._state;
        boolean invalidateAfterListener = this._manager.isInvalidateAfterListener();
        if (!invalidateAfterListener) {
            this._state = this._state.toClosing();
        }
        try {
            if (state.isInvalidating() && this._manager.getSessionStore() != null) {
                boolean isRemove = false;
                isRemove = true;
                if (!isRemove && logout == Logout.TIMEOUT) {
                    ExtCacheEntry<?, ?> entry = this._manager.getSessionStore().peekExtCacheEntry(this._id);
                    if (entry == null || !entry.isValid()) {
                        isRemove = true;
                    }
                } else {
                    isRemove = true;
                }
                if (isRemove) {
                    this._manager.getSessionStore().remove(this._id);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.invalidateLocal();
    }

    private void invalidateLocal() {
        if (!this.isClosed() && !this._state.isInvalidating() && this._manager.isSaveOnlyOnShutdown()) {
            this.save();
        }
        this.unbind();
        Login login = this._manager.getWebApp().getLogin();
        if (login != null) {
            login.sessionInvalidate(this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        if (this._values.size() == 0) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Map<String, Object> map = this._values;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this._values.entrySet()) {
                names.add(entry.getKey());
                values.add(entry.getValue());
            }
            this._values.clear();
        }
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            Object value = values.get(i);
            this.notifyValueUnbound(name, value);
        }
    }

    private void notifyValueUnbound(String name, Object oldValue) {
        ArrayList<HttpSessionAttributeListener> listeners;
        if (oldValue == null) {
            return;
        }
        if (oldValue instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
        }
        if ((listeners = this._manager.getAttributeListeners()) != null) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener = listeners.get(i);
                listener.attributeRemoved(event);
            }
        }
    }

    public String toString() {
        WebApp webApp;
        String contextPath = "";
        SessionManager manager = this._manager;
        if (manager != null && (webApp = manager.getWebApp()) != null) {
            contextPath = "," + webApp.getContextPath();
        }
        return this.getClass().getSimpleName() + "[" + this.getId() + contextPath + "]";
    }

    static enum State {
        active{

            @Override
            boolean isValid() {
                return true;
            }
        }
        ,
        invalidating{

            @Override
            boolean isClosing() {
                return true;
            }

            @Override
            boolean isInvalidating() {
                return true;
            }

            @Override
            State toLru() {
                return this;
            }
        }
        ,
        lru{

            @Override
            boolean isClosing() {
                return true;
            }
        }
        ,
        closing{

            @Override
            boolean isClosing() {
                return true;
            }

            @Override
            State toInvalidating() {
                return this;
            }

            @Override
            State toLru() {
                return this;
            }
        }
        ,
        closed{

            @Override
            boolean isClosed() {
                return true;
            }

            @Override
            State toClosing() {
                return this;
            }

            @Override
            State toInvalidating() {
                return this;
            }

            @Override
            State toLru() {
                return this;
            }
        };


        boolean isValid() {
            return false;
        }

        boolean isClosing() {
            return false;
        }

        boolean isInvalidating() {
            return false;
        }

        boolean isClosed() {
            return false;
        }

        State toClosed() {
            return closed;
        }

        State toClosing() {
            return closing;
        }

        State toInvalidating() {
            return invalidating;
        }

        State toLru() {
            return lru;
        }
    }

    static enum Logout {
        INVALIDATE,
        LRU,
        TIMEOUT;

    }
}

