/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp;

import com.caucho.jmx.Jmx;
import com.caucho.network.listen.AbstractProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.server.snmp.Oid;
import com.caucho.server.snmp.SnmpParser;
import com.caucho.server.snmp.SnmpRuntimeException;
import com.caucho.server.snmp.types.GetResponsePduValue;
import com.caucho.server.snmp.types.IntegerValue;
import com.caucho.server.snmp.types.NullValue;
import com.caucho.server.snmp.types.ObjectIdentifierValue;
import com.caucho.server.snmp.types.OctetStringValue;
import com.caucho.server.snmp.types.PduValue;
import com.caucho.server.snmp.types.SnmpMessageValue;
import com.caucho.server.snmp.types.SnmpValue;
import com.caucho.server.snmp.types.VarBindListValue;
import com.caucho.server.snmp.types.VarBindValue;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class SnmpRequest
extends AbstractProtocolConnection {
    private static final Logger log = Logger.getLogger(SnmpRequest.class.getName());
    private static final L10N L = new L10N(SnmpRequest.class);
    public static final int NO_ERROR = 0;
    public static final int TOO_BIG = 1;
    public static final int NO_SUCH_NAME = 2;
    public static final int BAD_VALUE = 3;
    public static final int READ_ONLY = 4;
    public static final int GENERAL_ERROR = 5;
    private final SocketLink _connection;
    private IntegerValue _version = IntegerValue.ZERO;
    private final OctetStringValue _communityString;
    private TreeMap<String, Oid> _mibMap;

    public SnmpRequest(SocketLink connection, TreeMap<String, Oid> mibMap, OctetStringValue community) {
        this._connection = connection;
        this._mibMap = mibMap;
        this._communityString = community;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isWaitForRead() {
        return true;
    }

    public void startConnection() {
    }

    @Override
    public boolean handleRequest() throws IOException {
        ReadStream in = this._connection.getReadStream();
        SnmpParser parser = new SnmpParser(in);
        SnmpMessageValue req = parser.readMessage();
        this.checkVersion(req);
        this.authenticate(req);
        SnmpMessageValue response = this.composeResponse(req);
        this.sendResponse(response);
        return true;
    }

    protected final void checkVersion(SnmpMessageValue req) {
        if (!this._version.equals(req.getVersion())) {
            log.fine(L.l("expected version {0} != {1}", (Object)this._version, (Object)req.getVersion()));
            throw new SnmpRuntimeException(L.l("expected version {0} != {1}", (Object)this._version, (Object)req.getVersion()));
        }
    }

    protected final void authenticate(SnmpMessageValue req) {
        if (!this._communityString.equals(req.getCommunityString())) {
            log.fine(L.l("non-matching community string"));
            throw new SnmpRuntimeException(L.l("non-matching community string"));
        }
    }

    protected final void sendResponse(SnmpValue response) throws IOException {
        WriteStream out = this._connection.getWriteStream();
        StringBuilder sb = new StringBuilder();
        response.toAsn1(sb);
        for (int i = 0; i < sb.length(); ++i) {
            ((OutputStream)out).write((byte)sb.charAt(i));
        }
        ((OutputStream)out).flush();
    }

    protected final SnmpMessageValue composeResponse(SnmpMessageValue req) {
        VarBindListValue varBindList;
        IntegerValue errorIndex;
        IntegerValue error;
        block17: {
            error = IntegerValue.ZERO;
            errorIndex = IntegerValue.ZERO;
            varBindList = new VarBindListValue();
            int i = -1;
            try {
                switch (req.getPdu().getType()) {
                    case 160: {
                        ObjectIdentifierValue[] oids = req.getVarBindList().getNames();
                        for (i = 0; i < oids.length; ++i) {
                            VarBindValue varBind;
                            SnmpValue attr = this.getMBean(oids[i]);
                            if (attr != null) {
                                varBind = new VarBindValue(oids[i], attr);
                            } else {
                                varBind = new VarBindValue(oids[i], NullValue.NULL);
                                if (error.getLong() == 0L) {
                                    error = new IntegerValue(2);
                                    errorIndex = new IntegerValue(i + 1);
                                }
                            }
                            varBindList.add(varBind);
                        }
                        break;
                    }
                    case 161: {
                        ObjectIdentifierValue[] oids;
                        for (ObjectIdentifierValue oid : oids = req.getVarBindList().getNames()) {
                            VarBindValue varBind;
                            String key = this._mibMap.higherKey(oid.getString());
                            if (key == null) {
                                key = this._mibMap.ceilingKey(oid.toString());
                            }
                            if (key != null) {
                                ObjectIdentifierValue nextObjIdVal = new ObjectIdentifierValue(key);
                                SnmpValue value = this.getMBean(nextObjIdVal);
                                varBind = new VarBindValue(nextObjIdVal, value);
                            } else {
                                varBind = new VarBindValue(oid, NullValue.NULL);
                                if (error.getLong() == 0L) {
                                    error = new IntegerValue(2);
                                    errorIndex = new IntegerValue(i + 1);
                                }
                            }
                            varBindList.add(varBind);
                        }
                        break;
                    }
                    case 163: {
                        break;
                    }
                    default: {
                        log.fine(L.l("invalid pdu type {0}", req.getType()));
                        throw new SnmpRuntimeException(L.l("invalid pdu type {0}", req.getType()));
                    }
                }
            }
            catch (Exception e) {
                if (error.getLong() == 0L) {
                    error = new IntegerValue(5);
                    errorIndex = new IntegerValue(i + 1);
                }
                if (req.getVarBindList().size() <= i) break block17;
                VarBindValue varBind = new VarBindValue(((VarBindValue)req.getVarBindList().get(i)).getName(), new OctetStringValue(e.getMessage()));
                varBindList.add(varBind);
            }
        }
        GetResponsePduValue pdu = new GetResponsePduValue(req.getRequestId(), error, errorIndex, varBindList);
        return new SnmpMessageValue(req.getVersion(), req.getCommunityString(), (PduValue)pdu);
    }

    protected SnmpValue getMBean(ObjectIdentifierValue objectIdentifier) {
        MBeanServer mbeanServer = this.getMBeanServer();
        Oid oid = this._mibMap.get(objectIdentifier.getString());
        if (oid == null) {
            return null;
        }
        try {
            ObjectName mbean = new ObjectName(oid.getMbean());
            Object attr = mbeanServer.getAttribute(mbean, oid.getAttribute());
            return SnmpValue.create(attr, oid.getType());
        }
        catch (MalformedObjectNameException e) {
            log.fine(e.getMessage());
            throw new SnmpRuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            log.fine(e.getMessage());
            return null;
        }
        catch (InstanceNotFoundException e) {
            log.fine(e.getMessage());
            return null;
        }
        catch (MBeanException e) {
            log.fine(e.getMessage());
            throw new SnmpRuntimeException(e);
        }
        catch (ReflectionException e) {
            log.fine(e.getMessage());
            throw new SnmpRuntimeException(e);
        }
        catch (Exception e) {
            log.fine(e.getMessage());
            return null;
        }
    }

    protected MBeanServer getMBeanServer() {
        return Jmx.getMBeanServer();
    }

    @Override
    public boolean handleResume() throws IOException {
        return false;
    }

    @Override
    public void onCloseConnection() {
    }

    public void setVersion(int version) {
        this._version = new IntegerValue(version);
    }

    public TreeMap<String, Oid> getMib() {
        return this._mibMap;
    }
}

