/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.VersionFactory;
import com.caucho.config.LineException;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.i18n.CharacterEncoding;
import com.caucho.java.LineMap;
import com.caucho.java.LineMapException;
import com.caucho.java.ScriptStackTrace;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.host.Host;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CompileException;
import com.caucho.util.CurrentTime;
import com.caucho.util.DisplayableException;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.util.QDate;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Vfs;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ErrorPageManager {
    private static final L10N L = new L10N(ErrorPageManager.class);
    private static final Logger log = Logger.getLogger(ErrorPageManager.class.getName());
    public static final char[] MSIE_PADDING;
    public static String JSP_EXCEPTION;
    public static String SHUTDOWN;
    private final ServletService _server;
    private final Host _host;
    private final WebApp _webApp;
    private WebAppContainer _appContainer;
    private HashMap<Object, String> _errorPageMap = new HashMap();
    private String _defaultLocation;
    private ErrorPageManager _parent;

    public ErrorPageManager(ServletService server) {
        this(server, null, null);
    }

    public ErrorPageManager(ServletService server, WebApp webApp) {
        this(server, null, webApp);
    }

    public ErrorPageManager(ServletService server, Host host, WebApp app) {
        this._webApp = app;
        this._server = server;
        this._host = host;
        if (this._server == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1}", (Object)this.getClass().getSimpleName(), (Object)ServletService.class.getSimpleName()));
        }
    }

    public void setParent(ErrorPageManager parent) {
        this._parent = parent;
    }

    public ErrorPageManager getParent() {
        return this._parent;
    }

    public void addErrorPage(ErrorPage errorPage) {
        if (errorPage.getExceptionType() != null) {
            this._errorPageMap.put(errorPage.getExceptionType(), errorPage.getLocation());
        } else if (errorPage.getErrorCode() < 0) {
            this._defaultLocation = errorPage.getLocation();
        } else {
            this._errorPageMap.put(new Integer(errorPage.getErrorCode()), errorPage.getLocation());
        }
    }

    public void setWebAppContainer(WebAppContainer appContainer) {
        this._appContainer = appContainer;
    }

    protected boolean isDevelopmentModeErrorPage() {
        return this._server.isDevelopmentModeErrorPage();
    }

    protected boolean isErrorPageServerId() {
        return this._server.isErrorPageServerId() || this.isDevelopmentModeErrorPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendServletError(Throwable e, ServletRequest req, ServletResponse res) throws IOException {
        try {
            this.sendServletErrorImpl(e, req, res);
        }
        finally {
            if (res instanceof CauchoResponse) {
                ((CauchoResponse)res).close();
            }
        }
    }

    public void sendServletErrorImpl(Throwable e, ServletRequest req, ServletResponse res) throws IOException {
        PrintWriter out;
        Level level;
        AsyncContext async;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        Throwable rootExn = e;
        Throwable errorPageExn = null;
        LineMap lineMap = null;
        try {
            if (response != null) {
                response.reset();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (req.isAsyncStarted() && (async = req.getAsyncContext()) != null) {
            async.complete();
        }
        if (response instanceof HttpServletResponseImpl) {
            HttpServletResponseImpl resFacade = (HttpServletResponseImpl)response;
            resFacade.killCache();
            resFacade.setNoCache(true);
        }
        if (rootExn instanceof ClientDisconnectException) {
            throw (ClientDisconnectException)rootExn;
        }
        String location = null;
        String title = "500 Servlet Exception";
        boolean isBadRequest = false;
        boolean doStackTrace = true;
        boolean isCompileException = false;
        boolean isServletException = false;
        Throwable compileException = null;
        String lineMessage = null;
        boolean lookupErrorPage = true;
        while (true) {
            if (rootExn instanceof LineMapException) {
                lineMap = ((LineMapException)((Object)rootExn)).getLineMap();
            }
            if (lookupErrorPage) {
                errorPageExn = rootExn;
            }
            if (rootExn instanceof DisplayableException) {
                doStackTrace = false;
                isCompileException = true;
                if (compileException == null) {
                    compileException = rootExn;
                }
            } else if (rootExn instanceof CompileException) {
                doStackTrace = false;
                isCompileException = true;
                if (compileException == null) {
                    compileException = rootExn;
                }
            } else if (rootExn instanceof LineException && lineMessage == null) {
                lineMessage = rootExn.getMessage();
            }
            if (rootExn instanceof BadRequestException) {
                isBadRequest = true;
            }
            if (rootExn instanceof OutOfMemoryError) {
                String msg = "TcpSocketLink OutOfMemory";
                ShutdownSystem.shutdownOutOfMemory(msg);
            }
            if (location == null && lookupErrorPage && (!(rootExn instanceof LineMapException) || !(rootExn instanceof ServletException) || rootExn instanceof LineCompileException || rootExn.getCause() == null)) {
                if (!isServletException) {
                    location = this.getErrorPage(rootExn);
                    isServletException = true;
                } else {
                    location = this.getErrorPage(rootExn);
                    lookupErrorPage = false;
                }
            }
            if (location != null) {
                lookupErrorPage = false;
            }
            if (isBadRequest) break;
            Throwable cause = null;
            if (rootExn instanceof ServletException && !(rootExn instanceof LineCompileException)) {
                cause = ((ServletException)rootExn).getRootCause();
            } else {
                lookupErrorPage = false;
                cause = rootExn.getCause();
            }
            if (cause == null) break;
            rootExn = cause;
        }
        if (location == null && lookupErrorPage) {
            location = this.getErrorPage(rootExn);
        }
        if (location == null && rootExn instanceof BadRequestException) {
            location = this.getErrorPage(400);
        } else if (location == null) {
            location = this.getErrorPage(500);
        }
        if (location == null && this._defaultLocation == null && this._parent != null) {
            this._parent.sendServletError(e, req, res);
            return;
        }
        if (isBadRequest) {
            title = rootExn instanceof CompileException ? rootExn.getMessage() : String.valueOf(rootExn);
            doStackTrace = false;
            isBadRequest = true;
            if (request instanceof CauchoRequest) {
                ((CauchoRequest)request).killKeepalive("bad request: " + rootExn);
            }
            response.resetBuffer();
            response.setStatus(400);
        } else if (rootExn instanceof UnavailableException) {
            UnavailableException unAvail = (UnavailableException)rootExn;
            if (unAvail.isPermanent()) {
                response.setStatus(404);
                title = "404 Not Found";
                if (location == null) {
                    location = this.getErrorPage(404);
                }
            } else {
                response.setStatus(503);
                title = "503 Unavailable";
                if (unAvail.getUnavailableSeconds() > 0) {
                    response.setIntHeader("Retry-After", unAvail.getUnavailableSeconds());
                }
                if (location == null) {
                    location = this.getErrorPage(503);
                }
            }
        } else {
            response.setStatus(500);
        }
        if (location == null) {
            location = this._defaultLocation;
        }
        Level level2 = level = location == null ? Level.WARNING : Level.FINE;
        if (log.isLoggable(Level.FINER)) {
            log.log(level, e.toString(), e);
        } else if (isCompileException) {
            Level level3 = level = location == null ? Level.WARNING : Level.INFO;
            if (isBadRequest) {
                log.log(level, BadRequestException.class.getSimpleName() + ": " + compileException.getMessage());
            } else {
                log.log(level, compileException.getMessage());
            }
        } else if (!doStackTrace) {
            log.log(level, rootExn.toString());
        } else {
            log.log(level, e.toString(), e);
        }
        if (location != null) {
            String servletName;
            if (errorPageExn == null) {
                errorPageExn = rootExn;
            }
            request.setAttribute(JSP_EXCEPTION, (Object)errorPageExn);
            request.setAttribute("javax.servlet.error.exception", (Object)errorPageExn);
            request.setAttribute("javax.servlet.error.exception_type", errorPageExn.getClass());
            if (request instanceof HttpServletRequest) {
                request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
            }
            if ((servletName = this.getServletName((ServletRequest)request)) != null) {
                request.setAttribute("javax.servlet.error.servlet_name", (Object)servletName);
            }
            request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
            request.setAttribute("javax.servlet.error.message", (Object)errorPageExn.getMessage());
            try {
                RequestDispatcherImpl disp = null;
                WebApp webApp = this.getWebApp();
                if (webApp != null) {
                    disp = webApp.getRequestDispatcher(location);
                } else if (this._host != null) {
                    disp = this._host.getWebAppContainer().getRequestDispatcher(location);
                }
                if (disp != null) {
                    disp.error((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
            catch (Throwable e1) {
                log.log(Level.INFO, e1.toString(), e1);
                rootExn = e1;
            }
        }
        response.setContentType("text/html");
        String encoding = CharacterEncoding.getLocalEncoding();
        if (encoding != null) {
            response.setCharacterEncoding(encoding);
        } else {
            Locale locale = Locale.getDefault();
            if (!"ISO-8859-1".equals(Encoding.getMimeName(locale))) {
                response.setLocale(Locale.getDefault());
            } else {
                response.setCharacterEncoding("utf-8");
            }
        }
        try {
            out = response.getWriter();
        }
        catch (IllegalStateException e1) {
            log.log(Level.FINEST, e1.toString(), e1);
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        if (this.isDevelopmentModeErrorPage()) {
            out.println("<html>");
            if (!response.isCommitted()) {
                out.println("<head><title>" + this.escapeHtml(title) + "</title></head>");
            }
            out.println("<body>");
            out.println("<h1>" + this.escapeHtml(title) + "</h1>");
            out.println("<code><pre>");
            if (log.isLoggable(Level.FINE) && !CurrentTime.isTest()) {
                doStackTrace = true;
            }
            if (doStackTrace) {
                out.println("<script language='javascript' type='text/javascript'>");
                out.println("function show() { document.getElementById('trace').style.display = ''; }");
                out.println("</script>");
                out.print("<a style=\"text-decoration\" href=\"javascript:show();\">[show]</a> ");
            }
            if (compileException instanceof DisplayableException) {
                out.println(this.escapeHtml(compileException.getMessage()));
            } else if (compileException != null) {
                out.println(this.escapeHtml(compileException.getMessage()));
            } else {
                out.println(this.escapeHtml(rootExn.toString()));
            }
            if (doStackTrace) {
                out.println("<span id=\"trace\" style=\"display:none\">");
                this.printStackTrace(out, lineMessage, e, rootExn, lineMap);
                out.println("</span>");
            }
            out.println("</pre></code>");
            this.printVersion(out);
            out.println("</body></html>");
        } else {
            out.println("<html>");
            out.println("<title>Server Error</title>");
            out.println("<body>");
            out.println("<h1>Server Error</h1>");
            out.println("<p>The server is temporarily unavailable due to an");
            out.println("internal error.  Please notify the system administrator");
            out.println("of this problem.</p>");
            out.println("<pre><code>");
            out.println("Date: " + QDate.formatISO8601(CurrentTime.getCurrentTime()));
            out.println("</code></pre>");
            this.printVersion(out);
            out.println("</body></html>");
        }
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && userAgent.indexOf("MSIE") >= 0) {
            out.print(MSIE_PADDING);
        }
        out.close();
    }

    private void printVersion(PrintWriter out) throws IOException {
        ServletService server = this._server;
        String version = null;
        if (server != null) {
            if (server.getServerHeader() != null) {
                version = server.getServerHeader();
            } else if (!CauchoSystem.isTesting()) {
                version = VersionFactory.getFullVersion();
            }
        }
        if (version != null) {
            out.println("<p /><hr />");
            out.println("<small>");
            out.println(version);
            if (server != null && this.isErrorPageServerId()) {
                out.println("Server: '" + server.getServerId() + "'");
            }
            out.println("</small>");
        }
    }

    private String getServletName(ServletRequest request) {
        if (request instanceof HttpServletRequestImpl) {
            return ((HttpServletRequestImpl)request).getServletName();
        }
        if (request instanceof ServletRequestWrapper) {
            return this.getServletName(((ServletRequestWrapper)request).getRequest());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(CauchoRequest request, CauchoResponse response, int code, String message) throws IOException {
        try {
            this.sendErrorImpl(request, response, code, message);
        }
        finally {
            response.close();
        }
    }

    public void sendErrorImpl(CauchoRequest request, CauchoResponse response, int code, String message) throws IOException {
        response.resetBuffer();
        response.setStatus(code, message);
        try {
            PrintWriter out;
            if (this.handleErrorStatus(request, response, code, message) || code == 304) {
                return;
            }
            response.setContentType("text/html; charset=utf-8");
            boolean isOutputStreamWrapper = false;
            try {
                out = response.getWriter();
            }
            catch (IllegalStateException e) {
                log.log(Level.ALL, e.toString(), e);
                out = Vfs.openWrite((OutputStream)response.getOutputStream()).getPrintWriter();
                isOutputStreamWrapper = true;
            }
            out.println("<html>");
            if (!response.isCommitted()) {
                out.print("<head><title>");
                out.print(code);
                out.print(" ");
                out.print(this.escapeHtml(message));
                out.println("</title></head>");
            }
            out.println("<body>");
            out.print("<h1>");
            out.print(code);
            out.print(" ");
            out.print(this.escapeHtml(message));
            out.println("</h1>");
            if (code == 404) {
                out.println(L.l("{0} was not found on this server.", (Object)this.escapeHtml(request.getPageURI())));
            }
            this.printVersion(out);
            out.println("</body></html>");
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null && userAgent.indexOf("MSIE") >= 0) {
                out.write(MSIE_PADDING, 0, MSIE_PADDING.length);
            }
            if (isOutputStreamWrapper) {
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private boolean handleErrorStatus(CauchoRequest request, CauchoResponse response, int code, String message) throws ServletException, IOException {
        if (code == 200 || code == 302 || code == 304) {
            return false;
        }
        if (request.getRequestDepth(0) > 16) {
            return false;
        }
        if (request.getAttribute("javax.servlet.error.request_uri") != null) {
            return false;
        }
        response.killCache();
        String location = this.getErrorPage(code);
        if (location == null) {
            location = this._defaultLocation;
        }
        if (location == null && this._parent != null) {
            return this._parent.handleErrorStatus(request, response, code, message);
        }
        WebApp webApp = this.getWebApp();
        if (webApp == null && this._host == null) {
            return false;
        }
        if (location != null && !location.equals(request.getRequestURI())) {
            request.setAttribute("javax.servlet.error.status_code", new Integer(code));
            request.setAttribute("javax.servlet.error.message", message);
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            String servletName = this.getServletName((ServletRequest)request);
            if (servletName != null) {
                request.setAttribute("javax.servlet.error.servlet_name", servletName);
            }
            try {
                RequestDispatcherImpl disp = null;
                if (webApp != null) {
                    disp = webApp.getRequestDispatcher(location);
                } else if (this._host != null) {
                    disp = this._host.getWebAppContainer().getRequestDispatcher(location);
                }
                if (disp == null) {
                    return false;
                }
                disp.error((ServletRequest)request, (ServletResponse)response);
            }
            catch (Throwable e) {
                this.sendServletError(e, (ServletRequest)request, (ServletResponse)response);
            }
            return true;
        }
        return false;
    }

    String getErrorPage(Throwable e) {
        return this.getErrorPage(e, Throwable.class);
    }

    String getErrorPage(Throwable e, Class<?> limit) {
        Class<?> cl;
        for (cl = e.getClass(); cl != null; cl = cl.getSuperclass()) {
            String location = this._errorPageMap.get(cl.getName());
            if (location != null) {
                return location;
            }
            if (cl == limit) break;
        }
        for (cl = e.getClass(); cl != null; cl = cl.getSuperclass()) {
            String location;
            String name = cl.getName();
            int p = name.lastIndexOf(46);
            if (p > 0 && (location = this._errorPageMap.get(name = name.substring(p + 1))) != null) {
                return location;
            }
            if (cl == limit) break;
        }
        return null;
    }

    private WebApp getWebApp() {
        if (this._webApp != null) {
            return this._webApp;
        }
        if (this._host != null) {
            return this._host.getWebAppContainer().findWebAppByURI("/");
        }
        return null;
    }

    String getErrorPage(int code) {
        Integer key = new Integer(code);
        String location = this._errorPageMap.get(key);
        if (location != null) {
            return location;
        }
        return this._errorPageMap.get(new Integer(0));
    }

    private void printStackTrace(PrintWriter out, String lineMessage, Throwable e, Throwable rootExn, LineMap lineMap) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        if (lineMessage != null) {
            pw.println(lineMessage);
        }
        if (lineMap != null) {
            lineMap.printStackTrace(e, pw);
        } else {
            ScriptStackTrace.printStackTrace(e, pw);
        }
        pw.close();
        char[] array = writer.toCharArray();
        out.print(this.escapeHtml(new String(array)));
    }

    private String escapeHtml(String s) {
        if (s == null) {
            return null;
        }
        if (CurrentTime.isTest()) {
            s = this.normalizeForTesting(s);
        }
        CharBuffer cb = new CharBuffer();
        int lineCharacter = 0;
        boolean startsWithSpace = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            ++lineCharacter;
            if (ch == '<') {
                cb.append("&lt;");
                continue;
            }
            if (ch == '&') {
                cb.append("&amp;");
                continue;
            }
            if (ch == '\n' || ch == '\r') {
                lineCharacter = 0;
                cb.append(ch);
                startsWithSpace = false;
                continue;
            }
            if (lineCharacter > 70 && ch == ' ' && !startsWithSpace) {
                lineCharacter = 0;
                cb.append('\n');
                while (i + 1 < s.length() && s.charAt(i + 1) == ' ') {
                    ++i;
                }
                continue;
            }
            if (lineCharacter == 1 && (ch == ' ' || ch == '\t')) {
                cb.append(ch);
                startsWithSpace = true;
                continue;
            }
            cb.append(ch);
        }
        return cb.toString();
    }

    private String normalizeForTesting(String s) {
        int p;
        String userName = System.getProperty("user.name");
        if ("caucho".equals(userName)) {
            return s;
        }
        while ((p = s.indexOf(userName)) >= 0) {
            String head = s.substring(0, p);
            String tail = s.substring(p + userName.length());
            s = head + "caucho" + tail;
        }
        return s;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._webApp + "]";
    }

    static {
        JSP_EXCEPTION = "javax.servlet.jsp.jspException";
        SHUTDOWN = "com.caucho.shutdown";
        MSIE_PADDING = "\n\n\n\n<!--\n   - Because some older browsers replace their own messages\n   - to replace server error messages if the server\n   - message is too short, it's necessary to pad out\n   - the error message to be at least 512 bytes.  With\n   - this padding, Resin more informative error messages\n   - are available, making  debugging more straightforward.\n   - \n   - \n   - Padding message repeats:\n   - \n   - \n   - Because some older browsers replace their own messages\n   - to replace server error messages if the server\n   - message is too short, it's necessary to pad out\n   - the error message to be at least 512 bytes.  With\n   - this padding, Resin more informative error messages\n   - are available, making  debugging more straightforward.\n   - \n   -->\n".toCharArray();
    }
}

