/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployContainerApi;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.make.AlwaysModified;
import com.caucho.rewrite.DispatchRule;
import com.caucho.rewrite.RewriteFilter;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationBuilder;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EarDeployController;
import com.caucho.server.e_app.EarDeployGenerator;
import com.caucho.server.e_app.EarSingleDeployGenerator;
import com.caucho.server.host.Host;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.server.log.AccessLog;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.session.SessionManager;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.ContextFilterChain;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.UnknownWebAppController;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppEarDeployGenerator;
import com.caucho.server.webapp.WebAppExpandDeployGenerator;
import com.caucho.server.webapp.WebAppRegexpDeployGenerator;
import com.caucho.server.webapp.WebAppSingleDeployGenerator;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

public class WebAppContainer
implements InvocationBuilder,
ClassLoaderListener,
EnvironmentListener {
    static final L10N L = new L10N(WebApp.class);
    private static final Logger log = Logger.getLogger(WebAppContainer.class.getName());
    private ServletService _server;
    private Host _host;
    private EnvironmentClassLoader _classLoader;
    private final Lifecycle _lifecycle;
    private Path _rootDir;
    private Path _docDir;
    private RewriteDispatch _rewriteDispatch;
    private WebApp _errorWebApp;
    private ArrayList<EarConfig> _earDefaultList = new ArrayList();
    private DeployContainer<EarDeployController> _earDeploy;
    private final DeployContainer<WebAppController> _appDeploySpi = new DeployContainer<WebAppController>(WebAppController.class);
    private final DeployContainerApi<WebAppController> _appDeploy = this._appDeploySpi;
    private WebAppExpandDeployGenerator _warGenerator;
    private boolean _hasWarGenerator;
    private static final int URI_CACHE_SIZE = 8192;
    private LruCache<String, WebAppUriMap> _uriToAppCache = new LruCache(8192);
    private ArrayList<WebAppConfig> _webAppDefaultList = new ArrayList();
    private AbstractAccessLog _accessLog;
    private long _startWaitTime = 10000L;
    private Throwable _configException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppContainer(ServletService server, Host host, Path rootDirectory, EnvironmentClassLoader loader, Lifecycle lifecycle) {
        this._server = server;
        if (server == null) {
            throw new NullPointerException();
        }
        this._host = host;
        if (host == null) {
            throw new NullPointerException();
        }
        this._rootDir = rootDirectory;
        this._classLoader = loader;
        if (lifecycle == null) {
            throw new NullPointerException();
        }
        this._lifecycle = lifecycle;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            this._earDeploy = new DeployContainer<EarDeployController>(EarDeployController.class);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected ServletService getServer() {
        return this._server;
    }

    public InvocationDecoder getInvocationDecoder() {
        return this.getServer().getInvocationDecoder();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._classLoader = loader;
    }

    public Host getHost() {
        return this._host;
    }

    public String getStageTag() {
        return this.getServer().getStage();
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    public void setRootDirectory(Path path) {
        this._rootDir = path;
        Vfs.setPwd(path, this.getClassLoader());
    }

    public Path getDocumentDirectory() {
        if (this._docDir != null) {
            return this._docDir;
        }
        return this._rootDir;
    }

    public void setDocumentDirectory(Path path) {
        this._docDir = path;
    }

    public void setDocDir(Path path) {
        this.setDocumentDirectory(path);
    }

    public AbstractAccessLog createAccessLog() {
        if (this._accessLog == null) {
            this._accessLog = new AccessLog();
        }
        return this._accessLog;
    }

    public void setAccessLog(AbstractAccessLog log) {
        this._accessLog = log;
        Environment.setAttribute("caucho.server.access-log", log);
    }

    public void addErrorPage(ErrorPage errorPage) {
        this.getErrorPageManager().addErrorPage(errorPage);
    }

    public ErrorPageManager getErrorPageManager() {
        return this.getErrorWebApp().getErrorPageManager();
    }

    public void setConfigException(Throwable e) {
        this._configException = e;
    }

    public DeployContainer<WebAppController> getWebAppGenerator() {
        return this._appDeploySpi;
    }

    public SessionManager getSessionManager() {
        return null;
    }

    public void add(DispatchRule dispatchRule) {
        if (dispatchRule.isRequest()) {
            RewriteDispatch rewrite = this.createRewriteDispatch();
            rewrite.addRule(dispatchRule);
        }
    }

    public void add(RewriteFilter dispatchAction) {
        if (dispatchAction.isRequest()) {
            RewriteDispatch rewrite = this.createRewriteDispatch();
            rewrite.addAction(dispatchAction);
        }
    }

    public RewriteDispatch createRewriteDispatch() {
        if (this._rewriteDispatch == null) {
            this._rewriteDispatch = new RewriteDispatch(this.getServer());
        }
        return this._rewriteDispatch;
    }

    public boolean isModified() {
        return this._lifecycle.isDestroyed() || this._classLoader.isModified();
    }

    public boolean isDeployModified() {
        return this._appDeploy.isModified();
    }

    public void addWebApp(WebAppConfig config) {
        if (config.getURLRegexp() != null) {
            WebAppRegexpDeployGenerator deploy = new WebAppRegexpDeployGenerator(this._appDeploySpi, this, config);
            this._appDeploy.add(deploy);
            this.clearCache();
            return;
        }
        WebAppSingleDeployGenerator deployGenerator = this.createDeployGenerator(config);
        this.addWebApp(deployGenerator);
    }

    public WebAppSingleDeployGenerator createDeployGenerator(WebAppConfig config) {
        return new WebAppSingleDeployGenerator(this._appDeploySpi, this, config);
    }

    public void addWebApp(WebAppSingleDeployGenerator deployGenerator) {
        deployGenerator.deploy();
        this._appDeploy.add(deployGenerator);
        this.clearCache();
    }

    public void removeWebApp(WebAppSingleDeployGenerator deployGenerator) {
        this._appDeploy.remove(deployGenerator);
        deployGenerator.destroy();
    }

    void removeWebApp(WebAppController entry) {
        this._appDeploy.remove(entry.getContextPath());
        this.clearCache();
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._webAppDefaultList.add(init);
    }

    public ArrayList<WebAppConfig> getWebAppDefaultList() {
        return this._webAppDefaultList;
    }

    public WebAppExpandDeployGenerator createWarDeploy() {
        String stage = this.getServer().getStage();
        String host = this.getHost().getIdTail();
        String id = stage + "/webapp/" + host;
        return new WebAppExpandDeployGenerator(id, this._appDeploySpi, this);
    }

    public WebAppExpandDeployGenerator createWebAppDeploy() {
        return this.createWarDeploy();
    }

    public void addWebAppDeploy(WebAppExpandDeployGenerator deploy) throws ConfigException {
        this.addWarDeploy(deploy);
    }

    public void addWarDeploy(WebAppExpandDeployGenerator webAppDeploy) throws ConfigException {
        assert (webAppDeploy.getContainer() == this);
        if (!this._hasWarGenerator) {
            this._hasWarGenerator = true;
            this._warGenerator = webAppDeploy;
        }
        this._appDeploy.add(webAppDeploy);
    }

    public void addDeploy(DeployGenerator<WebAppController> deploy) throws ConfigException {
        if (deploy instanceof WebAppExpandDeployGenerator) {
            this.addWebAppDeploy((WebAppExpandDeployGenerator)deploy);
        } else {
            this._appDeploy.add(deploy);
        }
    }

    public void removeWebAppDeploy(DeployGenerator<WebAppController> deploy) {
        this._appDeploy.remove(deploy);
    }

    public void updateWebAppDeploy(String name) throws Throwable {
        Throwable configException;
        this._appDeploy.update();
        WebAppController controller = this._appDeploy.update(name);
        this.clearCache();
        if (controller != null && (configException = controller.getConfigException()) != null) {
            throw configException;
        }
    }

    public void addApplication(EarConfig config) {
        EarSingleDeployGenerator deploy = new EarSingleDeployGenerator(this._earDeploy, this, config);
        this._earDeploy.add(deploy);
    }

    public void updateEarDeploy(String name) throws Throwable {
        this.clearCache();
        this._earDeploy.update();
        EarDeployController entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
            Throwable configException = entry.getConfigException();
            if (configException != null) {
                throw configException;
            }
        }
        this.clearCache();
    }

    public void expandEarDeploy(String name) {
        this.clearCache();
        this._earDeploy.update();
        EarDeployController entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
        }
        this.clearCache();
    }

    public void startEarDeploy(String name) {
        this.clearCache();
        this._earDeploy.update();
        EarDeployController entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
        }
        this.clearCache();
    }

    public void addEarDefault(EarConfig config) {
        this._earDefaultList.add(config);
    }

    public ArrayList<EarConfig> getEarDefaultList() {
        return this._earDefaultList;
    }

    public EarDeployGenerator createEarDeploy() throws Exception {
        String id = this.getStageTag() + "/entapp/" + this.getHost().getIdTail();
        return new EarDeployGenerator(id, this._earDeploy, this);
    }

    public void addEarDeploy(EarDeployGenerator earDeploy) throws Exception {
        this._earDeploy.add(earDeploy);
        this._appDeploy.add(new WebAppEarDeployGenerator(this._appDeploySpi, this, earDeploy));
    }

    public String getURL() {
        return this._host.getURL();
    }

    public String getId() {
        return this.getURL();
    }

    public String getHostName() {
        return "";
    }

    public void setWarDir(Path warDir) throws ConfigException {
        this.getWarGenerator().setPath(warDir);
        if (!this._hasWarGenerator) {
            this._hasWarGenerator = true;
            this.addWebAppDeploy(this.getWarGenerator());
        }
    }

    public Path getWarDir() {
        return this.getWarGenerator().getPath();
    }

    public void setWarExpandDir(Path warDir) {
        this.getWarGenerator().setExpandDirectory(warDir);
    }

    public Path getWarExpandDir() {
        return this.getWarGenerator().getExpandDirectory();
    }

    private WebAppExpandDeployGenerator getWarGenerator() {
        if (this._warGenerator == null) {
            String id = this.getStageTag() + "/webapp/" + this.getHost().getIdTail();
            this._warGenerator = new WebAppExpandDeployGenerator(id, this._appDeploySpi, this);
        }
        return this._warGenerator;
    }

    public void start() {
        try {
            if (this._accessLog != null) {
                this._accessLog.start();
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        try {
            this._appDeploy.start();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public void clearCache() {
        this._uriToAppCache = new LruCache(8192);
        this._server.clearCache();
    }

    @Override
    public Invocation buildInvocation(Invocation invocation) throws ConfigException {
        ContextFilterChain contextChain;
        int code;
        boolean isAlwaysModified;
        Object chain;
        if (this._configException != null) {
            ExceptionFilterChain chain2 = new ExceptionFilterChain(this._configException);
            invocation.setFilterChain(chain2);
            invocation.setDependency(AlwaysModified.create());
            return invocation;
        }
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            log.fine(this + " container is not active");
            int code2 = 503;
            ErrorFilterChain chain3 = new ErrorFilterChain(code2);
            invocation.setFilterChain(chain3);
            invocation.setWebApp(this.getErrorWebApp());
            invocation.setDependency(AlwaysModified.create());
            return invocation;
        }
        WebAppController controller = this.getWebAppController(invocation);
        WebApp webApp = this.getWebApp(invocation, controller, true);
        if (webApp != null) {
            boolean isTop = this._rewriteDispatch == null;
            invocation = webApp.buildInvocation(invocation, isTop);
            chain = invocation.getFilterChain();
            isAlwaysModified = false;
        } else if (controller != null) {
            code = 503;
            chain = new ErrorFilterChain(code);
            contextChain = new ContextFilterChain((FilterChain)chain);
            contextChain.setErrorPageManager(this.getErrorPageManager());
            chain = contextChain;
            invocation.setFilterChain(contextChain);
            isAlwaysModified = true;
        } else {
            code = 404;
            chain = new ErrorFilterChain(code);
            contextChain = new ContextFilterChain((FilterChain)chain);
            contextChain.setErrorPageManager(this.getErrorPageManager());
            chain = contextChain;
            invocation.setFilterChain(contextChain);
            isAlwaysModified = true;
        }
        if (this._rewriteDispatch != null) {
            String queryString;
            String uri = invocation.getURI();
            FilterChain rewriteChain = this._rewriteDispatch.map(DispatcherType.REQUEST, uri, queryString = invocation.getQueryString(), (FilterChain)chain);
            if (rewriteChain != chain) {
                WebApp rootWebApp = this.findWebAppByURI(uri);
                if (rootWebApp == null) {
                    rootWebApp = this.getErrorWebApp();
                }
                invocation.setWebApp(rootWebApp);
                isAlwaysModified = false;
            }
            if ((webApp = invocation.getWebApp()) != null) {
                rewriteChain = webApp.createWebAppFilterChain(rewriteChain, invocation, true);
                invocation.setFilterChain(rewriteChain);
            }
        }
        if (isAlwaysModified) {
            invocation.setDependency(AlwaysModified.create());
        }
        return invocation;
    }

    public RequestDispatcher getRequestDispatcher(String url) {
        Invocation dispatchInvocation;
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url `{0}' must be absolute", (Object)url));
        }
        Invocation includeInvocation = new Invocation();
        Invocation forwardInvocation = new Invocation();
        Invocation errorInvocation = new Invocation();
        Invocation requestInvocation = dispatchInvocation = new Invocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = url;
        try {
            decoder.splitQuery(includeInvocation, rawURI);
            decoder.splitQuery(forwardInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            decoder.splitQuery(dispatchInvocation, rawURI);
            this.buildIncludeInvocation(includeInvocation);
            this.buildForwardInvocation(forwardInvocation);
            this.buildErrorInvocation(errorInvocation);
            this.buildDispatchInvocation(dispatchInvocation);
            WebAppController controller = this.getWebAppController(includeInvocation);
            WebApp webApp = this.getWebApp(includeInvocation, controller, false);
            RequestDispatcherImpl disp = new RequestDispatcherImpl(includeInvocation, forwardInvocation, errorInvocation, dispatchInvocation, requestInvocation, webApp);
            return disp;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public void buildIncludeInvocation(Invocation invocation) throws ServletException {
        WebApp webApp = this.buildSubInvocation(invocation);
        if (webApp != null) {
            webApp.buildIncludeInvocation(invocation);
        }
    }

    public void buildForwardInvocation(Invocation invocation) throws ServletException {
        WebApp webApp = this.buildSubInvocation(invocation);
        if (webApp != null) {
            webApp.buildForwardInvocation(invocation);
        }
    }

    public void buildErrorInvocation(Invocation invocation) throws ServletException {
        WebApp webApp = this.buildSubInvocation(invocation);
        if (webApp != null) {
            webApp.buildErrorInvocation(invocation);
        }
    }

    public void buildLoginInvocation(Invocation invocation) throws ServletException {
        WebApp app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildErrorInvocation(invocation);
        }
    }

    public void buildDispatchInvocation(Invocation invocation) throws ServletException {
        WebApp app = this.buildSubInvocation(invocation);
        if (app != null) {
            app.buildDispatchInvocation(invocation);
        }
    }

    private WebApp buildSubInvocation(Invocation invocation) {
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            UnavailableException e = new UnavailableException(invocation.getURI());
            ExceptionFilterChain chain = new ExceptionFilterChain(e);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return null;
        }
        WebAppController appController = this.getWebAppController(invocation);
        if (appController == null) {
            String url = invocation.getURI();
            FileNotFoundException e = new FileNotFoundException(url);
            ExceptionFilterChain chain = new ExceptionFilterChain(e);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return null;
        }
        WebApp webApp = (WebApp)appController.subrequest();
        if (webApp == null) {
            UnavailableException e = new UnavailableException(invocation.getURI());
            ExceptionFilterChain chain = new ExceptionFilterChain(e);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return null;
        }
        return webApp;
    }

    private WebApp getWebApp(Invocation invocation, WebAppController controller, boolean isTopRequest) {
        try {
            if (controller != null) {
                WebApp webApp = isTopRequest ? (WebApp)controller.request() : (WebApp)controller.subrequest();
                if (webApp == null) {
                    return null;
                }
                invocation.setWebApp(webApp);
                return webApp;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    protected WebAppController getWebAppController(Invocation invocation) {
        String invocationURI = invocation.getURI();
        WebAppUriMap entry = this.findEntryByURI(invocation.getURI());
        if (entry == null) {
            return null;
        }
        WebAppController controller = entry.getController();
        String contextPath = controller.getContextPath(invocationURI);
        invocation.setContextPath(contextPath);
        String contextUri = invocationURI.substring(contextPath.length());
        invocation.setContextURI(contextUri);
        return entry.getController();
    }

    public WebApp findWebAppByURI(String uri) {
        WebAppUriMap entry = this.findEntryByURI(uri);
        if (entry != null) {
            return (WebApp)entry.getController().request();
        }
        return null;
    }

    public WebApp findSubWebAppByURI(String uri) {
        WebAppController controller = this.findByURI(uri);
        if (controller != null) {
            return (WebApp)controller.subrequest();
        }
        return null;
    }

    public WebAppController findByURI(String uri) {
        WebAppUriMap entry = this.findEntryByURI(uri);
        if (entry != null) {
            return entry.getController();
        }
        return null;
    }

    public WebAppUriMap findEntryByURI(String uri) {
        WebAppUriMap entry;
        if (this._appDeploy.isModified()) {
            this._appDeploy.logModified(log);
            this._uriToAppCache.clear();
        }
        if ((entry = this._uriToAppCache.get(uri)) != null) {
            return entry;
        }
        String cleanUri = uri;
        if (CauchoSystem.isCaseInsensitive()) {
            cleanUri = cleanUri.toLowerCase(Locale.ENGLISH);
        }
        try {
            cleanUri = this.getInvocationDecoder().normalizeUri(cleanUri);
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        entry = this.findByURIImpl(cleanUri);
        this._uriToAppCache.put(uri, entry);
        return entry;
    }

    private WebAppUriMap findByURIImpl(String subURI) {
        WebAppController controller;
        WebAppUriMap entry = this._uriToAppCache.get(subURI);
        if (entry != null) {
            return entry;
        }
        int length = subURI.length();
        int p = subURI.lastIndexOf(47);
        if ((p < 0 || p < length - 1) && (controller = this._appDeploy.findController(subURI)) != null) {
            entry = new WebAppUriMap(subURI, controller);
            this._uriToAppCache.put(subURI, entry);
            return entry;
        }
        if (p >= 0 && (entry = this.findByURIImpl(subURI.substring(0, p))) != null) {
            this._uriToAppCache.put(subURI, entry);
        }
        return entry;
    }

    public DeployContainerApi<WebAppController> getWebAppDeployContainer() {
        return this._appDeploy;
    }

    public WebAppController findController(String subURI) {
        return this._appDeploy.findController(subURI);
    }

    public WebAppController[] getWebAppList() {
        return (WebAppController[])this._appDeploy.getControllers();
    }

    public DeployContainerApi<EarDeployController> getEarDeployContainer() {
        return this._earDeploy;
    }

    public EarDeployController[] getEntAppList() {
        return (EarDeployController[])this._earDeploy.getControllers();
    }

    public final boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public final boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean stop() {
        this._earDeploy.stop();
        this._appDeploy.stop();
        if (this._errorWebApp != null) {
            this._errorWebApp.stop();
        }
        return true;
    }

    public void destroy() {
        this._earDeploy.destroy();
        this._appDeploy.destroy();
        if (this._errorWebApp != null) {
            this._errorWebApp.destroy();
        }
        AbstractAccessLog accessLog = this._accessLog;
        this._accessLog = null;
        if (accessLog != null) {
            try {
                accessLog.destroy();
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp getErrorWebApp() {
        WebApp defaultWebApp;
        if (this._errorWebApp == null && (defaultWebApp = this.findWebAppByURI("/")) != null) {
            return defaultWebApp;
        }
        WebAppContainer webAppContainer = this;
        synchronized (webAppContainer) {
            if (this._errorWebApp == null) {
                this._errorWebApp = this.createErrorWebApp();
            }
            return this._errorWebApp;
        }
    }

    private WebApp createErrorWebApp() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Path errorRoot = new MemoryPath().lookup("/error-root");
            errorRoot.mkdirs();
            String id = "error/webapp/" + this.getHostName() + "/error";
            UnknownWebAppController webAppController = new UnknownWebAppController(id, errorRoot, this);
            webAppController.init();
            webAppController.startOnInit();
            WebApp webApp = (WebApp)webAppController.request();
            return webApp;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    @Override
    public void classLoaderInit(DynamicClassLoader loader) {
    }

    @Override
    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.destroy();
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._classLoader.getId() + "]";
    }

    static class WebAppUriMap {
        private final String _contextPath;
        private final WebAppController _webAppController;

        WebAppUriMap(String contextPath, WebAppController webAppController) {
            this._contextPath = contextPath;
            this._webAppController = webAppController;
        }

        String getContextPath() {
            return this._contextPath;
        }

        WebAppController getController() {
            return this._webAppController;
        }
    }
}

