/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.Config;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.InjectManager;
import com.caucho.env.deploy.DeployConfig;
import com.caucho.env.deploy.DeployControllerAdmin;
import com.caucho.env.deploy.EnvironmentDeployController;
import com.caucho.inject.Module;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.host.Host;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppAdmin;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

@Module
public class WebAppController
extends EnvironmentDeployController<WebApp, WebAppConfig> {
    private static final Logger log = Logger.getLogger(WebAppController.class.getName());
    private final WebAppContainer _container;
    private WebAppController _parent;
    private String _idTail;
    private String _contextPath;
    private String _version = "";
    private WebAppController _oldWebAppController;
    private long _oldWebAppExpireTime;
    private String _warName;
    private ArrayList<String> _regexpValues;
    private boolean _isInheritSession;
    private boolean _isDynamicDeploy;
    private ArrayList<Path> _dependPathList = new ArrayList();
    private String _sourceType = "unknown";
    private final Object _statisticsLock = new Object();
    private volatile long _lifetimeConnectionCount;
    private volatile long _lifetimeConnectionTime;
    private volatile long _lifetimeReadBytes;
    private volatile long _lifetimeWriteBytes;
    private volatile long _lifetimeClientDisconnectCount;
    private WebAppAdmin _admin;

    public WebAppController(String id, Path rootDirectory, WebAppContainer container) {
        this(id, rootDirectory, container, "/");
    }

    public WebAppController(Path rootDirectory, WebAppContainer container, String contextPath) {
        this(WebAppController.calculateId(container, contextPath), rootDirectory, container, contextPath);
    }

    public WebAppController(String id, Path rootDirectory, WebAppContainer container, String contextPath) {
        super(id, rootDirectory);
        this._container = container;
        if (container == null) {
            throw new NullPointerException();
        }
        if (container.getHost() == null) {
            throw new NullPointerException();
        }
        this._contextPath = contextPath;
        this._idTail = WebAppController.calculateIdTail(this.getId());
    }

    private static String calculateIdTail(String id) {
        int p1 = id.indexOf(47);
        int p2 = id.indexOf(47, p1 + 1);
        int p3 = id.indexOf(47, p2 + 1);
        return id.substring(p3);
    }

    private static String calculateId(WebAppContainer container, String contextPath) {
        if (contextPath.equals("") || contextPath.equals("/")) {
            contextPath = "/ROOT";
        }
        String stage = container.getServer().getStage();
        String hostId = container.getHost().getIdTail();
        return stage + "/webapp/" + hostId + contextPath;
    }

    public String getName() {
        return this._idTail;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    protected boolean isVersioning() {
        return false;
    }

    public String getContextPath(String uri) {
        if (this.getConfig() == null) {
            return this.getContextPath();
        }
        String contextPath = ((WebAppConfig)this.getConfig()).getContextPath(uri);
        if (contextPath != null) {
            return contextPath;
        }
        return this._contextPath;
    }

    public void setWarName(String warName) {
        this._warName = warName;
    }

    public String getWarName() {
        return this._warName;
    }

    public String getURL() {
        return this.getHost().getURL() + this._contextPath;
    }

    public WebAppController getParent() {
        return this._parent;
    }

    public WebAppContainer getContainer() {
        return this._container;
    }

    public ServletService getWebManager() {
        return this._container.getServer();
    }

    public void setParentWebApp(WebAppController parent) {
        this._parent = parent;
    }

    public Host getHost() {
        return this._container.getHost();
    }

    public String getSourceType() {
        return this._sourceType;
    }

    public void setSourceType(String type) {
        this._sourceType = type;
    }

    public void setRegexpValues(ArrayList<String> values) {
        this._regexpValues = values;
    }

    public boolean isInheritSession() {
        return this._isInheritSession;
    }

    public void setInheritSession(boolean inheritSession) {
        this._isInheritSession = inheritSession;
    }

    public WebApp getWebApp() {
        return (WebApp)this.getDeployInstance();
    }

    public void setDynamicDeploy(boolean isDynamicDeploy) {
        this._isDynamicDeploy = isDynamicDeploy;
    }

    public boolean isDynamicDeploy() {
        return this._isDynamicDeploy;
    }

    @Override
    protected String getMBeanTypeName() {
        return "WebApp";
    }

    @Override
    protected String getMBeanId() {
        String name = this.getName();
        if (name.equals("/ROOT")) {
            return "/";
        }
        return name;
    }

    protected void setVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersionAlias(boolean isVersionAlias) {
    }

    public boolean isVersionAlias() {
        return false;
    }

    public void setOldWebApp(WebAppController oldWebApp, long expireTime) {
        this._oldWebAppController = oldWebApp;
        this._oldWebAppExpireTime = expireTime;
        WebApp webApp = (WebApp)this.getDeployInstance();
        if (webApp != null) {
            webApp.setOldWebApp((WebApp)oldWebApp.request(), expireTime);
        }
    }

    @Override
    protected DeployControllerAdmin<?> getDeployAdmin() {
        return this._admin;
    }

    @Override
    protected void initEnd() {
        if (!this.getId().startsWith("error/") && !this.isVersioning()) {
            this._admin = new WebAppAdmin(this);
        }
        super.initEnd();
    }

    public WebAppAdmin getAdmin() {
        return this._admin;
    }

    @Override
    public boolean isNameMatch(String url) {
        if (CauchoSystem.isCaseInsensitive() ? url.equalsIgnoreCase(this._contextPath) : url.equals(this._contextPath)) {
            return true;
        }
        if (this.getConfig() != null) {
            return ((WebAppConfig)this.getConfig()).isUrlMatch(url);
        }
        return false;
    }

    public Var getVar() {
        return new Var();
    }

    protected void protectedWebApp() throws Exception {
        Path root = this.getRootDirectory();
        root.lookup("WEB-INF").chmod(488);
        root.lookup("META-INF").chmod(488);
    }

    @Override
    protected void addDependencies() {
        super.addDependencies();
    }

    public void addDepend(Path path) {
        this._dependPathList.add(path);
    }

    @Override
    protected void initBegin() {
        super.initBegin();
    }

    @Override
    protected void fillInitList(ArrayList<DeployConfig> initList) {
        if (this._container != null) {
            for (WebAppConfig config : this._container.getWebAppDefaultList()) {
                if (config.getPrologue() == null) continue;
                initList.add(config.getPrologue());
            }
            for (WebAppConfig config : this._container.getWebAppDefaultList()) {
                initList.add(config);
            }
        }
        super.fillInitList(initList);
    }

    @Override
    protected WebApp instantiateDeployInstance() {
        return new WebApp(this);
    }

    @Override
    protected void configureInstanceVariables(WebApp webApp) {
        InjectManager beanManager = InjectManager.create();
        BeanBuilder<WebApp> factory = beanManager.createBeanFactory(WebApp.class);
        factory.type(new Type[]{WebApp.class});
        factory.type(new Type[]{ServletContext.class});
        beanManager.addBean(factory.singleton(webApp));
        Config.setProperty("webApp", this.getVar());
        Config.setProperty("app", this.getVar());
        webApp.setRegexp(this._regexpValues);
        webApp.setDynamicDeploy(this.isDynamicDeploy());
        if (this._oldWebAppController != null && CurrentTime.getCurrentTime() < this._oldWebAppExpireTime) {
            webApp.setOldWebApp((WebApp)this._oldWebAppController.request(), this._oldWebAppExpireTime);
        }
        super.configureInstanceVariables(webApp);
    }

    @Override
    protected void onStartComplete() {
        super.onStartComplete();
        this.clearCache();
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.clearCache();
    }

    public void clearCache() {
        this._container.clearCache();
    }

    @Override
    public boolean destroy() {
        return super.destroy();
    }

    @Override
    protected void extendJMXContext(Map<String, String> context) {
        context.put("WebApp", this.getMBeanId());
    }

    @Override
    protected void removeExpandFile(Path path, String relPath) throws IOException {
        if (relPath.equals("./WEB-INF/resin-web.xml")) {
            return;
        }
        super.removeExpandFile(path, relPath);
    }

    public long getLifetimeConnectionCount() {
        return this._lifetimeConnectionCount;
    }

    public long getLifetimeConnectionTime() {
        return this._lifetimeConnectionTime;
    }

    public long getLifetimeReadBytes() {
        return this._lifetimeReadBytes;
    }

    public long getLifetimeWriteBytes() {
        return this._lifetimeWriteBytes;
    }

    public long getLifetimeClientDisconnectCount() {
        return this._lifetimeClientDisconnectCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatistics(long milliseconds, int readBytes, int writeBytes, boolean isClientDisconnect) {
        Object object = this._statisticsLock;
        synchronized (object) {
            ++this._lifetimeConnectionCount;
            this._lifetimeConnectionTime += milliseconds;
            this._lifetimeReadBytes += (long)readBytes;
            this._lifetimeWriteBytes += (long)writeBytes;
            if (isClientDisconnect) {
                ++this._lifetimeClientDisconnectCount;
            }
        }
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public String toString() {
        if (CurrentTime.isTest()) {
            return this.getClass().getSimpleName() + "[" + this.getId() + "]";
        }
        return this.getClass().getSimpleName() + "$" + System.identityHashCode(this) + "[" + this.getId() + "]";
    }

    public class Var {
        public String getUrl() {
            return WebAppController.this.getURL();
        }

        public String getId() {
            String id = WebAppController.this.getId();
            if (id != null) {
                return id;
            }
            return WebAppController.this.getContextPath();
        }

        public String getName() {
            String name = WebAppController.this.getWarName() != null ? WebAppController.this.getWarName() : this.getContextPath();
            if (name.startsWith("/")) {
                return name;
            }
            return "/" + name;
        }

        public Path getAppDir() {
            return WebAppController.this.getRootDirectory();
        }

        public Path getDocDir() {
            return WebAppController.this.getRootDirectory();
        }

        public Path getRoot() {
            return WebAppController.this.getRootDirectory();
        }

        public Path getRootDir() {
            return WebAppController.this.getRootDirectory();
        }

        public String getContextPath() {
            return WebAppController.this.getContextPath();
        }

        public ArrayList<String> getRegexp() {
            return WebAppController.this._regexpValues;
        }

        public String getVersion() {
            return WebAppController.this._version;
        }

        public String toString() {
            return "WebApp[" + this.getId() + "]";
        }
    }
}

