/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.make.CachedDependency;
import com.caucho.util.CacheListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Depend;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.StreamImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Jar
implements CacheListener {
    private static final Logger log = Logger.getLogger(Jar.class.getName());
    private static final L10N L = new L10N(Jar.class);
    private static LruCache<Path, Jar> _jarCache;
    private static EnvironmentLocal<Integer> _jarSize;
    private static ZipEntry NULL_ZIP;
    private LruCache<String, ZipEntry> _zipEntryCache = new LruCache(64);
    private Path _backing;
    private boolean _backingIsFile;
    private AtomicInteger _changeSequence = new AtomicInteger();
    private JarDepend _depend;
    private long _lastModified;
    private long _length;
    private long _lastTime;
    private final AtomicReference<ZipFile> _zipFileRef = new AtomicReference();
    private Boolean _isSigned;
    private Certificate[] _certificates;

    private Jar(Path backing) {
        if (backing instanceof JarPath) {
            throw new IllegalStateException();
        }
        this._backing = backing;
        this._backingIsFile = this._backing.getScheme().equals("file") && this._backing.canRead();
    }

    static Jar create(Path backing) {
        Jar jar;
        if (_jarCache == null) {
            int size = 256;
            Integer iSize = _jarSize.get();
            if (iSize != null) {
                size = iSize;
            }
            _jarCache = new LruCache(size);
        }
        if ((jar = _jarCache.get(backing)) == null) {
            jar = new Jar(backing);
            jar = _jarCache.putIfNew(backing, jar);
        }
        return jar;
    }

    static Jar getJar(Path backing) {
        if (_jarCache != null) {
            Jar jar = _jarCache.get(backing);
            return jar;
        }
        return null;
    }

    public static PersistentDependency createDepend(Path backing) {
        Jar jar = Jar.create(backing);
        return jar.getDepend();
    }

    public static PersistentDependency createDepend(Path backing, long digest) {
        Jar jar = Jar.create(backing);
        return new JarDigestDepend(jar.getJarDepend(), digest);
    }

    Path getBacking() {
        return this._backing;
    }

    public PersistentDependency getDepend() {
        return this.getJarDepend();
    }

    private JarDepend getJarDepend() {
        if (this._depend == null || this._depend.isModified()) {
            this._depend = new JarDepend(new Depend(this.getBacking()));
        }
        return this._depend;
    }

    public int getChangeSequence() {
        return this._changeSequence.get();
    }

    private boolean isSigned() {
        Boolean isSigned = this._isSigned;
        if (isSigned != null) {
            return isSigned;
        }
        try {
            Manifest manifest = this.getManifest();
            if (manifest == null) {
                this._isSigned = Boolean.FALSE;
                return false;
            }
            Map<String, Attributes> entries = manifest.getEntries();
            if (entries == null) {
                this._isSigned = Boolean.FALSE;
                return false;
            }
            for (Attributes attr : entries.values()) {
                for (Object key : attr.keySet()) {
                    String keyString = String.valueOf(key);
                    if (!keyString.contains("Digest")) continue;
                    this._isSigned = Boolean.TRUE;
                    return true;
                }
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this._isSigned = Boolean.FALSE;
        return false;
    }

    public Manifest getManifest() throws IOException {
        Manifest manifest;
        JarFile jarFile = this.getJarFile();
        try {
            manifest = jarFile == null ? null : jarFile.getManifest();
        }
        finally {
            this.closeJarFile(jarFile);
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate[] getCertificates(String path) {
        if (!this.isSigned()) {
            return null;
        }
        if (this._certificates != null) {
            return this._certificates.length > 0 ? this._certificates : null;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        try {
            if (!this._backing.canRead()) {
                Certificate[] certificateArray = null;
                return certificateArray;
            }
            JarFile jarFile = this.getJarFile();
            InputStream is = null;
            try {
                JarEntry entry = jarFile.getJarEntry(path);
                if (entry != null) {
                    is = jarFile.getInputStream(entry);
                    while (is.skip(65536L) > 0L) {
                    }
                    is.close();
                    this._certificates = entry.getCertificates();
                }
            }
            finally {
                this.closeJarFile(jarFile);
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            Certificate[] certificateArray = null;
            return certificateArray;
        }
        finally {
            if (this._certificates == null) {
                this._certificates = new Certificate[0];
            }
        }
        return this._certificates;
    }

    public boolean exists(String path) {
        try {
            ZipEntry entry = this.getZipEntry(path);
            return entry != null;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean isDirectory(String path) {
        try {
            ZipEntry entry = this.getZipEntry(path);
            return entry != null && entry.isDirectory();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean isFile(String path) {
        try {
            ZipEntry entry = this.getZipEntry(path);
            return entry != null && !entry.isDirectory();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public long getLastModified(String path) {
        try {
            ZipEntry entry = this.getZipEntry(path);
            return entry != null ? entry.getTime() : -1L;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return -1L;
        }
    }

    public long getLength(String path) {
        try {
            ZipEntry entry = this.getZipEntry(path);
            long length = entry != null ? entry.getSize() : -1L;
            return length;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return -1L;
        }
    }

    public boolean canRead(String path) {
        try {
            ZipEntry entry = this.getZipEntry(path);
            return entry != null && !entry.isDirectory();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean canWrite(String path) {
        return false;
    }

    public String[] list(String path) throws IOException {
        return new String[0];
    }

    public ZipStreamImpl openReadImpl(Path path) throws IOException {
        String pathName = path.getPath();
        return this.openReadImpl(pathName);
    }

    public ZipStreamImpl openReadImpl(String pathName) throws IOException {
        if (pathName.length() > 0 && pathName.charAt(0) == '/') {
            pathName = pathName.substring(1);
        }
        ZipStreamImpl zipIs = null;
        ZipFile zipFile = this.getZipFile();
        try {
            ZipEntry entry = zipFile.getEntry(pathName);
            if (entry == null) {
                pathName = "/" + pathName;
                entry = zipFile.getEntry(pathName);
            }
            if (entry != null) {
                InputStream is = zipFile.getInputStream(entry);
                ZipStreamImpl zipStreamImpl = zipIs = new ZipStreamImpl(zipFile, entry, is, pathName);
                return zipStreamImpl;
            }
            throw new FileNotFoundException(pathName);
        }
        finally {
            if (zipIs == null) {
                zipFile.close();
            }
        }
    }

    public void clearCache() {
        ZipFile zipFile = this._zipFileRef.getAndSet(null);
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ZipEntry getZipEntry(String path) throws IOException {
        ZipEntry entry = this._zipEntryCache.get(path);
        if (entry != null && this.isCacheValid()) {
            if (entry == NULL_ZIP) {
                return null;
            }
            return entry;
        }
        entry = this.getZipEntryImpl(path);
        if (entry != null) {
            this._zipEntryCache.put(path, entry);
        } else {
            this._zipEntryCache.put(path, NULL_ZIP);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipEntry getZipEntryImpl(String path) throws IOException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        boolean isValid = false;
        ZipFile zipFile = this.getZipFile();
        try {
            if (zipFile != null) {
                ZipEntry entry = zipFile.getEntry(path);
                isValid = true;
                ZipEntry zipEntry = entry;
                return zipEntry;
            }
            ZipEntry zipEntry = null;
            return zipEntry;
        }
        finally {
            if (isValid) {
                this.closeZipFile(zipFile);
            } else if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private JarFile getJarFile() throws IOException {
        JarFile jarFile = null;
        this.isCacheValid();
        if (!this._backingIsFile) {
            throw new FileNotFoundException(this._backing.getNativePath());
        }
        try {
            jarFile = new JarFile(this._backing.getNativePath());
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("Error opening jar file '{0}'", (Object)this._backing.getNativePath()));
            }
            throw ex;
        }
        return jarFile;
    }

    private void closeJarFile(JarFile jarFile) {
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public ZipFile getZipFile() throws IOException {
        this.isCacheValid();
        ZipFile zipFile = this._zipFileRef.getAndSet(null);
        if (zipFile != null) {
            return zipFile;
        }
        if (this._backingIsFile) {
            try {
                zipFile = new ZipFile(this._backing.getNativePath());
            }
            catch (IOException ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, L.l("Error opening jar file '{0}'", (Object)this._backing.getNativePath()));
                }
                throw ex;
            }
            this.getLastModifiedImpl();
        }
        return zipFile;
    }

    public void closeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        if (this._zipFileRef.compareAndSet(null, zipFile)) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private long getLastModifiedImpl() {
        this.isCacheValid();
        return this._lastModified;
    }

    private boolean isCacheValid() {
        long now = CurrentTime.getCurrentTime();
        if (now - this._lastTime < 100L && !CurrentTime.isTest()) {
            return true;
        }
        long oldLastModified = this._lastModified;
        long oldLength = this._length;
        long newLastModified = this._backing.getLastModified();
        long newLength = this._backing.getLength();
        this._lastTime = now;
        if (newLastModified == oldLastModified && newLength == oldLength) {
            this._lastTime = now;
            return true;
        }
        this._changeSequence.incrementAndGet();
        this.clearCache();
        this._depend = null;
        this._isSigned = null;
        this._zipEntryCache.clear();
        this._lastModified = newLastModified;
        this._length = newLength;
        this._lastTime = now;
        return false;
    }

    public void close() {
        this.removeEvent();
    }

    @Override
    public void removeEvent() {
        this.clearCache();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Jar jar = (Jar)o;
        return this._backing.equals(jar._backing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJarCache() {
        LruCache<Path, Jar> jarCache = _jarCache;
        if (jarCache == null) {
            return;
        }
        ArrayList<Jar> jars = new ArrayList<Jar>();
        LruCache<Path, Jar> lruCache = jarCache;
        synchronized (lruCache) {
            Iterator<Jar> iter = jarCache.values();
            while (iter.hasNext()) {
                jars.add(iter.next());
            }
        }
        for (int i = 0; i < jars.size(); ++i) {
            Jar jar = (Jar)jars.get(i);
            if (jar == null) continue;
            jar.clearCache();
        }
    }

    public String toString() {
        return this._backing.toString();
    }

    static {
        _jarSize = new EnvironmentLocal("caucho.vfs.jar-size");
        NULL_ZIP = new ZipEntry("null");
    }

    static class JarDigestDepend
    implements PersistentDependency {
        private JarDepend _jarDepend;
        private Depend _depend;
        private boolean _isDigestModified;

        JarDigestDepend(JarDepend jarDepend, long digest) {
            this._jarDepend = jarDepend;
            this._depend = jarDepend.getDepend();
            this._isDigestModified = this._depend.getDigest() != digest;
        }

        @Override
        public boolean isModified() {
            return this._isDigestModified || this._jarDepend.isModified();
        }

        @Override
        public boolean logModified(Logger log) {
            return this._depend.logModified(log) || this._jarDepend.logModified(log);
        }

        @Override
        public String getJavaCreateString() {
            String sourcePath = this._depend.getPath().getPath();
            long digest = this._depend.getDigest();
            return "new com.caucho.vfs.Jar.createDepend(com.caucho.vfs.Vfs.lookup(\"" + sourcePath + "\"), " + digest + "L)";
        }
    }

    class JarDepend
    extends CachedDependency
    implements PersistentDependency {
        private Depend _depend;
        private boolean _isDigestModified;

        JarDepend(Depend depend) {
            this._depend = depend;
        }

        JarDepend(Depend depend, long digest) {
            this._depend = depend;
            this._isDigestModified = this._depend.getDigest() != digest;
        }

        Depend getDepend() {
            return this._depend;
        }

        @Override
        public boolean isModifiedImpl() {
            if (this._isDigestModified || this._depend.isModified()) {
                Jar.this._changeSequence.incrementAndGet();
                return true;
            }
            return false;
        }

        @Override
        public boolean logModified(Logger log) {
            return this._depend.logModified(log);
        }

        @Override
        public String getJavaCreateString() {
            String sourcePath = this._depend.getPath().getPath();
            long digest = this._depend.getDigest();
            return "new com.caucho.vfs.Jar.createDepend(com.caucho.vfs.Vfs.lookup(\"" + sourcePath + "\"), " + digest + "L)";
        }

        public String toString() {
            return "Jar$JarDepend[" + this._depend.getPath() + "]";
        }
    }

    public class ZipStreamImpl
    extends StreamImpl {
        private ZipFile _zipFile;
        private ZipEntry _zipEntry;
        private InputStream _zis;
        private String _pathName;

        ZipStreamImpl(ZipFile zipFile, ZipEntry zipEntry, InputStream zis, String pathName) {
            this._zipFile = zipFile;
            this._zipEntry = zipEntry;
            this._zis = zis;
        }

        public ZipEntry getZipEntry() {
            return this._zipEntry;
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public int getAvailable() throws IOException {
            InputStream zis = this._zis;
            if (zis == null) {
                return -1;
            }
            return this._zis.available();
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            InputStream zis = this._zis;
            if (zis == null) {
                return -1;
            }
            return zis.read(buf, off, len);
        }

        @Override
        public void close() throws IOException {
            ZipFile zipFile = this._zipFile;
            this._zipFile = null;
            InputStream zis = this._zis;
            this._zis = null;
            try {
                IoUtil.close(zis);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Jar.this.closeZipFile(zipFile);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

