/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class FilteredStreamReader
implements XMLStreamReader {
    private XMLStreamReader _reader;
    private StreamFilter _filter;

    public FilteredStreamReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        this._reader = reader;
        this._filter = filter;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        while (this._reader.hasNext()) {
            this._reader.nextTag();
            if (!this._filter.accept(this._reader)) continue;
            break;
        }
        return this._reader.getEventType();
    }

    @Override
    public int next() throws XMLStreamException {
        while (this._reader.hasNext()) {
            this._reader.next();
            if (!this._filter.accept(this._reader)) continue;
            break;
        }
        return this._reader.getEventType();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        do {
            if (this._reader.getEventType() == 8) {
                return false;
            }
            if (this._filter.accept(this._reader)) {
                return true;
            }
            this._reader.next();
        } while (this._reader.hasNext());
        return false;
    }

    @Override
    public void close() throws XMLStreamException {
        this._reader.close();
    }

    @Override
    public int getAttributeCount() {
        return this._reader.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this._reader.getAttributeLocalName(index);
    }

    @Override
    public QName getAttributeName(int index) {
        return this._reader.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this._reader.getAttributeNamespace(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this._reader.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this._reader.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this._reader.getAttributeValue(index);
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this._reader.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this._reader.getCharacterEncodingScheme();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this._reader.getElementText();
    }

    @Override
    public String getEncoding() {
        return this._reader.getEncoding();
    }

    @Override
    public int getEventType() {
        return this._reader.getEventType();
    }

    @Override
    public String getLocalName() {
        return this._reader.getLocalName();
    }

    @Override
    public Location getLocation() {
        return this._reader.getLocation();
    }

    @Override
    public QName getName() {
        return this._reader.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this._reader.getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        return this._reader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this._reader.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI() {
        return this._reader.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(int index) {
        return this._reader.getNamespaceURI(index);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this._reader.getNamespaceURI(prefix);
    }

    @Override
    public String getPIData() {
        return this._reader.getPIData();
    }

    @Override
    public String getPITarget() {
        return this._reader.getPITarget();
    }

    @Override
    public String getPrefix() {
        return this._reader.getPrefix();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this._reader.getProperty(name);
    }

    @Override
    public String getText() {
        return this._reader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this._reader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this._reader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextLength() {
        return this._reader.getTextLength();
    }

    @Override
    public int getTextStart() {
        return this._reader.getTextStart();
    }

    @Override
    public String getVersion() {
        return this._reader.getVersion();
    }

    @Override
    public boolean hasName() {
        return this._reader.hasName();
    }

    @Override
    public boolean hasText() {
        return this._reader.hasText();
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this._reader.isAttributeSpecified(index);
    }

    @Override
    public boolean isCharacters() {
        return this._reader.isCharacters();
    }

    @Override
    public boolean isEndElement() {
        return this._reader.isEndElement();
    }

    @Override
    public boolean isStandalone() {
        return this._reader.isStandalone();
    }

    @Override
    public boolean isStartElement() {
        return this._reader.isStartElement();
    }

    @Override
    public boolean isWhiteSpace() {
        return this._reader.isWhiteSpace();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this._reader.require(type, namespaceURI, localName);
    }

    @Override
    public boolean standaloneSet() {
        return this._reader.standaloneSet();
    }
}

