/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.TempCharBuffer;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml2.AbstractParser;
import com.caucho.xml2.DOMBuilder;
import com.caucho.xml2.DtdParser;
import com.caucho.xml2.ExtendedLocator;
import com.caucho.xml2.NamespaceContextImpl;
import com.caucho.xml2.QAttributes;
import com.caucho.xml2.QDocument;
import com.caucho.xml2.QDocumentType;
import com.caucho.xml2.QElementDef;
import com.caucho.xml2.QEntity;
import com.caucho.xml2.SaxIntern;
import com.caucho.xml2.XMLWriter;
import com.caucho.xml2.XmlChar;
import com.caucho.xml2.XmlParseException;
import com.caucho.xml2.readers.MacroReader;
import com.caucho.xml2.readers.Utf16Reader;
import com.caucho.xml2.readers.Utf8Reader;
import com.caucho.xml2.readers.XmlReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends AbstractParser {
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String XML = "http://www.w3.org/XML/1998/namespace";
    static final QName DOC_NAME = new QName("#document");
    static final QName TEXT_NAME = new QName("#text");
    static final QName WHITESPACE_NAME = new QName("#whitespace");
    private static final boolean[] XML_NAME_CHAR = new boolean[65536];
    QAttributes _attributes;
    QAttributes _nullAttributes;
    CharBuffer _text;
    CharBuffer _eltName;
    CharBuffer _cb;
    CharBuffer _buf = new CharBuffer();
    String _textFilename;
    int _textLine;
    TempCharBuffer _tempInputBuffer;
    char[] _inputBuffer;
    int _inputOffset;
    int _inputLength;
    char[] _textBuffer = new char[1024];
    int _textLength;
    int _textCapacity = this._textBuffer.length;
    boolean _isIgnorableWhitespace;
    char[] _valueBuffer = this._textBuffer;
    CharBuffer _name = new CharBuffer();
    CharBuffer _nameBuffer = new CharBuffer();
    MacroReader _macro = new MacroReader();
    int _macroIndex = 0;
    int _macroLength = 0;
    char[] _macroBuffer;
    int[] _elementLines = new int[64];
    int _elementTop;
    ArrayList<SaxIntern.Entry> _attrNames = new ArrayList();
    ArrayList<String> _attrValues = new ArrayList();
    ReadStream _is;
    XmlReader _reader;
    String _extPublicId;
    String _extSystemId;
    NamespaceContextImpl _namespace = new NamespaceContextImpl();
    SaxIntern _intern = new SaxIntern(this._namespace);
    QName _activeNode;
    QName _topNamespaceNode;
    boolean _isTagStart;
    boolean _stopOnIncludeEnd;
    boolean _hasTopElement;
    boolean _hasDoctype;
    Locator _locator = new LocatorImpl(this);

    public XmlParser() {
    }

    XmlParser(QDocumentType dtd) {
        super(dtd);
    }

    @Override
    void init() {
        super.init();
        this._attributes = new QAttributes();
        this._nullAttributes = new QAttributes();
        this._eltName = new CharBuffer();
        this._text = new CharBuffer();
        this._textLength = 0;
        this._isIgnorableWhitespace = true;
        this._elementTop = 0;
        this._elementLines[0] = 1;
        this._line = 1;
        this._dtd = null;
        this._isTagStart = false;
        this._stopOnIncludeEnd = false;
        this._extPublicId = null;
        this._extSystemId = null;
        this._filename = null;
        this._publicId = null;
        this._systemId = null;
        this._hasTopElement = false;
        this._hasDoctype = false;
        this._macroIndex = 0;
        this._macroLength = 0;
        this._reader = null;
    }

    @Override
    Document parseInt(ReadStream is) throws IOException, SAXException {
        this._tempInputBuffer = TempCharBuffer.allocate();
        this._inputBuffer = this._tempInputBuffer.getBuffer();
        this._inputOffset = 0;
        this._inputLength = 0;
        this._is = is;
        if (this._filename == null && this._systemId != null) {
            this._filename = this._systemId;
        } else if (this._filename == null) {
            this._filename = this._is.getUserPath();
        }
        if (this._systemId == null) {
            this._systemId = this._is.getPath().getURL();
            if ("null:".equals(this._systemId) || "string:".equals(this._systemId)) {
                this._systemId = "stream";
            }
        }
        if (this._filename == null) {
            this._filename = this._systemId;
        }
        if (this._filename == null) {
            this._filename = "stream";
        }
        if (this._dtd != null) {
            this._dtd.setSystemId(this._systemId);
        }
        if (this._builder != null) {
            if (!"string:".equals(this._systemId) && !"stream".equals(this._systemId)) {
                this._builder.setSystemId(this._systemId);
            }
            this._builder.setFilename(this._is.getPath().getURL());
        }
        if (this._contentHandler == null) {
            this._contentHandler = new DefaultHandler();
        }
        this._contentHandler.setDocumentLocator(this._locator);
        if (this._owner == null) {
            this._owner = new QDocument();
        }
        if (this._defaultEncoding != null) {
            this._owner.setAttribute("encoding", this._defaultEncoding);
        }
        this._owner.addDepend(is.getPath());
        this._activeNode = DOC_NAME;
        this._contentHandler.startDocument();
        this.parseXMLDeclaration(null);
        this.parseNode();
        if (!this._hasTopElement) {
            throw this.error(L.l("XML file has no top-element.  All well-formed XML files have a single top-level element."));
        }
        this._contentHandler.endDocument();
        QDocument owner = this._owner;
        this._owner = null;
        return owner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseNode() throws IOException, SAXException {
        char[] valueBuffer = this._valueBuffer;
        int valueLength = valueBuffer.length;
        int valueOffset = 0;
        boolean isWhitespace = true;
        char[] inputBuffer = this._inputBuffer;
        int inputLength = this._inputLength;
        int inputOffset = this._inputOffset;
        while (true) {
            int ch;
            if (inputOffset < inputLength) {
                ch = inputBuffer[inputOffset++];
            } else if (this.fillBuffer()) {
                inputBuffer = this._inputBuffer;
                inputOffset = this._inputOffset;
                inputLength = this._inputLength;
                ch = inputBuffer[inputOffset++];
            } else {
                if (valueOffset > 0) {
                    this.addText(valueBuffer, 0, valueOffset, isWhitespace);
                }
                this._inputOffset = inputOffset;
                this._inputLength = inputLength;
                this.close();
                return;
            }
            switch (ch) {
                case 10: {
                    ++this._line;
                    valueBuffer[valueOffset++] = (char)ch;
                    break;
                }
                case 9: 
                case 13: 
                case 32: {
                    valueBuffer[valueOffset++] = (char)ch;
                    break;
                }
                case 65535: {
                    if (valueOffset > 0) {
                        this.addText(valueBuffer, 0, valueOffset, isWhitespace);
                    }
                    this._inputOffset = inputOffset;
                    this._inputLength = inputLength;
                    return;
                }
                case 38: {
                    if (valueOffset > 0) {
                        this.addText(valueBuffer, 0, valueOffset, isWhitespace);
                    }
                    this._inputOffset = inputOffset;
                    this._inputLength = inputLength;
                    this.parseEntityReference();
                    inputOffset = this._inputOffset;
                    inputLength = this._inputOffset;
                    break;
                }
                case 60: {
                    SaxIntern.Entry entry;
                    if (valueOffset > 0) {
                        this.addText(valueBuffer, 0, valueOffset, isWhitespace);
                    }
                    this._inputOffset = inputOffset;
                    this._inputLength = inputLength;
                    ch = this.read();
                    if (ch == 47) {
                        entry = this.parseName(0, false);
                        ch = this.read();
                        if (ch != 62) {
                            throw this.error(L.l("'</{0}>' expected '>' at {1}.  Closing tags must close immediately after the tag name.", (Object)entry.getName(), (Object)XmlParser.badChar(ch)));
                        }
                        this._namespace.pop(entry);
                    } else if (XmlChar.isNameStart(ch)) {
                        this.parseElement(ch);
                        ch = this.read();
                    } else if (ch == 33) {
                        ch = this.read();
                        if (ch == 91) {
                            this.parseCdata();
                            ch = this.read();
                        } else if (ch == 45) {
                            this.parseComment();
                            ch = this.read();
                        } else {
                            if (!XmlChar.isNameStart(ch)) throw this.error(L.l("expected '<!DOCTYPE' declaration at {0}", (Object)XmlParser.badChar(ch)));
                            this.unread(ch);
                            entry = this.parseName(0, false);
                            String declName = entry.getName();
                            if (!declName.equals("DOCTYPE")) throw this.error(L.l("expected '<!DOCTYPE' declaration at {0}", (Object)declName));
                            this.parseDoctype();
                            if (this._contentHandler instanceof DOMBuilder) {
                                ((DOMBuilder)this._contentHandler).dtd(this._dtd);
                            }
                        }
                    } else {
                        if (ch != 63) throw this.error(L.l("expected tag name after '<' at {0}.  Open tag names must immediately follow the open brace like '<foo ...>'", (Object)XmlParser.badChar(ch)));
                        this.parsePI();
                    }
                    inputOffset = this._inputOffset;
                    inputLength = this._inputLength;
                    break;
                }
                default: {
                    isWhitespace = false;
                    valueBuffer[valueOffset++] = (char)ch;
                }
            }
            if (valueOffset != valueLength) continue;
            this.addText(valueBuffer, 0, valueOffset, isWhitespace);
            valueOffset = 0;
        }
    }

    private void parseDoctype() throws IOException, SAXException {
        if (this._activeNode != DOC_NAME) {
            throw this.error(L.l("<!DOCTYPE immediately follow the <?xml ...?> declaration."));
        }
        int ch = this.skipWhitespace(this.read());
        ch = this._reader.parseName(this._nameBuffer, ch);
        String name = this._nameBuffer.toString();
        ch = this.skipWhitespace(ch);
        if (this._dtd == null) {
            this._dtd = new QDocumentType(name);
        }
        this._dtd.setName(name);
        if (XmlChar.isNameStart(ch)) {
            ch = this.parseExternalID(ch);
            ch = this.skipWhitespace(ch);
            this._dtd._publicId = this._extPublicId;
            this._dtd._systemId = this._extSystemId;
        }
        if (this._dtd._systemId != null && !this._dtd._systemId.equals("")) {
            Object is = null;
            this.unread(ch);
            XmlReader oldReader = this._reader;
            boolean hasInclude = false;
            try {
                this.pushInclude(this._extPublicId, this._extSystemId);
                hasInclude = true;
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINER, e.toString(), e);
                }
                log.finer(e.toString());
            }
            if (hasInclude) {
                this._stopOnIncludeEnd = true;
                try {
                    DtdParser dtdParser = new DtdParser(this, this._dtd);
                    ch = dtdParser.parseDoctypeDecl(this._dtd);
                }
                catch (XmlParseException e) {
                    if (this._extSystemId != null && this._extSystemId.startsWith("http")) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                    throw e;
                }
                this._stopOnIncludeEnd = false;
                while (this._reader != null && this._reader != oldReader) {
                    this.popInclude();
                }
            }
            if (this._reader != null) {
                ch = this.skipWhitespace(this.read());
            }
        }
        if (ch == 91) {
            DtdParser dtdParser = new DtdParser(this, this._dtd);
            ch = dtdParser.parseDoctypeDecl(this._dtd);
        }
        if ((ch = this.skipWhitespace(ch)) != 62) {
            throw this.error(L.l("expected '>' in <!DOCTYPE at {0}", (Object)XmlParser.badChar(ch)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseElement(int ch) throws IOException, SAXException {
        QElementDef elementDef;
        this.unread(ch);
        SaxIntern.Entry entry = this.parseName(0, false);
        this._namespace.push(entry);
        ch = this.read();
        if (ch != 62 && ch != 47) {
            ch = this.parseAttributes(ch, true);
        } else {
            this._attributes.clear();
        }
        QName qName = entry.getQName();
        if (this._isValidating && this._dtd != null && (elementDef = this._dtd.getElement(qName.getLocalPart())) != null) {
            elementDef.fillDefaults(this._attributes);
        }
        this._contentHandler.startElement(entry.getUri(), entry.getLocalName(), entry.getName(), this._attributes);
        this._hasTopElement = true;
        if (ch == 47) {
            ch = this.read();
            if (ch != 62) throw this.error(L.l("unexpected character {0} after '/', expected '/>'", (Object)XmlParser.badChar(ch), (Object)entry.getName()));
            this._contentHandler.endElement(entry.getUri(), entry.getLocalName(), entry.getName());
            this._namespace.pop(entry);
            return;
        } else {
            if (ch == 62) return;
            throw this.error(L.l("unexpected character {0} while parsing '{1}' attributes.  Expected an attribute name or '>' or '/>'.  XML element syntax is:\n  <name attr-1=\"value-1\" ... attr-n=\"value-n\">", (Object)XmlParser.badChar(ch), (Object)entry.getName()));
        }
    }

    private int parseAttributes(int ch, boolean isElement) throws IOException, SAXException {
        this._attributes.clear();
        this._attrNames.clear();
        this._attrValues.clear();
        while (ch != -1) {
            boolean hasWhitespace = false;
            while (ch <= 32 && (ch == 32 || ch == 9 || ch == 13 || ch == 10)) {
                hasWhitespace = true;
                ch = this.read();
            }
            if (!XmlChar.isNameStart(ch)) break;
            if (!hasWhitespace) {
                throw this.error(L.l("attributes must be separated by whitespace"));
            }
            hasWhitespace = false;
            this.unread(ch);
            SaxIntern.Entry entry = this.parseName(0, true);
            ch = this.read();
            while (ch <= 32 && (ch == 32 || ch == 9 || ch == 13 || ch == 10)) {
                ch = this.read();
            }
            String value = null;
            if (ch != 61) {
                throw this.error(L.l("attribute '{0}' expects value at {1}.  XML requires attributes to have explicit values.", (Object)entry.getName(), (Object)XmlParser.badChar(ch)));
            }
            ch = this.read();
            while (ch <= 32 && (ch == 32 || ch == 9 || ch == 13 || ch == 10)) {
                ch = this.read();
            }
            value = this.parseValue(ch);
            ch = this.read();
            if (entry.isXmlns()) {
                String prefix = entry.getPrefix() != null ? entry.getLocalName() : "";
                String uri = value;
                if (this._isXmlnsPrefix) {
                    this._contentHandler.startPrefixMapping(prefix, uri);
                }
                if (!isElement || !this._isXmlnsAttribute) continue;
                this._attributes.add(entry.getQName(), uri);
                continue;
            }
            this._attrNames.add(entry);
            this._attrValues.add(value);
        }
        int len = this._attrNames.size();
        for (int i = 0; i < len; ++i) {
            SaxIntern.Entry attrEntry = this._attrNames.get(i);
            String value = this._attrValues.get(i);
            QName name = attrEntry.getQName();
            this._attributes.add(name, value);
        }
        return ch;
    }

    private int parseEntityReference() throws IOException, SAXException {
        int ch = this.read();
        if (ch == 35) {
            this.addText((char)this.parseCharacterReference());
            return this.read();
        }
        if (XmlChar.isNameStart(ch)) {
            if ((ch = this._reader.parseName(this._buf, ch)) != 59 && this._strictXml) {
                throw this.error(L.l("'&{0};' expected ';' at {0}.  Entity references have a '&name;' syntax.", (Object)this._buf, (Object)XmlParser.badChar(ch)));
            }
            if (ch != 59) {
                this.addText('&');
                this.addText(this._buf.toString());
                return ch;
            }
            this.addEntityReference(this._buf.toString());
            ch = this.read();
            return ch;
        }
        if (this._strictXml) {
            throw this.error(L.l("expected name at {0}", (Object)XmlParser.badChar(ch)));
        }
        this.addText('&');
        return ch;
    }

    private int parseCharacterReference() throws IOException, SAXException {
        int ch = this.read();
        int radix = 10;
        if (ch == 120) {
            radix = 16;
            ch = this.read();
        }
        int value = 0;
        while (ch != 59) {
            if (ch >= 48 && ch <= 57) {
                value = radix * value + ch - 48;
            } else if (radix == 16 && ch >= 97 && ch <= 102) {
                value = radix * value + ch - 97 + 10;
            } else if (radix == 16 && ch >= 65 && ch <= 70) {
                value = radix * value + ch - 65 + 10;
            } else {
                throw this.error(L.l("malformed entity ref at {0}", (Object)XmlParser.badChar(ch)));
            }
            ch = this.read();
        }
        if (value > 65535) {
            throw this.error(L.l("malformed entity ref at {0}", (Object)("" + value)));
        }
        if (this._strictCharacters && !this.isChar(value)) {
            throw this.error(L.l("illegal character ref at {0}", (Object)XmlParser.badChar(value)));
        }
        return value;
    }

    private void addEntityReference(String name) throws IOException, SAXException {
        QEntity entity;
        boolean expand;
        boolean bl = expand = !this._entitiesAsText || this._hasDoctype;
        if (!expand) {
            this.addText("&" + name + ";");
            return;
        }
        int ch = this._entities.getEntity(name);
        if (ch >= 0 && ch <= 65535) {
            this.addText((char)ch);
            return;
        }
        QEntity qEntity = entity = this._dtd == null ? null : this._dtd.getEntity(name);
        if (!this._expandEntities) {
            this.addText("&" + name + ";");
            return;
        }
        if (!(entity != null || this._dtd != null && this._dtd.getName() != null && this._dtd.isExternal())) {
            throw this.error(L.l("'&{0};' is an unknown entity.  XML predefines only '&lt;', '&amp;', '&gt;', '&apos;' and  '&quot;'. All other entities must be defined in an &lt;!ENTITY> definition in the DTD.", (Object)name));
        }
        if (entity != null) {
            if (entity._isSpecial && entity._value != null) {
                this.addText(entity._value);
            } else if (entity.getSystemId() != null) {
                if (!this.pushSystemEntity(entity)) {
                    if (this._contentHandler instanceof DOMBuilder) {
                        ((DOMBuilder)this._contentHandler).entityReference(name);
                    } else {
                        this.addText("&" + name + ";");
                    }
                }
            } else if (expand && entity._value != null) {
                this.setMacro(entity._value);
            } else {
                this.addText("&" + name + ";");
            }
        } else if (this._contentHandler instanceof DOMBuilder) {
            ((DOMBuilder)this._contentHandler).entityReference(name);
        } else {
            this.addText("&" + name + ";");
        }
    }

    private boolean pushSystemEntity(QEntity entity) throws IOException, SAXException {
        String publicId = entity.getPublicId();
        String systemId = entity.getSystemId();
        Object value = null;
        InputSource source = null;
        ReadStream is = null;
        if (this._entityResolver != null) {
            source = this._entityResolver.resolveEntity(publicId, systemId);
        }
        if (source != null && source.getByteStream() != null) {
            is = Vfs.openRead(source.getByteStream());
        } else if (source != null && source.getCharacterStream() != null) {
            is = Vfs.openRead(source.getCharacterStream());
        } else if (source != null && source.getSystemId() != null && this._searchPath.lookup(source.getSystemId()).isFile()) {
            this._owner.addDepend(this._searchPath.lookup(source.getSystemId()));
            is = this._searchPath.lookup(source.getSystemId()).openRead();
        } else if (systemId != null && !systemId.equals("")) {
            String path = systemId;
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if (this._searchPath.lookup(path).isFile()) {
                this._owner.addDepend(this._searchPath.lookup(path));
                is = this._searchPath.lookup(path).openRead();
            }
        }
        if (is == null) {
            return false;
        }
        this._filename = systemId;
        this._systemId = systemId;
        Path oldSearchPath = this._searchPath;
        Path path = is.getPath();
        if (path != null) {
            this._owner.addDepend(path);
            if (this._searchPath != null) {
                this._searchPath = path.getParent();
                this._reader.setSearchPath(oldSearchPath);
            }
        }
        this._is = is;
        this._line = 1;
        XmlReader oldReader = this._reader;
        this._reader = null;
        this.parseXMLDeclaration(oldReader);
        return true;
    }

    private boolean isAttributeChar(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return false;
            }
            case 34: 
            case 39: 
            case 60: 
            case 61: 
            case 62: {
                return false;
            }
        }
        return true;
    }

    private int parsePI() throws IOException, SAXException {
        int ch = this.read();
        if (!XmlChar.isNameStart(ch)) {
            throw this.error(L.l("expected name after '<?' at {0}.  Processing instructions expect a name like <?foo ... ?>", (Object)XmlParser.badChar(ch)));
        }
        ch = this._reader.parseName(this._text, ch);
        String piName = this._text.toString();
        if (!piName.equals("xml")) {
            return this.parsePITail(piName, ch);
        }
        throw this.error(L.l("<?xml ... ?> occurs after content.  The <?xml ... ?> prolog must be at the document start."));
    }

    private int parsePITail(String piName, int ch) throws IOException, SAXException {
        ch = this.skipWhitespace(ch);
        this._text.clear();
        while (ch != -1) {
            if (ch == 63) {
                ch = this.read();
                if (ch == 62) break;
                this._text.append('?');
                continue;
            }
            this._text.append((char)ch);
            ch = this.read();
        }
        this._contentHandler.processingInstruction(piName, this._text.toString());
        return this.read();
    }

    private void parseComment() throws IOException, SAXException {
        int ch = this.read();
        if (ch != 45) {
            throw this.error(L.l("expected comment at {0}", (Object)XmlParser.badChar(ch)));
        }
        ch = this.read();
        if (!this._skipComments) {
            this._buf.clear();
        }
        block0: while (ch != -1) {
            if (ch == 45) {
                ch = this.read();
                while (ch == 45) {
                    ch = this.read();
                    if (ch == 62) break block0;
                    if (this._strictComments) {
                        throw this.error(L.l("XML forbids '--' in comments"));
                    }
                    if (ch == 45) {
                        if (this._skipComments) continue;
                        this._buf.append('-');
                        continue;
                    }
                    if (this._skipComments) break;
                    this._buf.append("--");
                    break;
                }
                this._buf.append('-');
                continue;
            }
            if (!XmlChar.isChar(ch)) {
                throw this.error(L.l("bad character {0}", (Object)XmlParser.hex(ch)));
            }
            this._buf.append((char)ch);
            ch = this.read();
        }
        if (!this._skipComments) {
            if (this._contentHandler instanceof XMLWriter && !this._skipComments) {
                ((XMLWriter)((Object)this._contentHandler)).comment(this._buf.toString());
                this._isIgnorableWhitespace = true;
            } else if (this._lexicalHandler != null) {
                this._lexicalHandler.comment(this._buf.getBuffer(), 0, this._buf.getLength());
                this._isIgnorableWhitespace = true;
            }
        }
    }

    private void parseCdata() throws IOException, SAXException {
        int ch = this.read();
        if (ch != 67 || (ch = this.read()) != 68 || (ch = this.read()) != 65 || (ch = this.read()) != 84 || (ch = this.read()) != 65 || (ch = this.read()) != 91) {
            throw this.error(L.l("expected '<![CDATA[' at {0}", (Object)XmlParser.badChar(ch)));
        }
        ch = this.read();
        if (this._lexicalHandler != null) {
            this._lexicalHandler.startCDATA();
        }
        block0: while (ch != -1) {
            if (ch == 93) {
                ch = this.read();
                while (ch == 93) {
                    ch = this.read();
                    if (ch == 62) break block0;
                    if (ch == 93) {
                        this.addText(']');
                        continue;
                    }
                    this.addText(']');
                    break;
                }
                this.addText(']');
                continue;
            }
            if (this._strictCharacters && !this.isChar(ch)) {
                throw this.error(L.l("expected character in cdata at {0}", (Object)XmlParser.badChar(ch)));
            }
            this.addText((char)ch);
            ch = this.read();
        }
        if (this._lexicalHandler != null) {
            this._lexicalHandler.endCDATA();
        }
    }

    private void addPEReference(CharBuffer value, String name) throws IOException, SAXException {
        QEntity entity = this._dtd.getParameterEntity(name);
        if (entity == null && !this._dtd.isExternal()) {
            throw this.error(L.l("'%{0};' is an unknown parameter entity.  Parameter entities must be defined in an <!ENTITY> declaration before use.", (Object)name));
        }
        if (entity != null && entity._value != null) {
            this.setMacro(entity._value);
        } else if (entity != null && entity.getSystemId() != null) {
            this.pushInclude(entity.getPublicId(), entity.getSystemId());
        } else {
            value.append("%");
            value.append(name);
            value.append(";");
        }
    }

    private static String toAttrDefault(CharBuffer text) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\"') {
                text.delete(i, i + 1);
                text.insert(i, "&#34;");
                --i;
                continue;
            }
            if (ch != '\'') continue;
            text.delete(i, i + 1);
            text.insert(i, "&#39;");
            --i;
        }
        return text.toString();
    }

    private int parseExternalID(int ch) throws IOException, SAXException {
        ch = this._reader.parseName(this._text, ch);
        String key = this._text.toString();
        ch = this.skipWhitespace(ch);
        this._extSystemId = null;
        this._extPublicId = null;
        if (key.equals("PUBLIC")) {
            this._extPublicId = this.parseValue(ch);
            ch = this.skipWhitespace(this.read());
            if (this._extPublicId.indexOf(38) > 0) {
                throw this.error(L.l("Illegal character '&' in PUBLIC identifier '{0}'", (Object)this._extPublicId));
            }
            this._extSystemId = this.parseValue(ch);
            ch = this.skipWhitespace(this.read());
        } else if (key.equals("SYSTEM")) {
            this._extSystemId = this.parseValue(ch);
            ch = this.read();
        } else {
            throw this.error(L.l("expected PUBLIC or SYSTEM at '{0}'", (Object)key));
        }
        return ch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseValue(int ch) throws IOException, SAXException {
        int end = ch;
        char[] valueBuffer = this._valueBuffer;
        int valueLength = 0;
        if (end != 39 && end != 34) {
            valueBuffer[valueLength++] = (char)end;
            ch = this.read();
            while (ch >= 0 && XmlChar.isNameChar(ch)) {
                valueBuffer[valueLength++] = (char)ch;
                ch = this.read();
            }
            String value = new String(valueBuffer, 0, valueLength);
            throw this.error(L.l("XML attribute value must be quoted at '{0}'.  XML attribute syntax is either attr=\"value\" or attr='value'.", (Object)value));
        }
        ch = this.read();
        while (ch >= 0 && ch != end) {
            if (ch == 38) {
                ch = this.read();
                if (ch == 35) {
                    valueBuffer[valueLength++] = (char)this.parseCharacterReference();
                } else if (XmlChar.isNameStart(ch)) {
                    QEntity entity;
                    ch = this._reader.parseName(this._buf, ch);
                    String name = this._buf.toString();
                    if (ch != 59) {
                        throw this.error(L.l("expected '{0}' at {1}", (Object)";", (Object)XmlParser.badChar(ch)));
                    }
                    int lookup = this._entities.getEntity(name);
                    if (lookup >= 0 && lookup <= 65535) {
                        ch = this.read();
                        valueBuffer[valueLength++] = (char)lookup;
                        continue;
                    }
                    QEntity qEntity = entity = this._dtd == null ? null : this._dtd.getEntity(name);
                    if (entity == null || entity._value == null) throw this.error(L.l("expected local reference at '&{0};'", (Object)name));
                    this.setMacroAttr(entity._value);
                }
            } else {
                if (ch == 13 && (ch = this.read()) != 10) {
                    valueBuffer[valueLength++] = 10;
                    continue;
                }
                valueBuffer[valueLength++] = (char)ch;
            }
            ch = this.read();
        }
        return new String(valueBuffer, 0, valueLength);
    }

    private boolean isWhitespace(int ch) {
        return ch <= 32 && (ch == 32 || ch == 9 || ch == 10 || ch == 13);
    }

    private boolean isChar(int ch) {
        return ch >= 32 && ch <= 55295 || ch == 9 || ch == 10 || ch == 13 || ch >= 57344 && ch <= 65533;
    }

    private static String hex(int value) {
        CharBuffer cb = CharBuffer.allocate();
        for (int b = 3; b >= 0; --b) {
            int v = value >> 4 * b & 0xF;
            if (v < 10) {
                cb.append((char)(v + 48));
                continue;
            }
            cb.append((char)(v - 10 + 97));
        }
        return cb.close();
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    int getColumn() {
        return -1;
    }

    int getNodeLine() {
        if (this._elementTop > 0) {
            return this._elementLines[this._elementTop - 1];
        }
        return 1;
    }

    public String getPublicId() {
        if (this._reader != null) {
            return this._reader.getPublicId();
        }
        return this._publicId;
    }

    public String getSystemId() {
        if (this._reader != null) {
            return this._reader.getSystemId();
        }
        if (this._systemId != null) {
            return this._systemId;
        }
        return this._filename;
    }

    public void setLine(int line) {
        this._line = line;
    }

    public int getLineNumber() {
        return this.getLine();
    }

    public int getColumnNumber() {
        return this.getColumn();
    }

    private void addText(String s) throws IOException, SAXException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.addText(s.charAt(i));
        }
    }

    private void addText(char ch) throws IOException, SAXException {
        if (this._textLength > 0 && this._textBuffer[this._textLength - 1] == '\r') {
            this._textBuffer[this._textLength - 1] = 10;
            if (ch == '\n') {
                return;
            }
        }
        if (this._isIgnorableWhitespace && !XmlChar.isWhitespace(ch)) {
            this._isIgnorableWhitespace = false;
        }
        this._textBuffer[this._textLength++] = ch;
    }

    private void addText(char[] buffer, int offset, int length, boolean isWhitespace) throws IOException, SAXException {
        if (length <= 0) {
            return;
        }
        if (this._namespace.getDepth() == 1) {
            if (!isWhitespace) {
                throw this.error(L.l("expected top element at '{0}'", (Object)new String(buffer, offset, length)));
            }
            this._contentHandler.ignorableWhitespace(buffer, offset, length);
        } else {
            this._contentHandler.characters(buffer, offset, length);
        }
    }

    private SaxIntern.Entry parseName(int offset, boolean isAttribute) throws IOException {
        char[] inputBuf = this._inputBuffer;
        int inputLength = this._inputLength;
        int inputOffset = this._inputOffset;
        char[] valueBuf = this._valueBuffer;
        int valueLength = offset;
        int colon = 0;
        while (true) {
            if (inputOffset < inputLength) {
                char ch;
                if (XML_NAME_CHAR[ch = inputBuf[inputOffset++]]) {
                    valueBuf[valueLength++] = ch;
                    continue;
                }
                if (ch == ':') {
                    if (colon <= 0) {
                        colon = valueLength;
                    }
                    valueBuf[valueLength++] = ch;
                    continue;
                }
                this._inputOffset = inputOffset - 1;
                return this._intern.add(valueBuf, offset, valueLength - offset, colon, isAttribute);
            }
            if (!this.fillBuffer()) break;
            inputLength = this._inputLength;
            inputOffset = 0;
        }
        return this._intern.add(valueBuf, offset, valueLength - offset, colon, isAttribute);
    }

    final int skipWhitespace(int ch) throws IOException, SAXException {
        while (ch <= 32 && (ch == 32 || ch == 9 || ch == 10 || ch == 13)) {
            ch = this.read();
        }
        return ch;
    }

    public void setReader(XmlReader reader) {
        this._reader = reader;
    }

    void setMacroAttr(String text) throws IOException, SAXException {
        if (this._reader != this._macro) {
            this._macro.init(this, this._reader);
            this._reader = this._macro;
        }
        int j = this._macroIndex;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\'') {
                this._macro.add("&#39;");
                continue;
            }
            if (ch == '\"') {
                this._macro.add("&#34;");
                continue;
            }
            this._macro.add(ch);
        }
    }

    void pushInclude(String systemId) throws IOException, SAXException {
        this.pushInclude(null, systemId);
    }

    void pushInclude(String publicId, String systemId) throws IOException, SAXException {
        InputStream stream = this.openStream(systemId, publicId);
        if (stream == null) {
            throw new FileNotFoundException(systemId);
        }
        this._is = Vfs.openRead(stream);
        Path oldSearchPath = this._searchPath;
        Path path = this._is.getPath();
        if (path != null) {
            this._owner.addDepend(path);
            if (this._searchPath != null) {
                this._searchPath = path.getParent();
                this._reader.setSearchPath(oldSearchPath);
            }
        }
        this._filename = systemId;
        XmlReader oldReader = this._reader;
        this._reader = null;
        this._line = 1;
        this.parseXMLDeclaration(oldReader);
        int ch = this.read();
        XmlReader reader = this._reader;
        if (reader instanceof MacroReader) {
            reader = reader.getNext();
        }
        reader.setSystemId(systemId);
        reader.setFilename(systemId);
        reader.setPublicId(publicId);
        reader.setNext(oldReader);
        this.unread(ch);
    }

    private void popInclude() throws IOException, SAXException {
        XmlReader oldReader = this._reader;
        this._reader = this._reader.getNext();
        oldReader.setNext(null);
        this._filename = this._reader.getFilename();
        this._line = this._reader.getLine();
        this._is = this._reader.getReadStream();
        if (this._reader.getSearchPath() != null) {
            this._searchPath = this._reader.getSearchPath();
        }
    }

    void setMacro(String text) throws IOException, SAXException {
        if (this._reader != this._macro) {
            if (this._macro.getNext() == null) {
                this._macro.init(this, this._reader);
                this._reader = this._macro;
            } else {
                this._macro = new MacroReader();
                this._macro.init(this, this._reader);
                this._reader = this._macro;
            }
        }
        this._macro.add(text);
    }

    protected final int read() throws IOException, SAXException {
        int inputOffset = this._inputOffset;
        if (inputOffset < this._inputLength) {
            char ch = this._inputBuffer[inputOffset];
            this._inputOffset = inputOffset + 1;
            return ch;
        }
        if (this.fillBuffer()) {
            return this._inputBuffer[this._inputOffset++];
        }
        return -1;
    }

    public final void unread(int ch) {
        if (ch < 0 || this._inputOffset <= 0) {
            return;
        }
        --this._inputOffset;
    }

    protected boolean fillBuffer() throws IOException {
        int len = this._is.read(this._inputBuffer, 0, this._inputBuffer.length);
        if (len >= 0) {
            this._inputLength = len;
            this._inputOffset = 0;
            return true;
        }
        this._inputLength = 0;
        this._inputOffset = 0;
        return false;
    }

    private void parseXMLDeclaration(XmlReader oldReader) throws IOException, SAXException {
        int startOffset = this._is.getOffset();
        boolean isEBCDIC = false;
        int ch = this._is.read();
        XmlReader reader = null;
        if (ch == 254) {
            ch = this._is.read();
            if (ch == 255) {
                this._owner.setAttribute("encoding", "UTF-16");
                this._is.setEncoding("utf-16");
                reader = new Utf16Reader(this, this._is);
                ch = reader.read();
            }
        } else if (ch == 255) {
            ch = this._is.read();
            if (ch == 254) {
                this._owner.setAttribute("encoding", "UTF-16");
                this._is.setEncoding("utf-16");
                reader = new Utf16Reader(this, this._is);
                ((Utf16Reader)reader).setReverse(true);
                ch = reader.read();
            }
        } else if (ch == 0) {
            ch = this._is.read();
            this._owner.setAttribute("encoding", "UTF-16");
            this._is.setEncoding("utf-16");
            reader = new Utf16Reader(this, this._is);
        } else if (ch == 239) {
            ch = this._is.read();
            if (ch == 187 && (ch = this._is.read()) == 191) {
                ch = this._is.read();
                this._owner.setAttribute("encoding", "UTF-8");
                this._is.setEncoding("utf-8");
                reader = new Utf8Reader(this, this._is);
            }
        } else if (ch == 76) {
            this._is.unread();
            this._is.setEncoding("cp500");
            isEBCDIC = true;
            reader = new XmlReader(this, this._is);
            ch = reader.read();
        } else {
            int ch2 = this._is.read();
            if (ch2 == 0) {
                this._owner.setAttribute("encoding", "UTF-16LE");
                this._is.setEncoding("utf-16le");
                reader = new Utf16Reader(this, this._is);
                ((Utf16Reader)reader).setReverse(true);
            } else if (ch2 > 0) {
                this._is.unread();
            }
        }
        if (reader == null || reader == oldReader) {
            reader = this._is.getSource() instanceof ReaderWriterStream ? new XmlReader(this, this._is) : new Utf8Reader(this, this._is);
        }
        if (ch == 10) {
            reader.setLine(2);
        }
        reader.setSystemId(this._systemId);
        if (this._systemId == null) {
            reader.setSystemId(this._filename);
        }
        reader.setFilename(this._filename);
        reader.setPublicId(this._publicId);
        reader.setNext(oldReader);
        this._reader = reader;
        if (ch != 60) {
            this.unreadByte(ch);
            return;
        }
        if (this.parseXMLDecl(this._reader) && isEBCDIC) {
            this._is.setOffset(startOffset);
            ch = this.read();
            if (ch != 60) {
                throw new IllegalStateException();
            }
            this.parseXMLDecl(this._reader);
        }
    }

    private boolean parseXMLDecl(XmlReader reader) throws IOException, SAXException {
        int ch = this.readByte();
        if (ch != 63) {
            this.unreadByte((char)ch);
            this.unreadByte(60);
            return false;
        }
        ch = this.read();
        if (!XmlChar.isNameStart(ch)) {
            throw this.error(L.l("expected name after '<?' at {0}.  Processing instructions expect a name like <?foo ... ?>", (Object)XmlParser.badChar(ch)));
        }
        ch = this._reader.parseName(this._text, ch);
        String piName = this._text.toString();
        if (!piName.equals("xml")) {
            ch = this.parsePITail(piName, ch);
            this.unreadByte(ch);
            return false;
        }
        if ((ch = this.parseAttributes(ch, false)) != 63) {
            throw this.error(L.l("expected '?' at {0}.  Processing instructions end with '?>' like <?foo ... ?>", (Object)XmlParser.badChar(ch)));
        }
        ch = this.read();
        if (ch != 62) {
            throw this.error(L.l("expected '>' at {0}.  Processing instructions end with '?>' like <?foo ... ?>", (Object)">", (Object)XmlParser.badChar(ch)));
        }
        for (int i = 0; i < this._attributes.getLength(); ++i) {
            QName name = this._attributes.getName(i);
            String value = this._attributes.getValue(i);
            if (this._owner != null) {
                this._owner.setAttribute(name.getLocalPart(), value);
            }
            if (!name.getLocalPart().equals("encoding")) continue;
            String encoding = value;
            if (this._isStaticEncoding || encoding.equalsIgnoreCase("UTF-8") || encoding.equalsIgnoreCase("UTF-16") || this._is.getSource() instanceof ReaderWriterStream) continue;
            this._is.setEncoding(encoding);
            XmlReader oldReader = this._reader;
            this._reader = new XmlReader(this, this._is);
            this._reader.setLine(oldReader.getLine());
            this._reader.setSystemId(this._filename);
            this._reader.setPublicId(null);
        }
        return true;
    }

    protected int readByte() throws IOException {
        return this._is.read();
    }

    protected void unreadByte(int ch) {
        this._is.unread();
    }

    XmlParseException error(String text) {
        if (this._errorHandler != null) {
            SAXParseException e = new SAXParseException(text, this._locator);
            try {
                this._errorHandler.fatalError(e);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        return new XmlParseException(this._filename + ":" + this._line + ": " + text);
    }

    public void free() {
    }

    int parseName(CharBuffer cb, int ch) throws IOException, SAXException {
        return this._reader.parseName(cb, ch);
    }

    static String badChar(int ch) {
        if (ch < 0 || ch == 65535) {
            return L.l("end of file");
        }
        if (ch == 10 || ch == 13) {
            return L.l("end of line");
        }
        if (ch >= 32 && ch <= 127) {
            return "'" + (char)ch + "'";
        }
        return "'" + (char)ch + "' (\\u" + XmlParser.hex(ch) + ")";
    }

    private void printDebugNode(WriteStream s, Node node, int depth) throws IOException {
        if (node == null) {
            return;
        }
        for (int i = 0; i < depth; ++i) {
            s.print(' ');
        }
        if (node.getFirstChild() != null) {
            s.println("<" + node.getNodeName() + ">");
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.printDebugNode(s, child, depth + 2);
            }
            for (int i = 0; i < depth; ++i) {
                s.print(' ');
            }
            s.println("</" + node.getNodeName() + ">");
        } else {
            s.println("<" + node.getNodeName() + "/>");
        }
    }

    public void close() {
        TempCharBuffer tempInputBuffer = this._tempInputBuffer;
        this._tempInputBuffer = null;
        this._inputBuffer = null;
        if (tempInputBuffer != null) {
            TempCharBuffer.free(tempInputBuffer);
        }
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            XmlParser.XML_NAME_CHAR[i] = XmlChar.isNameChar(i) && i != 58;
        }
    }

    public static class LocatorImpl
    implements ExtendedLocator {
        XmlParser _parser;

        LocatorImpl(XmlParser parser) {
            this._parser = parser;
        }

        @Override
        public String getSystemId() {
            if (this._parser._reader != null && this._parser._reader.getSystemId() != null) {
                return this._parser._reader.getSystemId();
            }
            if (this._parser.getSystemId() != null) {
                return this._parser.getSystemId();
            }
            if (this._parser._reader != null && this._parser._reader.getFilename() != null) {
                return this._parser._reader.getFilename();
            }
            if (this._parser.getFilename() != null) {
                return this._parser.getFilename();
            }
            return null;
        }

        @Override
        public String getFilename() {
            if (this._parser._reader != null && this._parser._reader.getFilename() != null) {
                return this._parser._reader.getFilename();
            }
            if (this._parser.getFilename() != null) {
                return this._parser.getFilename();
            }
            if (this._parser._reader != null && this._parser._reader.getSystemId() != null) {
                return this._parser._reader.getSystemId();
            }
            if (this._parser.getSystemId() != null) {
                return this._parser.getSystemId();
            }
            return null;
        }

        @Override
        public String getPublicId() {
            if (this._parser._reader != null) {
                return this._parser._reader.getPublicId();
            }
            return this._parser.getPublicId();
        }

        @Override
        public int getLineNumber() {
            if (this._parser._reader != null) {
                return this._parser._reader.getLine();
            }
            return this._parser.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this._parser.getColumnNumber();
        }
    }
}

