/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.Period;
import com.caucho.env.log.LogSystem;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import java.util.logging.Level;
import javax.annotation.PostConstruct;
import javax.ejb.Startup;
import javax.inject.Singleton;

@Startup
@Singleton
@Configurable
public class LogService {
    private static final L10N L = new L10N(LogService.class);
    private LogSystem _logSystem = Resin.getCurrent().createLogSystem();

    @PostConstruct
    public void init() {
        this._logSystem.init();
    }

    @Deprecated
    @Configurable
    public void setEnable(boolean isEnable) {
    }

    @Deprecated
    @Configurable
    public void setPath(String path) {
    }

    @Configurable
    public void setLevel(String level) throws ConfigException {
        try {
            this._logSystem.setLevel(Level.parse(level.toUpperCase()));
        }
        catch (Exception e) {
            throw new ConfigException(L.l("'{0}' is an unknown log level.  Log levels are:\noff - disable logging\nsevere - severe errors only\nwarning - warnings\ninfo - information\nconfig - configuration\nfine - fine debugging\nfiner - finer debugging\nfinest - finest debugging\nall - all debugging", (Object)level));
        }
    }

    @Configurable
    public void setExpireTimeout(Period period) {
        this._logSystem.setExpireTimeout(period.getPeriod());
    }
}

