/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AbstractJmxAction;
import com.caucho.admin.action.AdminAction;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.JmxSetQueryReply;
import com.caucho.util.L10N;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class SetJmxAction
extends AbstractJmxAction
implements AdminAction {
    private static final Logger log = Logger.getLogger(SetJmxAction.class.getName());
    private static final L10N L = new L10N(SetJmxAction.class);

    public JmxSetQueryReply execute(String pattern, String attributeName, String value) throws ConfigException, JMException, ClassNotFoundException {
        LinkedList<MBeanServer> servers = new LinkedList<MBeanServer>();
        servers.addAll(MBeanServerFactory.findMBeanServer(null));
        ObjectName nameQuery = ObjectName.getInstance(pattern);
        ObjectName subjectBean = null;
        MBeanServer subjectBeanServer = null;
        for (MBeanServer mBeanServer : servers) {
            for (ObjectName mbean : mBeanServer.queryNames(nameQuery, null)) {
                if (subjectBean != null) {
                    throw new ConfigException(L.l("multiple beans match `{0}'", (Object)pattern));
                }
                subjectBean = mbean;
                subjectBeanServer = mBeanServer;
            }
        }
        MBeanFeatureInfo attributeInfo = null;
        if (subjectBean != null) {
            for (MBeanAttributeInfo info : subjectBeanServer.getMBeanInfo(subjectBean).getAttributes()) {
                if (!info.getName().equals(attributeName)) continue;
                attributeInfo = info;
                break;
            }
        }
        if (subjectBean == null) {
            throw new ConfigException(L.l("no beans match `{0}'", (Object)pattern));
        }
        if (attributeInfo == null) {
            throw new ConfigException(L.l("bean at `{0}' does not appear to have attribute `{1}'", (Object)pattern, (Object)attributeName));
        }
        Object object = subjectBeanServer.getAttribute(subjectBean, attributeInfo.getName());
        Object attribValue = SetJmxAction.toValue(((MBeanAttributeInfo)attributeInfo).getType(), value);
        Attribute attribute = new Attribute(attributeName, attribValue);
        subjectBeanServer.setAttribute(subjectBean, attribute);
        JmxSetQueryReply reply = new JmxSetQueryReply(subjectBean.getCanonicalName(), attributeName, String.valueOf(object), String.valueOf(attribValue));
        return reply;
    }
}

