/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.VersionFactory;
import com.caucho.amber.type.ListenerType;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ListenerComponent
extends ClassComponent {
    private static final L10N L = new L10N(ListenerComponent.class);
    private String _baseClassName;
    private String _extClassName;
    private ListenerType _listenerType;

    public void setListenerType(ListenerType listenerType) {
        this._listenerType = listenerType;
    }

    public void setBaseClassName(String baseClassName) {
        this._baseClassName = baseClassName;
    }

    public String getBaseClassName() {
        return this._baseClassName;
    }

    public void setExtClassName(String extClassName) {
        this._extClassName = extClassName;
    }

    public String getClassName() {
        return this._extClassName;
    }

    public String getBeanClassName() {
        return this._baseClassName;
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        this.generateHeader(out);
        this.generateMainCallback(out, this._listenerType);
        this.generateCallbacks(out, 1, this._listenerType);
        this.generateCallbacks(out, 2, this._listenerType);
        this.generateCallbacks(out, 3, this._listenerType);
        this.generateCallbacks(out, 4, this._listenerType);
        this.generateCallbacks(out, 5, this._listenerType);
        this.generateCallbacks(out, 6, this._listenerType);
        this.generateCallbacks(out, 7, this._listenerType);
    }

    private void generateHeader(JavaWriter out) throws IOException {
        out.println("/*");
        out.println(" * Generated by Resin Amber");
        out.println(" * " + VersionFactory.getVersion());
        out.println(" */");
        out.print("private static final java.util.logging.Logger __caucho_log = ");
        out.println("java.util.logging.Logger.getLogger(\"" + this.getBeanClassName() + "\");");
        out.println();
    }

    private void generateMainCallback(JavaWriter out, ListenerType listenerType) throws IOException {
        out.println("public void __caucho_callback(int callbackIndex, Object entity)");
        out.println("{");
        out.pushDepth();
        out.println("switch (callbackIndex) {");
        out.println("case com.caucho.amber.entity.Listener.PRE_PERSIST:");
        out.println("  __caucho_prePersist(entity);");
        out.println("  break;");
        out.println("case com.caucho.amber.entity.Listener.POST_PERSIST:");
        out.println("  __caucho_postPersist(entity);");
        out.println("  break;");
        out.println("case com.caucho.amber.entity.Listener.PRE_REMOVE:");
        out.println("  __caucho_preRemove(entity);");
        out.println("  break;");
        out.println("case com.caucho.amber.entity.Listener.POST_REMOVE:");
        out.println("  __caucho_postRemove(entity);");
        out.println("  break;");
        out.println("case com.caucho.amber.entity.Listener.PRE_UPDATE:");
        out.println("  __caucho_preUpdate(entity);");
        out.println("  break;");
        out.println("case com.caucho.amber.entity.Listener.POST_UPDATE:");
        out.println("  __caucho_postUpdate(entity);");
        out.println("  break;");
        out.println("case com.caucho.amber.entity.Listener.POST_LOAD:");
        out.println("  __caucho_postLoad(entity);");
        out.println("  break;");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateCallbacks(JavaWriter out, int callbackIndex, ListenerType listenerType) throws IOException {
        String name = ListenerComponent.toCallbackName(callbackIndex);
        out.println("public void __caucho_" + name + "(Object entity)");
        out.println("{");
        out.pushDepth();
        ArrayList<Method> callbacks = null;
        ListenerType parentType = listenerType;
        do {
            switch (callbackIndex) {
                case 1: {
                    callbacks = parentType.getPrePersistCallbacks();
                    break;
                }
                case 2: {
                    callbacks = parentType.getPostPersistCallbacks();
                    break;
                }
                case 3: {
                    callbacks = parentType.getPreRemoveCallbacks();
                    break;
                }
                case 4: {
                    callbacks = parentType.getPostRemoveCallbacks();
                    break;
                }
                case 5: {
                    callbacks = parentType.getPreUpdateCallbacks();
                    break;
                }
                case 6: {
                    callbacks = parentType.getPostUpdateCallbacks();
                    break;
                }
                case 7: {
                    callbacks = parentType.getPostLoadCallbacks();
                }
            }
        } while (callbacks.size() <= 0 && (parentType = parentType.getParentType()) != null);
        if (callbacks.size() > 0) {
            for (Method method : callbacks) {
                Class<?>[] params = method.getParameterTypes();
                out.print("this.");
                out.print(method.getName());
                out.println("((" + params[0].getName() + ") entity);");
            }
        }
        out.popDepth();
        out.println("}");
    }

    private static String toCallbackName(int callbackIndex) {
        switch (callbackIndex) {
            case 1: {
                return "prePersist";
            }
            case 2: {
                return "postPersist";
            }
            case 3: {
                return "preRemove";
            }
            case 4: {
                return "postRemove";
            }
            case 5: {
                return "preUpdate";
            }
            case 6: {
                return "postUpdate";
            }
            case 7: {
                return "postLoad";
            }
        }
        return null;
    }
}

