/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.idgen.AmberTableGenerator;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.LongType;
import com.caucho.amber.type.StringType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.HashMap;

public class GeneratorTableType
extends AmberType {
    private static final L10N L = new L10N(GeneratorTableType.class);
    private AmberPersistenceUnit _amberPersistenceUnit;
    private AmberTable _table;
    private String _keyColumn = "GEN_KEY";
    private String _valueColumn = "GEN_VALUE";
    private HashMap<String, AmberTableGenerator> _genMap = new HashMap();

    public GeneratorTableType(AmberPersistenceUnit amberPersistenceUnit, String name) {
        this._amberPersistenceUnit = amberPersistenceUnit;
        this._table = amberPersistenceUnit.createTable(name);
    }

    public AmberPersistenceUnit getAmberManager() {
        return this._amberPersistenceUnit;
    }

    @Override
    public String getName() {
        return "Generator";
    }

    public AmberTable getTable() {
        return this._table;
    }

    public String getKeyColumn() {
        return this._keyColumn;
    }

    public String getValueColumn() {
        return this._valueColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmberTableGenerator createGenerator(String name) {
        HashMap<String, AmberTableGenerator> hashMap = this._genMap;
        synchronized (hashMap) {
            AmberTableGenerator gen = this._genMap.get(name);
            if (gen == null) {
                gen = new AmberTableGenerator(this.getAmberManager(), this, name);
                this._genMap.put(name, gen);
            }
            return gen;
        }
    }

    @Override
    public void init() throws ConfigException {
        AmberColumn keyColumn = this.getTable().createColumn(this._keyColumn, StringType.create());
        keyColumn.setPrimaryKey(true);
        keyColumn.setLength(254);
        AmberColumn valueColumn = this.getTable().createColumn(this._valueColumn, LongType.create());
    }

    public void start() {
        if (this.getAmberManager().getCreateDatabaseTables()) {
            this.getTable().createDatabaseTable(this.getAmberManager());
        }
        for (AmberTableGenerator gen : this._genMap.values()) {
            try {
                gen.init(this.getAmberManager());
            }
            catch (SQLException e) {
                throw ConfigException.create(e);
            }
        }
    }

    public String toString() {
        return "GeneratorTableType[" + this.getName() + "]";
    }
}

