/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.BooleanType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;

public class PrimitiveBooleanType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveBooleanType.class);
    private static final PrimitiveBooleanType BOOLEAN_TYPE = new PrimitiveBooleanType();

    private PrimitiveBooleanType() {
    }

    public static PrimitiveBooleanType create() {
        return BOOLEAN_TYPE;
    }

    @Override
    public String getName() {
        return "boolean";
    }

    @Override
    public AmberType getForeignType() {
        return BooleanType.create();
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(16, length, precision, scale);
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getBoolean(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getBoolean(columnNames[" + index + "])");
        return index + 1;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setBoolean(" + index + "++, " + value + ");");
    }

    @Override
    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.BIT);");
    }

    @Override
    public String toObject(String value) {
        return "((" + value + ") ? Boolean.TRUE : Boolean.FALSE)";
    }

    @Override
    public String generateCastFromObject(String value) {
        return "((Boolean) " + value + ").booleanValue()";
    }

    @Override
    public String generateIsNull(String value) {
        return "! (" + value + ")";
    }
}

