/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.stream;

import com.caucho.amp.actor.AmpActorRef;
import com.caucho.amp.stream.AmpEncoder;
import com.caucho.amp.stream.AmpError;
import com.caucho.amp.stream.AmpStream;
import com.caucho.amp.stream.NullEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractAmpStream
implements AmpStream {
    private static final Logger log = Logger.getLogger(AbstractAmpStream.class.getName());

    @Override
    public void send(AmpActorRef to, AmpActorRef from, AmpEncoder encoder, String methodName, Object ... args) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " send '" + methodName + "' from=" + from + " is ignored");
        }
        from.error(to, NullEncoder.ENCODER, new AmpError());
    }

    @Override
    public void query(long id, AmpActorRef to, AmpActorRef from, AmpEncoder encoder, String methodName, Object ... args) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " query-result from=" + from + " is ignored");
        }
        from.queryError(id, to, NullEncoder.ENCODER, new AmpError());
    }

    @Override
    public void queryResult(long id, AmpActorRef to, AmpActorRef from, AmpEncoder encoder, Object result) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " query-result from=" + from + " is ignored");
        }
    }

    @Override
    public void queryError(long id, AmpActorRef to, AmpActorRef from, AmpEncoder encoder, AmpError error) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " query-error from=" + from + " is ignored");
        }
    }

    @Override
    public void error(AmpActorRef to, AmpActorRef from, AmpEncoder encoder, AmpError error) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " error from=" + from + " is ignored");
        }
    }
}

