/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmqpFrameReader
extends InputStream {
    private static final Logger log = Logger.getLogger(AmqpFrameReader.class.getName());
    private static final L10N L = new L10N(AmqpFrameReader.class);
    private ReadStream _is;
    private int _size;
    private int _doff;
    private int _type;
    private int _extra;
    private int _offset;

    public AmqpFrameReader() {
    }

    public AmqpFrameReader(ReadStream is) {
        this.init(is);
    }

    public void init(ReadStream is) {
        this._is = is;
    }

    public int getSize() {
        return this._size;
    }

    public int getOffset() {
        return this._offset;
    }

    public boolean startFrame() throws IOException {
        int ch;
        ReadStream is = this._is;
        try {
            ch = is.read();
            if (ch < 0) {
                return false;
            }
        }
        catch (IOException e) {
            log.log(Level.FINEST, e.toString(), e);
            return false;
        }
        this._size = ((ch & 0xFF) << 24) + ((is.read() & 0xFF) << 16) + ((is.read() & 0xFF) << 8) + (is.read() & 0xFF);
        this._doff = is.read() & 0xFF;
        this._type = is.read() & 0xFF;
        int e1 = is.read() & 0xFF;
        ch = is.read();
        if (ch < 0) {
            throw new EOFException(L.l("Unexpected end of file"));
        }
        this._extra = ((e1 & 0xFF) << 8) + (ch & 0xFF);
        this._offset = 8;
        return true;
    }

    public void finishFrame() throws IOException {
        int delta = this._size - this._offset;
        this._offset = this._size;
        if (delta > 0) {
            this._is.skip(delta);
        }
    }

    @Override
    public int read() throws IOException {
        if (this._size <= this._offset) {
            return -1;
        }
        ++this._offset;
        int value = this._is.read();
        return value;
    }
}

