/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpAbstractPacket;
import com.caucho.amqp.io.AmqpBaseWriter;
import com.caucho.amqp.io.AmqpConstants;
import com.caucho.amqp.io.AmqpStreamWriter;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class AmqpWriter
implements AmqpConstants {
    private static final L10N L = new L10N(AmqpWriter.class);
    private AmqpBaseWriter _os;

    public void init(OutputStream os) {
        this._os = new AmqpStreamWriter(Vfs.openWrite(os));
    }

    public void initBase(AmqpBaseWriter os) {
        this._os = os;
    }

    public void writeNull() throws IOException {
        this._os.write(64);
    }

    public void writeBoolean(boolean value) throws IOException {
        this._os.write(value ? 65 : 66);
    }

    public void writeByte(int value) throws IOException {
        AmqpBaseWriter os = this._os;
        os.write(81);
        os.write(value);
    }

    public void writeUbyte(int value) throws IOException {
        AmqpBaseWriter os = this._os;
        os.write(80);
        os.write(value);
    }

    public void writeShort(int value) throws IOException {
        AmqpBaseWriter os = this._os;
        os.write(97);
        os.write(value >> 8);
        os.write(value);
    }

    public void writeUshort(int value) throws IOException {
        AmqpBaseWriter os = this._os;
        os.write(96);
        os.write(value >> 8);
        os.write(value);
    }

    public void writeInt(int value) throws IOException {
        AmqpBaseWriter os = this._os;
        if (value == 0) {
            os.write(67);
        } else if (-128 <= value && value <= 127) {
            os.write(84);
            os.write(value);
        } else {
            os.write(113);
            os.write(value >> 24);
            os.write(value >> 16);
            os.write(value >> 8);
            os.write(value);
        }
    }

    public void writeUint(int value) throws IOException {
        AmqpBaseWriter os = this._os;
        if (value == 0) {
            os.write(67);
        } else if (value >= 0 && value <= 255) {
            os.write(82);
            os.write(value);
        } else {
            os.write(112);
            os.write(value >> 24);
            os.write(value >> 16);
            os.write(value >> 8);
            os.write(value);
        }
    }

    public void writeLong(long value) throws IOException {
        AmqpBaseWriter os = this._os;
        if (value == 0L) {
            os.write(68);
        } else if (-128L <= value && value <= 127L) {
            os.write(85);
            os.write((int)value);
        } else {
            os.write(129);
            os.write((int)(value >> 56));
            os.write((int)(value >> 48));
            os.write((int)(value >> 40));
            os.write((int)(value >> 32));
            os.write((int)(value >> 24));
            os.write((int)(value >> 16));
            os.write((int)(value >> 8));
            os.write((int)value);
        }
    }

    public void writeUlong(long value) throws IOException {
        AmqpBaseWriter os = this._os;
        if (value == 0L) {
            os.write(68);
        } else if (0L <= value && value <= 255L) {
            os.write(83);
            os.write((int)value);
        } else {
            os.write(128);
            os.write((int)(value >> 56));
            os.write((int)(value >> 48));
            os.write((int)(value >> 40));
            os.write((int)(value >> 32));
            os.write((int)(value >> 24));
            os.write((int)(value >> 16));
            os.write((int)(value >> 8));
            os.write((int)value);
        }
    }

    public void writeTimestamp(long value) throws IOException {
        AmqpBaseWriter os = this._os;
        os.write(131);
        os.write((int)(value >> 56));
        os.write((int)(value >> 48));
        os.write((int)(value >> 40));
        os.write((int)(value >> 32));
        os.write((int)(value >> 24));
        os.write((int)(value >> 16));
        os.write((int)(value >> 8));
        os.write((int)value);
    }

    public void writeString(String value) throws IOException {
        AmqpBaseWriter os = this._os;
        if (value == null) {
            os.write(64);
            return;
        }
        int len = this.calculateUtf8Length(value);
        if (len <= 255) {
            os.write(161);
            os.write(len);
        } else {
            os.write(177);
            os.write(len >> 24);
            os.write(len >> 16);
            os.write(len >> 8);
            os.write(len);
        }
        for (int i = 0; i < value.length(); ++i) {
            os.write(value.charAt(i));
        }
    }

    private int calculateUtf8Length(String value) {
        int strlen = value.length();
        int len = 0;
        for (int i = 0; i < strlen; ++i) {
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                ++len;
                continue;
            }
            if (ch < '\u0800') {
                len += 2;
                continue;
            }
            len += 3;
        }
        return len;
    }

    public void writeSymbol(String value) throws IOException {
        AmqpBaseWriter os = this._os;
        if (value == null) {
            os.write(64);
            return;
        }
        int len = value.length();
        if (len <= 255) {
            os.write(163);
            os.write(len);
        } else {
            os.write(179);
            os.write(len >> 24);
            os.write(len >> 16);
            os.write(len >> 8);
            os.write(len);
        }
        for (int i = 0; i < len; ++i) {
            os.write(value.charAt(i));
        }
    }

    public void writeBinary(byte[] buffer) throws IOException {
        if (buffer == null) {
            this._os.write(64);
            return;
        }
        this.writeBinary(buffer, 0, buffer.length);
    }

    public void writeBinary(byte[] buffer, int offset, int length) throws IOException {
        AmqpBaseWriter os = this._os;
        if (buffer == null) {
            os.write(64);
            return;
        }
        if (length <= 255) {
            os.write(160);
            os.write(length);
            os.write(buffer, offset, length);
        } else {
            os.write(176);
            this.writeInt(length);
            os.write(buffer, offset, length);
        }
    }

    public void writeDescriptor(long code) throws IOException {
        AmqpBaseWriter os = this._os;
        os.write(0);
        this.writeUlong(code);
    }

    public void writeObject(AmqpAbstractPacket value) throws IOException {
        if (value != null) {
            value.write(this);
        } else {
            this.writeNull();
        }
    }

    public void writeObject(Object value) throws IOException {
        if (value == null) {
            this.writeNull();
            return;
        }
        if (value instanceof Long) {
            this.writeLong((Long)value);
        } else {
            this.writeString((String)value);
        }
    }

    public void writeList(List<?> list) throws IOException {
        AmqpBaseWriter os = this._os;
        if (list == null) {
            os.write(64);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public int startList() throws IOException {
        AmqpBaseWriter os = this._os;
        os.write(192);
        os.write(255);
        os.write(255);
        return os.getOffset();
    }

    public void finishList(int startOffset, int count) {
        AmqpBaseWriter os = this._os;
        int finishOffset = os.getOffset();
        os.writeByte(startOffset - 2, finishOffset - startOffset);
        os.writeByte(startOffset - 1, count);
    }

    public void writeArray(List<?> list) throws IOException {
        AmqpBaseWriter os = this._os;
        if (list == null) {
            os.write(64);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public int startArray(int code) throws IOException {
        AmqpBaseWriter os = this._os;
        os.write(224);
        os.write(255);
        os.write(255);
        int offset = os.getOffset();
        os.write(code);
        return offset;
    }

    public void finishArray(int startOffset, int count) {
        AmqpBaseWriter os = this._os;
        int finishOffset = os.getOffset();
        os.writeByte(startOffset - 2, finishOffset - startOffset);
        os.writeByte(startOffset - 1, count);
    }

    private void writeSymbolValue(String value) throws IOException {
        AmqpBaseWriter os = this._os;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            os.write(value.charAt(i));
        }
    }

    public void writeSymbolArray(List<String> list) throws IOException {
        AmqpBaseWriter os = this._os;
        if (list == null || list.size() == 0) {
            os.write(64);
            return;
        }
        if (list.size() == 1) {
            this.writeSymbol(list.get(0));
            return;
        }
        int offset = this.startArray(163);
        for (int i = 0; i < list.size(); ++i) {
            String value = list.get(i);
            os.write(value.length());
            this.writeSymbolValue(value);
        }
        this.finishArray(offset, list.size());
    }

    public void writeMap(Map<?, ?> map) throws IOException {
        AmqpBaseWriter os = this._os;
        if (map == null || map.isEmpty()) {
            os.write(64);
            return;
        }
        int startOffset = this.startMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.writeObject(entry.getKey());
            this.writeObject(entry.getValue());
        }
        this.finishMap(startOffset, map.size());
    }

    public void writeAnnotationsMap(Map<?, ?> map) throws IOException {
        AmqpBaseWriter os = this._os;
        if (map == null || map.isEmpty()) {
            os.write(64);
            return;
        }
        int startOffset = this.startMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                this.writeSymbol((String)key);
            } else if (key instanceof Number) {
                this.writeUlong(((Number)key).longValue());
            } else {
                throw new IllegalArgumentException(L.l("'{0}' is an invalid amqp annotations key", (Object)key.getClass().getName()));
            }
            this.writeObject(entry.getValue());
        }
        this.finishMap(startOffset, map.size());
    }

    public void writeFieldsMap(Map<?, ?> map) throws IOException {
        AmqpBaseWriter os = this._os;
        if (map == null || map.isEmpty()) {
            os.write(64);
            return;
        }
        int startOffset = this.startMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            this.writeSymbol((String)key);
            this.writeObject(entry.getValue());
        }
        this.finishMap(startOffset, map.size());
    }

    public int startMap() throws IOException {
        AmqpBaseWriter os = this._os;
        os.write(193);
        os.write(255);
        os.write(255);
        return os.getOffset();
    }

    public void finishMap(int startOffset, int count) {
        AmqpBaseWriter os = this._os;
        int finishOffset = os.getOffset();
        os.writeByte(startOffset - 2, finishOffset - startOffset);
        os.writeByte(startOffset - 1, count);
    }

    public void flush() throws IOException {
        this._os.flush();
    }
}

