/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.common.DeliveryNode;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.AmqpWriter;
import com.caucho.amqp.io.DeliveryState;
import java.io.IOException;
import java.util.Map;

public class DeliveryModified
extends DeliveryState {
    private boolean _isDeliveryFailed;
    private boolean _isUndeliverableHere;
    private Map<String, ?> _messageAnnotations;

    public boolean isDeliveryFailed() {
        return this._isDeliveryFailed;
    }

    public void setDeliveryFailed(boolean isFailed) {
        this._isDeliveryFailed = isFailed;
    }

    public boolean isUndeliverableHere() {
        return this._isUndeliverableHere;
    }

    public void setUndeliverableHere(boolean isUndeliverable) {
        this._isUndeliverableHere = isUndeliverable;
    }

    @Override
    public void update(long xid, DeliveryNode node) {
        node.onModified(xid, this.isDeliveryFailed(), this.isUndeliverableHere());
    }

    @Override
    public long getDescriptorCode() {
        return 39L;
    }

    @Override
    public DeliveryModified createInstance() {
        return new DeliveryModified();
    }

    @Override
    public void readBody(AmqpReader in, int count) throws IOException {
        this._isDeliveryFailed = in.readBoolean();
        this._isUndeliverableHere = in.readBoolean();
        this._messageAnnotations = in.readFieldMap();
    }

    @Override
    public int writeBody(AmqpWriter out) throws IOException {
        out.writeBoolean(this._isDeliveryFailed);
        out.writeBoolean(this._isUndeliverableHere);
        out.writeMap(this._messageAnnotations);
        return 3;
    }
}

