/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpAbstractComposite;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.AmqpWriter;
import java.io.IOException;

public class MessageHeader
extends AmqpAbstractComposite {
    private boolean _isDurable;
    private int _priority = -1;
    private long _ttl = -1L;
    private boolean _isFirstAcquirer;
    private int _deliveryCount = -1;

    public boolean isDurable() {
        return this._isDurable;
    }

    public void setDurable(boolean durable) {
        this._isDurable = durable;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public void setDeliveryCount(int deliveryCount) {
        this._deliveryCount = deliveryCount;
    }

    public void setFirstAcquirer(boolean isFirstAcquirer) {
        this._isFirstAcquirer = isFirstAcquirer;
    }

    public void setTimeToLive(long timeToLive) {
        this._ttl = timeToLive;
    }

    public long getTimeToLive() {
        return this._ttl;
    }

    @Override
    public long getDescriptorCode() {
        return 112L;
    }

    @Override
    public MessageHeader createInstance() {
        return new MessageHeader();
    }

    @Override
    public void readBody(AmqpReader in, int count) throws IOException {
        this._isDurable = in.readBoolean();
        this._priority = in.readInt();
        if (in.isNull()) {
            this._priority = -1;
        }
        this._ttl = in.readLong();
        if (in.isNull()) {
            this._ttl = -1L;
        }
        this._isFirstAcquirer = in.readBoolean();
        this._deliveryCount = in.readInt();
    }

    @Override
    public int writeBody(AmqpWriter out) throws IOException {
        out.writeBoolean(this._isDurable);
        if (this._priority >= 0) {
            out.writeUbyte(this._priority);
        } else {
            out.writeNull();
        }
        if (this._ttl >= 0L) {
            out.writeUint((int)this._ttl);
        } else {
            out.writeNull();
        }
        out.writeBoolean(this._isFirstAcquirer);
        out.writeUint(this._deliveryCount);
        return 5;
    }
}

