/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.packet;

import com.caucho.bam.BamError;
import com.caucho.bam.packet.Packet;
import com.caucho.bam.stream.MessageStream;
import java.io.Serializable;

public class Query
extends Packet {
    private final long _id;
    private final Serializable _value;

    public Query(long id, String to, String from, Serializable value) {
        super(to, from);
        this._id = id;
        this._value = value;
    }

    public long getId() {
        return this._id;
    }

    public Serializable getValue() {
        return this._value;
    }

    @Override
    public void dispatch(MessageStream handler, MessageStream toSource) {
        try {
            handler.query(this.getId(), this.getTo(), this.getFrom(), this.getValue());
        }
        catch (RuntimeException e) {
            toSource.queryError(this.getId(), this.getFrom(), this.getTo(), this.getValue(), BamError.create(e));
            throw e;
        }
        catch (Error e) {
            toSource.queryError(this.getId(), this.getFrom(), this.getTo(), this.getValue(), BamError.create(e));
            throw e;
        }
    }

    @Override
    public void dispatchError(MessageStream handler, MessageStream toSource, BamError error) {
        toSource.queryError(this.getId(), this.getFrom(), this.getTo(), this.getValue(), error);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append("id=");
        sb.append(this._id);
        if (this.getTo() != null) {
            sb.append(",to=");
            sb.append(this.getTo());
        }
        if (this.getFrom() != null) {
            sb.append(",from=");
            sb.append(this.getFrom());
        }
        if (this._value != null) {
            sb.append("," + this._value.getClass().getName());
        }
        sb.append("]");
        return sb.toString();
    }
}

