/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractStartCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestartCommand
extends AbstractStartCommand {
    private static Logger _log;
    private static L10N _L;

    @Override
    public String getDescription() {
        return "restarts a Resin server";
    }

    @Override
    public boolean isStart() {
        return true;
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try {
            client.restartWatchdog(args.getArgv());
            System.out.println(RestartCommand.L().l("Resin/{0} restarted{1} for watchdog at {2}:{3}", (Object)VersionFactory.getVersion(), (Object)this.getServerUsageArg(args, client.getId()), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort()));
        }
        catch (Exception e) {
            System.out.println(RestartCommand.L().l("Resin/{0} can't restart{1}.\n{2}", (Object)VersionFactory.getVersion(), (Object)this.getServerUsageArg(args, client.getId()), (Object)e.toString()));
            RestartCommand.log().log(Level.FINE, e.toString(), e);
            System.exit(1);
        }
        return 0;
    }

    @Override
    public boolean isRetry() {
        return true;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(RestartCommand.class.getName());
        }
        return _log;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(RestartCommand.class);
        }
        return _L;
    }
}

